package org.beigesoft.accounting.persistable;

/*
 * Copyright (c) 2016 Beigesoft ™
 *
 * Licensed under the GNU General Public License (GPL), Version 2.0
 * (the "License");
 * you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
 */

import org.beigesoft.persistable.AHasNameIdLongVersion;

/**
 * <pre>
 * Model of Warehouse Place e.g. room#1.
 * Nonautogenerated ID is Integer type for best performance
 * cause String is slower
 * </pre>
 *
 * @author Yury Demidenko
 */
public class WarehouseSite extends AHasNameIdLongVersion {

  /**
   * <p>Warehouse.</p>
   **/
  private Warehouse warehouse;

  //Simple getters and setters:
  /**
   * <p>Geter for warehouse.</p>
   * @return Warehouse
   **/
  public final Warehouse getWarehouse() {
    return this.warehouse;
  }

  /**
   * <p>Setter for warehouse.</p>
   * @param pWarehouse reference
   **/
  public final void setWarehouse(final Warehouse pWarehouse) {
    this.warehouse = pWarehouse;
  }
}
