/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.persistable.BankStatementLine;
import org.beigesoft.accounting.persistable.PaymentFrom;
import org.beigesoft.accounting.persistable.PaymentTo;
import org.beigesoft.accounting.persistable.PrepaymentFrom;
import org.beigesoft.accounting.persistable.PrepaymentTo;
import org.beigesoft.accounting.service.ISrvTypeCode;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IHasId;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcBankStatementLineGfe<RS>
implements IEntityProcessor<BankStatementLine, Long> {
    private IEntityProcessor<BankStatementLine, Long> prcEntityPbEditDelete;
    private ISrvOrm<RS> srvOrm;
    private ISrvTypeCode srvTypeCode;

    public final BankStatementLine process(Map<String, Object> pReqVars, BankStatementLine pEntity, IRequestData pRequestData) throws Exception {
        String amountStr;
        BankStatementLine bsl = (BankStatementLine)this.prcEntityPbEditDelete.process(pReqVars, (IHasId)pEntity, pRequestData);
        if (bsl.getResultAction() != null) {
            throw new ExceptionWithCode(403, "attempt_to_edit_completed_bank_statement_line");
        }
        if (bsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            amountStr = bsl.getItsAmount().toString();
        } else if (bsl.getItsAmount().compareTo(BigDecimal.ZERO) < 0) {
            amountStr = bsl.getItsAmount().negate().toString();
        } else {
            throw new ExceptionWithCode(1003, "amount_is_zero");
        }
        long[] startEnd = this.evalDayStartEndFor(bsl.getItsDate());
        String dWhere = "where HASMADEACCENTRIES=1 and REVERSEDID is null and ITSTOTAL=" + amountStr + " and ITSDATE >= " + startEnd[0] + " and ITSDATE <= " + startEnd[1];
        HashSet<String> ndFlDoc = new HashSet<String>();
        ndFlDoc.add("itsId");
        ndFlDoc.add("idDatabaseBirth");
        ndFlDoc.add("idBirth");
        ndFlDoc.add("itsTotal");
        ndFlDoc.add("itsDate");
        ndFlDoc.add("description");
        if (bsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            pReqVars.put("PrepaymentFromneededFields", ndFlDoc);
            List prepaymentsFrom = this.getSrvOrm().retrieveListWithConditions(pReqVars, PrepaymentFrom.class, dWhere);
            pReqVars.remove("PrepaymentFromneededFields");
            if (prepaymentsFrom.size() > 0) {
                pRequestData.setAttribute("prepayments", (Object)prepaymentsFrom);
            }
            pReqVars.put("PaymentFromneededFields", ndFlDoc);
            List paymentsFrom = this.getSrvOrm().retrieveListWithConditions(pReqVars, PaymentFrom.class, dWhere);
            pReqVars.remove("PaymentFromneededFields");
            if (paymentsFrom.size() > 0) {
                pRequestData.setAttribute("payments", (Object)paymentsFrom);
            }
            String eWhereD = "where REVERSEDID is null and SOURCETYPE in (3,1010) and SUBACCDEBITTYPE=2002 and SUBACCDEBITID=" + bsl.getItsOwner().getBankAccount().getItsId() + " and DEBIT=" + amountStr + " and ITSDATE >= " + startEnd[0] + " and ITSDATE <= " + startEnd[1];
            List entriesFrom = this.getSrvOrm().retrieveListWithConditions(pReqVars, AccountingEntry.class, eWhereD);
            if (entriesFrom.size() > 0) {
                pRequestData.setAttribute("accentries", (Object)entriesFrom);
            }
        } else {
            pReqVars.put("PrepaymentToneededFields", ndFlDoc);
            List prepaymentsTo = this.getSrvOrm().retrieveListWithConditions(pReqVars, PrepaymentTo.class, dWhere);
            pReqVars.remove("PrepaymentToneededFields");
            if (prepaymentsTo.size() > 0) {
                pRequestData.setAttribute("prepayments", (Object)prepaymentsTo);
            }
            pReqVars.put("PaymentToneededFields", ndFlDoc);
            List paymentsTo = this.getSrvOrm().retrieveListWithConditions(pReqVars, PaymentTo.class, dWhere);
            pReqVars.remove("PaymentToneededFields");
            if (paymentsTo.size() > 0) {
                pRequestData.setAttribute("payments", (Object)paymentsTo);
            }
            String eWhereC = "where REVERSEDID is null and SOURCETYPE in (3,1010) and SUBACCCREDITTYPE=2002 and SUBACCCREDITID=" + bsl.getItsOwner().getBankAccount().getItsId() + " and CREDIT=" + amountStr + " and ITSDATE >= " + startEnd[0] + " and ITSDATE <= " + startEnd[1];
            List entriesTo = this.getSrvOrm().retrieveListWithConditions(pReqVars, AccountingEntry.class, eWhereC);
            if (entriesTo.size() > 0) {
                pRequestData.setAttribute("accentries", (Object)entriesTo);
            }
        }
        pRequestData.setAttribute("typeCodeSubaccMap", this.srvTypeCode.getTypeCodeMap());
        return bsl;
    }

    public final long[] evalDayStartEndFor(Date pDateFor) {
        Calendar cal = Calendar.getInstance(new Locale("en", "US"));
        cal.setTime(pDateFor);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long[] result = new long[2];
        result[0] = cal.getTimeInMillis();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        result[1] = cal.getTimeInMillis();
        return result;
    }

    public final IEntityProcessor<BankStatementLine, Long> getPrcEntityPbEditDelete() {
        return this.prcEntityPbEditDelete;
    }

    public final void setPrcEntityPbEditDelete(IEntityProcessor<BankStatementLine, Long> pPrcEntityPbEditDelete) {
        this.prcEntityPbEditDelete = pPrcEntityPbEditDelete;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTypeCode getSrvTypeCode() {
        return this.srvTypeCode;
    }

    public final void setSrvTypeCode(ISrvTypeCode pSrvTypeCode) {
        this.srvTypeCode = pSrvTypeCode;
    }
}

