/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.EBankEntryStatus;
import org.beigesoft.accounting.persistable.BankCsvMethod;
import org.beigesoft.accounting.persistable.BankStatement;
import org.beigesoft.accounting.persistable.BankStatementLine;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.CsvColumn;
import org.beigesoft.service.ICsvReader;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcBankStatementSave<RS>
implements IEntityProcessor<BankStatement, Long> {
    private ISrvOrm<RS> srvOrm;
    private ICsvReader csvReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BankStatement process(Map<String, Object> pAddParam, BankStatement pEntity, IRequestData pRequestData) throws Exception {
        String fileToUploadName = (String)pRequestData.getAttribute("fileToUploadName");
        if (fileToUploadName != null) {
            String bankCsvMethodId = pRequestData.getParameter("bankCsvMethod");
            BankCsvMethod bankCsvMethod = (BankCsvMethod)((Object)this.getSrvOrm().retrieveEntityById(pAddParam, BankCsvMethod.class, (Object)Long.parseLong(bankCsvMethodId)));
            bankCsvMethod.getCsvMethod().setColumns(this.getSrvOrm().retrieveListWithConditions(pAddParam, CsvColumn.class, "where ITSOWNER=" + bankCsvMethod.getCsvMethod().getItsId()));
            pEntity.setSourceName(fileToUploadName + "/" + bankCsvMethod.getItsName());
            if (pEntity.getIsNew().booleanValue()) {
                this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            } else {
                this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity);
            }
            InputStreamReader reader = null;
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(bankCsvMethod.getDateCol().getDataFormat());
            }
            catch (Exception ee) {
                throw new ExceptionWithCode(1002, "Wrong date format! Format: " + bankCsvMethod.getDateCol().getDataFormat(), (Throwable)ee);
            }
            String[] seps = null;
            if (bankCsvMethod.getAmountCol().getDataFormat() != null) {
                try {
                    seps = bankCsvMethod.getAmountCol().getDataFormat().split(",");
                    for (int i = 0; i < 2; ++i) {
                        if ("SPACE".equals(seps[i])) {
                            seps[i] = " ";
                            continue;
                        }
                        if (!"COMMA".equals(seps[i])) continue;
                        seps[i] = ",";
                    }
                }
                catch (Exception ee) {
                    throw new ExceptionWithCode(1002, "Wrong amount format! Format: " + bankCsvMethod.getAmountCol().getDataFormat(), (Throwable)ee);
                }
            }
            try {
                List csvRow;
                InputStream ins = (InputStream)pRequestData.getAttribute("fileToUploadInputStream");
                reader = new InputStreamReader(ins, Charset.forName(bankCsvMethod.getCsvMethod().getCharsetName()).newDecoder());
                int r = 0;
                while ((csvRow = this.csvReader.readNextRow(pAddParam, (Reader)reader, bankCsvMethod.getCsvMethod())) != null) {
                    if (++r == 1 && bankCsvMethod.getCsvMethod().getHasHeader().booleanValue()) continue;
                    BankStatementLine bsl = new BankStatementLine();
                    bsl.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    bsl.setItsOwner(pEntity);
                    String dateStr = (String)csvRow.get(bankCsvMethod.getDateCol().getItsIndex() - 1);
                    try {
                        bsl.setItsDate(sdf.parse(dateStr));
                    }
                    catch (Exception ee) {
                        throw new ExceptionWithCode(1003, "Wrong date value! Value/Format: " + dateStr + "/" + bankCsvMethod.getDateCol().getDataFormat(), (Throwable)ee);
                    }
                    String amountStr = (String)csvRow.get(bankCsvMethod.getAmountCol().getItsIndex() - 1);
                    try {
                        if (seps != null) {
                            if (!"NONE".equals(seps[0])) {
                                amountStr = amountStr.replace(seps[0], ".");
                            }
                            if (!"NONE".equals(seps[1])) {
                                amountStr = amountStr.replace(seps[1], "");
                            }
                        }
                        bsl.setItsAmount(new BigDecimal(amountStr));
                    }
                    catch (Exception ee) {
                        throw new ExceptionWithCode(1002, "Wrong amount value! Value/Format: " + amountStr + "/" + bankCsvMethod.getAmountCol().getDataFormat(), (Throwable)ee);
                    }
                    String descr = null;
                    if (bankCsvMethod.getDescriptionCol() != null) {
                        descr = (String)csvRow.get(bankCsvMethod.getDescriptionCol().getItsIndex() - 1);
                    }
                    if (bankCsvMethod.getStatusCol() != null) {
                        String statusStr = (String)csvRow.get(bankCsvMethod.getStatusCol().getItsIndex() - 1);
                        descr = descr == null ? statusStr : descr + "/" + statusStr;
                        if (bankCsvMethod.getAcceptedWords() != null && !bankCsvMethod.getAcceptedWords().contains(statusStr)) {
                            bsl.setItsStatus(EBankEntryStatus.OTHER);
                        }
                        if (bankCsvMethod.getVoidedWords() != null && bankCsvMethod.getVoidedWords().contains(statusStr)) {
                            bsl.setItsStatus(EBankEntryStatus.VOIDED);
                        }
                    }
                    bsl.setDescriptionStatus(descr);
                    this.getSrvOrm().insertEntity(pAddParam, (Object)bsl);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity);
        }
        return pEntity;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ICsvReader getCsvReader() {
        return this.csvReader;
    }

    public final void setCsvReader(ICsvReader pCsvReader) {
        this.csvReader = pCsvReader;
    }
}

