/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.processor.UtlPurchaseGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchInvTaxLnSave<RS>
implements IEntityProcessor<PurchaseInvoiceTaxLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlPurchaseGoodsServiceLine<RS> utlPurchaseGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;

    public final PurchaseInvoiceTaxLine process(Map<String, Object> pReqVars, PurchaseInvoiceTaxLine pEntity, IRequestData pRequestData) throws Exception {
        boolean isTaxable;
        if (pEntity.getItsTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner((PurchaseInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromPurchase() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getVendor().getIsForeigner() == false;
        if (!isTaxable) {
            throw new ExceptionWithCode(1003, "non_taxable");
        }
        PurchaseInvoiceTaxLine oldEntity = (PurchaseInvoiceTaxLine)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity));
        pEntity.setTax(oldEntity.getTax());
        pEntity.setTaxableInvBas(oldEntity.getTaxableInvBas());
        pEntity.setTaxableInvBasFc(oldEntity.getTaxableInvBasFc());
        boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
        RoundingMode rm = as.getSalTaxRoundMode();
        if (pEntity.getItsOwner().getVendor().getTaxDestination() != null) {
            isItemBasis = pEntity.getItsOwner().getVendor().getTaxDestination().getSalTaxIsInvoiceBase() == false;
            rm = pEntity.getItsOwner().getVendor().getTaxDestination().getSalTaxRoundMode();
        }
        if (isItemBasis) {
            throw new ExceptionWithCode(1003, "cant_edit_item_basis_tax");
        }
        pEntity.setItsTotal(pEntity.getItsTotal().setScale((int)as.getPricePrecision(), rm));
        BigDecimal bd100 = new BigDecimal("100.00");
        BigDecimal totalTaxes = pEntity.getItsOwner().getPriceIncTax() != false ? pEntity.getTaxableInvBas().subtract(pEntity.getTaxableInvBas().divide(BigDecimal.ONE.add(pEntity.getTax().getItsPercentage().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getTaxableInvBas().multiply(pEntity.getTax().getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
        if (pEntity.getItsTotal().compareTo(totalTaxes) != 0) {
            if (pEntity.getItsOwner().getDescription() == null) {
                pEntity.getItsOwner().setDescription(pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            } else {
                pEntity.getItsOwner().setDescription(pEntity.getItsOwner().getDescription() + " " + pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, (Object)pEntity);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlPurchaseGoodsServiceLine.updateOwnerTotals(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
        return null;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlPurchaseGoodsServiceLine<RS> getUtlPurchaseGoodsServiceLine() {
        return this.utlPurchaseGoodsServiceLine;
    }

    public final void setUtlPurchaseGoodsServiceLine(UtlPurchaseGoodsServiceLine<RS> pUtlPurchaseGoodsServiceLine) {
        this.utlPurchaseGoodsServiceLine = pUtlPurchaseGoodsServiceLine;
    }
}

