/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.SalesReturn;
import org.beigesoft.accounting.persistable.SalesReturnTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcSalRetTaxLnSave<RS>
implements IEntityProcessor<SalesReturnTaxLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private String queryInvTot;

    public final SalesReturnTaxLine process(Map<String, Object> pReqVars, SalesReturnTaxLine pEntity, IRequestData pRequestData) throws Exception {
        boolean isTaxable;
        if (pEntity.getItsTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner((SalesReturn)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromSales() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getCustomer().getIsForeigner() == false;
        if (!isTaxable) {
            throw new ExceptionWithCode(1003, "non_taxable");
        }
        SalesReturnTaxLine oldEntity = (SalesReturnTaxLine)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity));
        pEntity.setTax(oldEntity.getTax());
        pEntity.setTaxableInvBas(oldEntity.getTaxableInvBas());
        boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
        RoundingMode rm = as.getSalTaxRoundMode();
        if (pEntity.getItsOwner().getCustomer().getTaxDestination() != null) {
            isItemBasis = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxIsInvoiceBase() == false;
            rm = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxRoundMode();
        }
        if (isItemBasis) {
            throw new ExceptionWithCode(1003, "cant_edit_item_basis_tax");
        }
        pEntity.setItsTotal(pEntity.getItsTotal().setScale((int)as.getPricePrecision(), rm));
        BigDecimal bd100 = new BigDecimal("100.00");
        BigDecimal totalTaxes = pEntity.getTaxableInvBas().multiply(pEntity.getTax().getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
        if (pEntity.getItsTotal().compareTo(totalTaxes) != 0) {
            if (pEntity.getItsOwner().getDescription() == null) {
                pEntity.getItsOwner().setDescription(pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            } else {
                pEntity.getItsOwner().setDescription(pEntity.getItsOwner().getDescription() + " " + pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, (Object)pEntity);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesReturn.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        String query = this.lazyGetQueryInvTot();
        query = query.replace(":ITSOWNER", pEntity.getItsOwner().getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
        this.getSrvOrm().updateEntity(pReqVars, (Object)pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", SalesReturn.class.getSimpleName());
        return null;
    }

    public final String lazyGetQueryInvTot() throws Exception {
        if (this.queryInvTot == null) {
            String flName = "/accounting/trade/salRetTot.sql";
            this.queryInvTot = this.loadString(flName);
        }
        return this.queryInvTot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcSalRetTaxLnSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcSalRetTaxLnSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final void setQueryInvTot(String pQueryInvTot) {
        this.queryInvTot = pQueryInvTot;
    }
}

