/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.CogsEntry;
import org.beigesoft.accounting.persistable.DestTaxGoodsLn;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.processor.UtlSalesGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<CogsEntry> srvCogsEntry;
    private UtlSalesGoodsServiceLine<RS> utlSalesGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    public final SalesInvoiceLine process(Map<String, Object> pReqVars, SalesInvoiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            pEntity.setItsOwner((SalesInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
            if (pEntity.getReversedId() != null) {
                SalesInvoiceLine reversed = (SalesInvoiceLine)this.getSrvOrm().retrieveEntityById(pReqVars, SalesInvoiceLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pReqVars.get("user"));
                }
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setTaxCategory(reversed.getTaxCategory());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsPrice(reversed.getItsPrice());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                pEntity.setForeignPrice(reversed.getForeignPrice());
                pEntity.setForeignSubtotal(reversed.getForeignSubtotal().negate());
                pEntity.setForeignTotalTaxes(reversed.getForeignTotalTaxes().negate());
                pEntity.setForeignTotal(reversed.getForeignTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, (Object)pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, (Object)reversed);
                this.srvWarehouseEntry.reverseDraw(pReqVars, pEntity);
                this.srvCogsEntry.reverseDraw(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
                this.getSrvOrm().deleteEntityWhere(pReqVars, SalesInvoiceGoodsTaxLine.class, "ITSOWNER=" + reversed.getItsId());
            } else {
                boolean isTaxable;
                if (pEntity.getItsQuantity().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getReversedId() == null) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
                }
                if (pEntity.getItsPrice().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new ExceptionWithCode(1003, "price_less_eq_0::" + pReqVars.get("user"));
                }
                AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
                pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getInvItem())));
                boolean bl = isTaxable = as.getIsExtractSalesTaxFromSales() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getCustomer().getIsForeigner() == false;
                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    pEntity.setItsPrice(pEntity.getForeignPrice().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getForeignTotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    }
                }
                BigDecimal totalTaxes = BigDecimal.ZERO;
                BigDecimal totalTaxesFc = BigDecimal.ZERO;
                BigDecimal bd100 = new BigDecimal("100.00");
                ArrayList<SalesInvoiceGoodsTaxLine> tls = null;
                boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
                boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
                if (isTaxable) {
                    pEntity.setTaxCategory(pEntity.getInvItem().getTaxCategory());
                    RoundingMode rm = as.getSalTaxRoundMode();
                    if (pEntity.getItsOwner().getCustomer().getTaxDestination() != null) {
                        isItemBasis = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                        isAggrOnlyRate = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxUseAggregItBas();
                        rm = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxRoundMode();
                        pReqVars.put("DestTaxGoodsLnitsOwnerdeepLevel", 1);
                        List dtls = this.getSrvOrm().retrieveListWithConditions(pReqVars, DestTaxGoodsLn.class, "where ITSOWNER=" + pEntity.getInvItem().getItsId());
                        pReqVars.remove("DestTaxGoodsLnitsOwnerdeepLevel");
                        for (DestTaxGoodsLn dtl : dtls) {
                            if (!dtl.getTaxDestination().getItsId().equals(pEntity.getItsOwner().getCustomer().getTaxDestination().getItsId())) continue;
                            pEntity.setTaxCategory(dtl.getTaxCategory());
                            break;
                        }
                    }
                    if (pEntity.getTaxCategory() != null && isItemBasis) {
                        if (!isAggrOnlyRate) {
                            if (pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                                throw new ExceptionWithCode(1003, "price_inc_tax_multi_not_imp");
                            }
                            tls = new ArrayList<SalesInvoiceGoodsTaxLine>();
                            pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                            List itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getTaxCategory().getItsId());
                            pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                            StringBuffer sb = new StringBuffer();
                            int i = 0;
                            for (InvItemTaxCategoryLine itcl : itcls) {
                                if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                                if (i++ > 0) {
                                    sb.append(", ");
                                }
                                BigDecimal addTx = pEntity.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                                totalTaxes = totalTaxes.add(addTx);
                                SalesInvoiceGoodsTaxLine iitl = new SalesInvoiceGoodsTaxLine();
                                iitl.setIsNew(true);
                                iitl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                                iitl.setItsTotal(addTx);
                                iitl.setTax(itcl.getTax());
                                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                                    BigDecimal addTxFc = pEntity.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                                    totalTaxesFc = totalTaxesFc.add(addTxFc);
                                    iitl.setForeignTotalTaxes(addTxFc);
                                }
                                tls.add(iitl);
                                sb.append(itcl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
                            }
                            pEntity.setTaxesDescription(sb.toString());
                        } else {
                            totalTaxes = pEntity.getItsOwner().getPriceIncTax() != false ? pEntity.getItsTotal().subtract(pEntity.getItsTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                            pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                            if (pEntity.getItsOwner().getForeignCurrency() != null) {
                                totalTaxesFc = pEntity.getItsOwner().getPriceIncTax().booleanValue() ? pEntity.getForeignTotal().subtract(pEntity.getForeignTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getForeignSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                            }
                        }
                    } else if (pEntity.getTaxCategory() != null) {
                        pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                    }
                }
                pEntity.setTotalTaxes(totalTaxes);
                pEntity.setForeignTotalTaxes(totalTaxesFc);
                if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                    pEntity.setSubtotal(pEntity.getItsTotal().subtract(totalTaxes));
                } else {
                    pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
                }
                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    pEntity.setForeignTotalTaxes(totalTaxesFc);
                    if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setForeignSubtotal(pEntity.getForeignTotal().subtract(totalTaxesFc));
                    } else {
                        pEntity.setForeignTotal(pEntity.getForeignSubtotal().add(totalTaxesFc));
                    }
                }
                this.getSrvOrm().insertEntity(pReqVars, (Object)pEntity);
                pEntity.setIsNew(false);
                if (tls != null) {
                    for (SalesInvoiceGoodsTaxLine iitl : tls) {
                        iitl.setItsOwner(pEntity);
                        iitl.setInvoiceId(pEntity.getItsOwner().getItsId());
                        this.getSrvOrm().insertEntity(pReqVars, (Object)iitl);
                        iitl.setIsNew(false);
                    }
                }
                this.srvWarehouseEntry.withdrawal(pReqVars, pEntity, pEntity.getWarehouseSiteFo());
                this.srvCogsEntry.withdrawal(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            }
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.utlSalesGoodsServiceLine.updateOwner(pReqVars, pEntity.getItsOwner());
            pReqVars.put("nextEntity", pEntity.getItsOwner());
            pReqVars.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pReqVars.get("user"));
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlSalesGoodsServiceLine<RS> getUtlSalesGoodsServiceLine() {
        return this.utlSalesGoodsServiceLine;
    }

    public final void setUtlSalesGoodsServiceLine(UtlSalesGoodsServiceLine<RS> pUtlSalesGoodsServiceLine) {
        this.utlSalesGoodsServiceLine = pUtlSalesGoodsServiceLine;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<CogsEntry> getSrvCogsEntry() {
        return this.srvCogsEntry;
    }

    public final void setSrvCogsEntry(ISrvDrawItemEntry<CogsEntry> pSrvCogsEntry) {
        this.srvCogsEntry = pSrvCogsEntry;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

