/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.DestTaxServSelLn;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceTaxLine;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.processor.UtlSalesGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceServiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlSalesGoodsServiceLine<RS> utlSalesGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    public final SalesInvoiceServiceLine process(Map<String, Object> pReqVars, SalesInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        boolean isTaxable;
        if (pEntity.getItsQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
        }
        if (pEntity.getItsPrice().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "price_less_or_eq_zero");
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner((SalesInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        pEntity.setService((ServiceToSale)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getService())));
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromSales() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getCustomer().getIsForeigner() == false;
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            pEntity.setItsPrice(pEntity.getForeignPrice().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                pEntity.setItsTotal(pEntity.getForeignTotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            } else {
                pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            }
        }
        BigDecimal totalTaxes = BigDecimal.ZERO;
        BigDecimal totalTaxesFc = BigDecimal.ZERO;
        BigDecimal bd100 = new BigDecimal("100.00");
        ArrayList<SalesInvoiceServiceTaxLine> tls = null;
        boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
        boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
        if (isTaxable) {
            pEntity.setTaxCategory(pEntity.getService().getTaxCategory());
            RoundingMode rm = as.getSalTaxRoundMode();
            if (pEntity.getItsOwner().getCustomer().getTaxDestination() != null) {
                isItemBasis = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                isAggrOnlyRate = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxUseAggregItBas();
                rm = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxRoundMode();
                pReqVars.put("DestTaxServSelLnitsOwnerdeepLevel", 1);
                List dtls = this.getSrvOrm().retrieveListWithConditions(pReqVars, DestTaxServSelLn.class, "where ITSOWNER=" + pEntity.getService().getItsId());
                pReqVars.remove("DestTaxServSelLnitsOwnerdeepLevel");
                for (DestTaxServSelLn dtl : dtls) {
                    if (!dtl.getTaxDestination().getItsId().equals(pEntity.getItsOwner().getCustomer().getTaxDestination().getItsId())) continue;
                    pEntity.setTaxCategory(dtl.getTaxCategory());
                    break;
                }
            }
            if (pEntity.getTaxCategory() != null && isItemBasis) {
                if (!isAggrOnlyRate) {
                    if (pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        throw new ExceptionWithCode(1003, "price_inc_tax_multi_not_imp");
                    }
                    tls = new ArrayList<SalesInvoiceServiceTaxLine>();
                    pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                    List itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getTaxCategory().getItsId());
                    pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine itcl : itcls) {
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        BigDecimal addTx = pEntity.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                        totalTaxes = totalTaxes.add(addTx);
                        SalesInvoiceServiceTaxLine iitl = new SalesInvoiceServiceTaxLine();
                        iitl.setIsNew(true);
                        iitl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        iitl.setItsTotal(addTx);
                        iitl.setTax(itcl.getTax());
                        if (pEntity.getItsOwner().getForeignCurrency() != null) {
                            BigDecimal addTxFc = pEntity.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                            totalTaxesFc = totalTaxesFc.add(addTxFc);
                            iitl.setForeignTotalTaxes(addTxFc);
                        }
                        tls.add(iitl);
                        sb.append(itcl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
                    }
                    pEntity.setTaxesDescription(sb.toString());
                } else {
                    totalTaxes = pEntity.getItsOwner().getPriceIncTax() != false ? pEntity.getItsTotal().subtract(pEntity.getItsTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                    pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                    if (pEntity.getItsOwner().getForeignCurrency() != null) {
                        totalTaxesFc = pEntity.getItsOwner().getPriceIncTax().booleanValue() ? pEntity.getForeignTotal().subtract(pEntity.getForeignTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getForeignSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                    }
                }
            } else if (pEntity.getTaxCategory() != null) {
                pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
            }
        }
        pEntity.setTotalTaxes(totalTaxes);
        pEntity.setForeignTotalTaxes(totalTaxesFc);
        if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
            pEntity.setSubtotal(pEntity.getItsTotal().subtract(totalTaxes));
        } else {
            pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
        }
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            pEntity.setForeignTotalTaxes(totalTaxesFc);
            if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                pEntity.setForeignSubtotal(pEntity.getForeignTotal().subtract(totalTaxesFc));
            } else {
                pEntity.setForeignTotal(pEntity.getForeignSubtotal().add(totalTaxesFc));
            }
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, (Object)pEntity);
            pEntity.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, (Object)pEntity);
        }
        pReqVars.put("SalesInvoiceServiceTaxLineitsOwnerdeepLevel", 1);
        List iitls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesInvoiceServiceTaxLine.class, "where ITSOWNER=" + pEntity.getItsId());
        pReqVars.remove("SalesInvoiceServiceTaxLineitsOwnerdeepLevel");
        if (tls != null) {
            for (int i = 0; i < tls.size(); ++i) {
                if (i < iitls.size()) {
                    ((SalesInvoiceServiceTaxLine)((Object)iitls.get(i))).setTax(((SalesInvoiceServiceTaxLine)((Object)tls.get(i))).getTax());
                    ((SalesInvoiceServiceTaxLine)((Object)iitls.get(i))).setItsTotal(((SalesInvoiceServiceTaxLine)((Object)tls.get(i))).getItsTotal());
                    ((SalesInvoiceServiceTaxLine)((Object)iitls.get(i))).setItsOwner(pEntity);
                    this.getSrvOrm().updateEntity(pReqVars, iitls.get(i));
                    continue;
                }
                ((SalesInvoiceServiceTaxLine)((Object)tls.get(i))).setItsOwner(pEntity);
                ((SalesInvoiceServiceTaxLine)((Object)tls.get(i))).setInvoiceId(pEntity.getItsOwner().getItsId());
                this.getSrvOrm().insertEntity(pReqVars, tls.get(i));
                ((SalesInvoiceServiceTaxLine)((Object)tls.get(i))).setIsNew(false);
            }
            for (int j = tls.size(); j < iitls.size(); ++j) {
                this.getSrvOrm().deleteEntity(pReqVars, iitls.get(j));
            }
        } else {
            for (SalesInvoiceServiceTaxLine iitl : iitls) {
                this.getSrvOrm().deleteEntity(pReqVars, (Object)iitl);
            }
        }
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlSalesGoodsServiceLine.updateOwner(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
        return null;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlSalesGoodsServiceLine<RS> getUtlSalesGoodsServiceLine() {
        return this.utlSalesGoodsServiceLine;
    }

    public final void setUtlSalesGoodsServiceLine(UtlSalesGoodsServiceLine<RS> pUtlSalesGoodsServiceLine) {
        this.utlSalesGoodsServiceLine = pUtlSalesGoodsServiceLine;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

