/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprInvLnTotal;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.IInvoiceLine;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.persistable.APersistableBaseVersion;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class UtlPurchaseGoodsServiceLine<RS> {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private String fileQuPurInvSaTaxItBasAggr = "purchInvSalTaxItBasAggr.sql";
    private String quPurInvSaTaxItBasAggr;
    private String fileQuPurInvSaTaxItBas = "purchInvSalTaxItemBasis.sql";
    private String quPurInvSaTaxItBas;
    private String fileQuPurInvSaTaxInvBas = "purchInvSalTaxInvBasis.sql";
    private String quPurInvSaTaxInvBas;
    private String fileQueryPurchaseInvoiceTotals = "purchaseInvoiceTotals.sql";
    private String queryPurchaseInvoiceTotals;
    private ISrvAccSettings srvAccSettings;

    public final void updateOwner(Map<String, Object> pReqVars, PurchaseInvoice pItsOwner) throws Exception {
        this.updateTaxLines(pReqVars, pItsOwner);
        this.updateOwnerTotals(pReqVars, pItsOwner);
    }

    public final void updateOwnerTotals(Map<String, Object> pReqVars, PurchaseInvoice pItsOwner) throws Exception {
        String query = this.lazyGetQueryPurchaseInvoiceTotals();
        query = query.replace(":ITSOWNER", pItsOwner.getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "ITSTOTAL", "TOTALTAXES", "FOREIGNSUBTOTAL", "FOREIGNTOTAL", "FOREIGNTOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        if (totals[2] == null) {
            totals[2] = 0.0;
        }
        if (totals[3] == null) {
            totals[3] = 0.0;
        }
        if (totals[4] == null) {
            totals[4] = 0.0;
        }
        if (totals[5] == null) {
            totals[5] = 0.0;
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        if (pItsOwner.getPriceIncTax().booleanValue()) {
            pItsOwner.setItsTotal(BigDecimal.valueOf(totals[1]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setSubtotal(pItsOwner.getItsTotal().subtract(pItsOwner.getTotalTaxes()));
            pItsOwner.setForeignTotal(BigDecimal.valueOf(totals[4]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setForeignSubtotal(pItsOwner.getForeignTotal().subtract(pItsOwner.getForeignTotalTaxes()));
        } else {
            pItsOwner.setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setItsTotal(pItsOwner.getSubtotal().add(pItsOwner.getTotalTaxes()));
            pItsOwner.setForeignSubtotal(BigDecimal.valueOf(totals[3]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setForeignTotal(pItsOwner.getForeignSubtotal().add(pItsOwner.getForeignTotalTaxes()));
        }
        this.getSrvOrm().updateEntity(pReqVars, (Object)pItsOwner);
    }

    public final String lazyGetQuPurchInvSalTaxItBasAggr() throws Exception {
        if (this.quPurInvSaTaxItBasAggr == null) {
            String flName = "/accounting/trade/" + this.fileQuPurInvSaTaxItBasAggr;
            this.quPurInvSaTaxItBasAggr = this.loadString(flName);
        }
        return this.quPurInvSaTaxItBasAggr;
    }

    public final String lazyGetQuPurchInvSalTaxItBas() throws Exception {
        if (this.quPurInvSaTaxItBas == null) {
            String flName = "/accounting/trade/" + this.fileQuPurInvSaTaxItBas;
            this.quPurInvSaTaxItBas = this.loadString(flName);
        }
        return this.quPurInvSaTaxItBas;
    }

    public final String lazyGetQuPurchInvSalTaxInvBas() throws Exception {
        if (this.quPurInvSaTaxInvBas == null) {
            String flName = "/accounting/trade/" + this.fileQuPurInvSaTaxInvBas;
            this.quPurInvSaTaxInvBas = this.loadString(flName);
        }
        return this.quPurInvSaTaxInvBas;
    }

    public final String lazyGetQueryPurchaseInvoiceTotals() throws Exception {
        if (this.queryPurchaseInvoiceTotals == null) {
            String flName = "/accounting/trade/" + this.fileQueryPurchaseInvoiceTotals;
            this.queryPurchaseInvoiceTotals = this.loadString(flName);
        }
        return this.queryPurchaseInvoiceTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = UtlPurchaseGoodsServiceLine.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = UtlPurchaseGoodsServiceLine.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pReqVars, PurchaseInvoice pItsOwner) throws Exception {
        boolean isTaxable;
        pReqVars.put("PurchaseInvoiceTaxLineitsOwnerdeepLevel", 1);
        List itls = this.getSrvOrm().retrieveListWithConditions(pReqVars, PurchaseInvoiceTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("PurchaseInvoiceTaxLineitsOwnerdeepLevel");
        boolean isShowDebug = this.getLogger().getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.getLogger().getDetailLevel();
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromPurchase() != false && pItsOwner.getOmitTaxes() == false && pItsOwner.getVendor().getIsForeigner() == false;
        if (isTaxable) {
            boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
            boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
            RoundingMode rm = as.getSalTaxRoundMode();
            if (pItsOwner.getVendor().getTaxDestination() != null) {
                isItemBasis = pItsOwner.getVendor().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                isAggrOnlyRate = pItsOwner.getVendor().getTaxDestination().getSalTaxUseAggregItBas();
                rm = pItsOwner.getVendor().getTaxDestination().getSalTaxRoundMode();
            }
            if (pItsOwner.getPriceIncTax().booleanValue() && !isAggrOnlyRate) {
                throw new ExceptionWithCode(1003, "price_inc_tax_multi_not_imp");
            }
            if (isShowDebug && dbgDetLev > 30000) {
                this.getLogger().debug(null, UtlPurchaseGoodsServiceLine.class, "Updating tax lines for invoice #/date/isItemBasis/isAggrOnlyRate/rm: " + pItsOwner.getItsId() + "/" + pItsOwner.getItsDate() + "/" + isItemBasis + "/" + isAggrOnlyRate + "/" + (Object)((Object)rm));
            }
            String query = !isItemBasis ? this.lazyGetQuPurchInvSalTaxInvBas() : (isAggrOnlyRate ? this.lazyGetQuPurchInvSalTaxItBasAggr() : this.lazyGetQuPurchInvSalTaxItBas());
            query = query.replace(":INVOICEID", pItsOwner.getItsId().toString());
            IRecordSet recordSet = null;
            ArrayList<PurchaseInvoiceServiceLine> inLnsDt = new ArrayList<PurchaseInvoiceServiceLine>();
            ArrayList<Long> taxesLst = new ArrayList<Long>();
            ArrayList<Double> dbResults = new ArrayList<Double>();
            try {
                recordSet = this.getSrvDatabase().retrieveRecords(query);
                if (recordSet.moveToFirst()) {
                    do {
                        Iterator invLn;
                        Long taxId = recordSet.getLong("TAXID");
                        if (!isItemBasis) {
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            Long ilId = recordSet.getLong("TAXCATID");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, as);
                            if (pItsOwner.getPriceIncTax().booleanValue()) {
                                ((PurchaseInvoiceServiceLine)((Object)invLn)).setItsTotal(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                                ((PurchaseInvoiceServiceLine)((Object)invLn)).setForeignTotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                                continue;
                            }
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setSubtotal(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setForeignTotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNSUBTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        if (isAggrOnlyRate) {
                            Long ilId = recordSet.getLong("ILID");
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, as);
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setForeignTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTALTAXES")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        taxesLst.add(taxId);
                        dbResults.add(recordSet.getDouble("TOTALTAX"));
                        dbResults.add(recordSet.getDouble("FOREIGNTOTALTAXES"));
                    } while (recordSet.moveToNext());
                }
            }
            finally {
                if (recordSet != null) {
                    recordSet.close();
                }
            }
            if (inLnsDt.size() > 0 && taxesLst.size() > 0) {
                throw new Exception("Algorithm error!!!");
            }
            if (!isItemBasis && inLnsDt.size() > 0) {
                HashSet taxIds = new HashSet();
                for (PurchaseInvoiceServiceLine invLn : inLnsDt) {
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        if (taxIds.contains(itcl.getTax().getItsId())) {
                            throw new ExceptionWithCode(1003, "invoice_basis_same_taxes_with_different_tax_cat");
                        }
                        taxIds.add(itcl.getTax().getItsId());
                    }
                }
            }
            if (itls.size() > 0) {
                for (PurchaseInvoiceTaxLine itl : itls) {
                    itl.setTax(null);
                    itl.setTaxableInvBas(BigDecimal.ZERO);
                    itl.setTaxableInvBasFc(BigDecimal.ZERO);
                    itl.setItsTotal(BigDecimal.ZERO);
                    itl.setForeignTotalTaxes(BigDecimal.ZERO);
                }
            }
            ArrayList<PurchaseInvoiceTaxLine> itlsnew = null;
            if (!isItemBasis || isAggrOnlyRate) {
                itlsnew = new ArrayList<PurchaseInvoiceTaxLine>();
            }
            pReqVars.put("countUpdatedItl", 0);
            if (inLnsDt.size() > 0) {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (PurchaseInvoiceServiceLine invLn : inLnsDt) {
                    int ti = 0;
                    BigDecimal invBasTaxTot = null;
                    BigDecimal invBasTaxTotFc = null;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggegatedFc = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    BigDecimal taxAggrAccumFc = BigDecimal.ZERO;
                    if (isAggrOnlyRate) {
                        Collections.sort(invLn.getTaxCategory().getTaxes(), cmpr);
                    }
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null && isAggrOnlyRate) {
                            if (!isItemBasis && pItsOwner.getPriceIncTax().booleanValue()) {
                                taxAggegated = invLn.getItsTotal().subtract(invLn.getItsTotal().divide(BigDecimal.ONE.add(invLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm));
                                taxAggegatedFc = invLn.getForeignTotal().subtract(invLn.getForeignTotal().divide(BigDecimal.ONE.add(invLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm));
                            } else if (isItemBasis) {
                                taxAggegated = invLn.getTotalTaxes();
                                taxAggegatedFc = invLn.getForeignTotalTaxes();
                            }
                        }
                        if (!isItemBasis) {
                            invBasTaxTot = invLn.getTotalTaxes();
                            invBasTaxTotFc = invLn.getForeignTotalTaxes();
                        }
                        if (!isItemBasis && pItsOwner.getPriceIncTax().booleanValue() && isAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                                invLn.setForeignTotalTaxes(taxAggegatedFc.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccumFc = taxAggrAccumFc.add(invLn.getForeignTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                                invLn.setForeignTotalTaxes(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        } else if (!isItemBasis && !pItsOwner.getPriceIncTax().booleanValue()) {
                            invLn.setTotalTaxes(invLn.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm));
                            invLn.setForeignTotalTaxes(invLn.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm));
                        } else if (isItemBasis && isAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                                invLn.setForeignTotalTaxes(taxAggegatedFc.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccumFc = taxAggrAccumFc.add(invLn.getForeignTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                                invLn.setForeignTotalTaxes(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        } else {
                            throw new Exception("Algorithm error!!!");
                        }
                        PurchaseInvoiceTaxLine itl = this.findCreateTaxLine(pReqVars, itls, itlsnew, itcl.getTax().getItsId());
                        itl.setItsOwner(pItsOwner);
                        itl.setTax(itcl.getTax());
                        this.makeItl(pReqVars, itl, invLn, isItemBasis, pItsOwner.getPriceIncTax());
                        if (isItemBasis) continue;
                        invLn.setTotalTaxes(invBasTaxTot.add(invLn.getTotalTaxes()));
                        invLn.setForeignTotalTaxes(invBasTaxTotFc.add(invLn.getForeignTotalTaxes()));
                    }
                }
            }
            if (taxesLst.size() > 0) {
                for (int i = 0; i < taxesLst.size(); ++i) {
                    Tax tax = new Tax();
                    tax.setItsId((Long)taxesLst.get(i));
                    PurchaseInvoiceTaxLine itl = this.findCreateTaxLine(pReqVars, itls, null, tax.getItsId());
                    itl.setItsOwner(pItsOwner);
                    itl.setTax(tax);
                    itl.setItsTotal(BigDecimal.valueOf((Double)dbResults.get(i * 2)).setScale((int)as.getPricePrecision(), rm));
                    itl.setForeignTotalTaxes(BigDecimal.valueOf((Double)dbResults.get(i * 2 + 1)).setScale((int)as.getPricePrecision(), rm));
                    if (itl.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, (Object)itl);
                        itl.setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pReqVars, (Object)itl);
                }
            }
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            pReqVars.remove("countUpdatedItl");
            if (countUpdatedItl < itls.size()) {
                for (int j = countUpdatedItl.intValue(); j < itls.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pReqVars, itls.get(j));
                }
            }
            if (!isItemBasis && inLnsDt.size() > 0) {
                this.adjustInvoiceLns(pReqVars, pItsOwner, inLnsDt, as);
            }
        } else if (itls.size() > 0) {
            if (isShowDebug) {
                this.getLogger().debug(null, UtlPurchaseGoodsServiceLine.class, "Deleting tax lines for non-taxable invoice #" + pItsOwner.getItsId() + "/" + pItsOwner.getItsDate());
            }
            for (PurchaseInvoiceTaxLine itln : itls) {
                this.getSrvOrm().deleteEntity(pReqVars, (Object)itln);
            }
        }
    }

    public final void adjustInvoiceLns(Map<String, Object> pReqVars, PurchaseInvoice pItsOwner, List<PurchaseInvoiceServiceLine> pTacCatTotLns, AccSettings pAs) throws Exception {
        pReqVars.put("PurchaseInvoiceServiceLineitsOwnerdeepLevel", 1);
        List isls = this.getSrvOrm().retrieveListWithConditions(pReqVars, PurchaseInvoiceServiceLine.class, "where PURCHASEINVOICESERVICELINE.TAXCATEGORY is not null and ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("PurchaseInvoiceServiceLineitsOwnerdeepLevel");
        pReqVars.put("PurchaseInvoiceLineitsOwnerdeepLevel", 1);
        List igls = this.getSrvOrm().retrieveListWithConditions(pReqVars, PurchaseInvoiceLine.class, "where PURCHASEINVOICELINE.TAXCATEGORY is not null and REVERSEDID is null and ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("PurchaseInvoiceLineitsOwnerdeepLevel");
        ArrayList<APersistableBaseVersion> ilnt = new ArrayList<APersistableBaseVersion>();
        Comparator cmpr = Collections.reverseOrder(new CmprInvLnTotal());
        for (PurchaseInvoiceServiceLine ttl : pTacCatTotLns) {
            for (PurchaseInvoiceServiceLine isl : isls) {
                if (!isl.getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(isl);
            }
            for (PurchaseInvoiceLine igl : igls) {
                if (!igl.getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(igl);
            }
            Collections.sort(ilnt, cmpr);
            BigDecimal txRest = ttl.getTotalTaxes();
            for (int i = 0; i < ilnt.size(); ++i) {
                if (i + 1 == ilnt.size()) {
                    if (pItsOwner.getPriceIncTax().booleanValue()) {
                        ((IInvoiceLine)ilnt.get(i)).setSubtotal(((IInvoiceLine)ilnt.get(i)).getItsTotal().subtract(txRest));
                    } else {
                        ((IInvoiceLine)ilnt.get(i)).setItsTotal(((IInvoiceLine)ilnt.get(i)).getSubtotal().add(txRest));
                    }
                    ((IInvoiceLine)ilnt.get(i)).setTotalTaxes(txRest);
                } else {
                    BigDecimal taxTot;
                    if (pItsOwner.getPriceIncTax().booleanValue()) {
                        taxTot = ttl.getTotalTaxes().multiply(((IInvoiceLine)ilnt.get(i)).getItsTotal()).divide(ttl.getItsTotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilnt.get(i)).setSubtotal(((IInvoiceLine)ilnt.get(i)).getItsTotal().subtract(taxTot));
                    } else {
                        taxTot = ttl.getTotalTaxes().multiply(((IInvoiceLine)ilnt.get(i)).getSubtotal()).divide(ttl.getSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilnt.get(i)).setItsTotal(((IInvoiceLine)ilnt.get(i)).getSubtotal().add(taxTot));
                    }
                    ((IInvoiceLine)ilnt.get(i)).setTotalTaxes(taxTot);
                    txRest = txRest.subtract(taxTot);
                }
                if (pItsOwner.getPriceIncTax().booleanValue() && ((IInvoiceLine)ilnt.get(i)).getClass() == PurchaseInvoiceLine.class) {
                    PurchaseInvoiceLine pil = (PurchaseInvoiceLine)ilnt.get(i);
                    pil.setItsCost(((IInvoiceLine)ilnt.get(i)).getSubtotal().divide(((IInvoiceLine)ilnt.get(i)).getItsQuantity(), (int)pAs.getCostPrecision(), pAs.getRoundingMode()));
                }
                this.getSrvOrm().updateEntity(pReqVars, ilnt.get(i));
            }
            ilnt.clear();
        }
    }

    public final PurchaseInvoiceTaxLine findCreateTaxLine(Map<String, Object> pReqVars, List<PurchaseInvoiceTaxLine> pTaxLnsWas, List<PurchaseInvoiceTaxLine> pTaxLnsNew, Long pTaxId) {
        int k;
        PurchaseInvoiceTaxLine itl = null;
        if (pTaxLnsWas.size() > 0) {
            for (k = 0; k < pTaxLnsWas.size(); ++k) {
                if (pTaxLnsWas.get(k).getTax() == null || !pTaxLnsWas.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsWas.get(k);
                break;
            }
        }
        if (itl == null && pTaxLnsNew != null && pTaxLnsNew.size() > 0) {
            for (k = 0; k < pTaxLnsNew.size(); ++k) {
                if (!pTaxLnsNew.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsNew.get(k);
                break;
            }
        }
        if (itl == null) {
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            if (pTaxLnsWas.size() > countUpdatedItl) {
                itl = pTaxLnsWas.get(countUpdatedItl);
                Integer n = countUpdatedItl;
                Integer n2 = countUpdatedItl = Integer.valueOf(countUpdatedItl + 1);
                pReqVars.put("countUpdatedItl", countUpdatedItl);
            } else {
                itl = new PurchaseInvoiceTaxLine();
                itl.setIsNew(true);
                itl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                if (pTaxLnsNew != null) {
                    pTaxLnsNew.add(itl);
                }
            }
        }
        return itl;
    }

    public final PurchaseInvoiceServiceLine makeLine(List<PurchaseInvoiceServiceLine> pInvLns, Long pIlId, Long pCatId, Long pTaxId, Double pPercent, AccSettings pAs) {
        PurchaseInvoiceServiceLine invLn = null;
        for (PurchaseInvoiceServiceLine il : pInvLns) {
            if (!il.getItsId().equals(pIlId)) continue;
            invLn = il;
        }
        if (invLn == null) {
            invLn = new PurchaseInvoiceServiceLine();
            invLn.setItsId(pIlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            invLn.setTaxCategory(tc);
            pInvLns.add(invLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        Tax tax = new Tax();
        tax.setItsId(pTaxId);
        itcl.setTax(tax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        invLn.getTaxCategory().getTaxes().add(itcl);
        invLn.getTaxCategory().setAggrOnlyPercent(invLn.getTaxCategory().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return invLn;
    }

    public final void makeItl(Map<String, Object> pReqVars, PurchaseInvoiceTaxLine pItl, PurchaseInvoiceServiceLine pInvLn, boolean pIsItemBasis, boolean pIsPriceInclTax) throws Exception {
        pItl.setItsTotal(pItl.getItsTotal().add(pInvLn.getTotalTaxes()));
        pItl.setForeignTotalTaxes(pItl.getForeignTotalTaxes().add(pInvLn.getForeignTotalTaxes()));
        if (!pIsItemBasis) {
            if (pIsPriceInclTax) {
                pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getItsTotal()));
                pItl.setTaxableInvBasFc(pItl.getTaxableInvBasFc().add(pInvLn.getForeignTotal()));
            } else {
                pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getSubtotal()));
                pItl.setTaxableInvBasFc(pItl.getTaxableInvBasFc().add(pInvLn.getForeignSubtotal()));
            }
        }
        if (pItl.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, (Object)pItl);
            pItl.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, (Object)pItl);
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getFileQuPurInvSaTaxItBasAggr() {
        return this.fileQuPurInvSaTaxItBasAggr;
    }

    public final void setFileQuPurInvSaTaxItBasAggr(String pFileQuPurInvSaTaxItBasAggr) {
        this.fileQuPurInvSaTaxItBasAggr = pFileQuPurInvSaTaxItBasAggr;
    }

    public final void setQuPurInvSaTaxItBasAggr(String pQuPurInvSaTaxItBasAggr) {
        this.quPurInvSaTaxItBasAggr = pQuPurInvSaTaxItBasAggr;
    }

    public final String getFileQuPurInvSaTaxItBas() {
        return this.fileQuPurInvSaTaxItBas;
    }

    public final void setFileQuPurInvSaTaxItBas(String pFileQuPurInvSaTaxItBas) {
        this.fileQuPurInvSaTaxItBas = pFileQuPurInvSaTaxItBas;
    }

    public final String getQueryPurchInvSalTaxItemBas() {
        return this.quPurInvSaTaxItBas;
    }

    public final void setQueryPurchInvSalTaxItemBas(String pQueryPurchInvSalTaxItemBas) {
        this.quPurInvSaTaxItBas = pQueryPurchInvSalTaxItemBas;
    }

    public final String getFileQueryPurchaseInvoiceTotals() {
        return this.fileQueryPurchaseInvoiceTotals;
    }

    public final void setFileQueryPurchaseInvoiceTotals(String pFileQueryPurchaseInvoiceTotals) {
        this.fileQueryPurchaseInvoiceTotals = pFileQueryPurchaseInvoiceTotals;
    }

    public final String getQueryPurchaseInvoiceTotals() {
        return this.queryPurchaseInvoiceTotals;
    }

    public final void setQueryPurchaseInvoiceTotals(String pQueryPurchaseInvoiceTotals) {
        this.queryPurchaseInvoiceTotals = pQueryPurchaseInvoiceTotals;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

