/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.I18nAccounting;
import org.beigesoft.accounting.persistable.I18nCurrency;
import org.beigesoft.accounting.report.IBalanceSheetPdf;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;

public class BalanceSheetPdf<RS, WI>
implements IBalanceSheetPdf {
    private IPdfFactory<WI> pdfFactory;
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final void makeReport(Map<String, Object> pAddParam, BalanceSheet pBalance, OutputStream pOus) throws Exception {
        String curSign;
        boolean isPrnCurLf;
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pAddParam);
        String lang = (String)pAddParam.get("lang");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(lang));
        I18nCurrency i18nCurrency = (I18nCurrency)((Object)pAddParam.get("i18nCurrency"));
        if (i18nCurrency != null) {
            isPrnCurLf = i18nCurrency.getPrintCurrencyLeft();
            curSign = i18nCurrency.getUseCurrencySign().booleanValue() ? i18nCurrency.getHasName().getItsSign() : " " + i18nCurrency.getItsName() + " ";
        } else {
            curSign = (String)pAddParam.get("curSign");
            isPrnCurLf = accSet.getPrintCurrencyLeft();
        }
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(accSet.getPageSize(), accSet.getPageOrientation());
        doc.setFontSize(accSet.getFontSize().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginBottom(accSet.getMarginBottom().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginTop(accSet.getMarginTop().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginLeft(accSet.getMarginLeft().doubleValue());
        ((DocPage)doc.getPages().get(0)).setMarginRight(accSet.getMarginRight().doubleValue());
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, accSet.getTtfFileName());
        if (accSet.getTtfBoldFileName() != null) {
            pdfMaker.addFontTtf(docPdf, accSet.getTtfBoldFileName());
        }
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContainerMarginBottom(this.mmToDocUom(3.5, doc.getUnitOfMeasure()));
        doc.setContentPaddingBottom(this.mmToDocUom(0.5, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.CENTER);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 3);
        I18nAccounting i18nAccounting = (I18nAccounting)((Object)pAddParam.get("i18nAccounting"));
        if (i18nAccounting != null) {
            ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(i18nAccounting.getOrganizationName());
        } else {
            ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(accSet.getOrganization());
        }
        ((TableCell)tblTitle.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("balance_sheet", lang));
        ((TableCell)tblTitle.getItsCells().get(2)).setItsContent(dateFormat.format(pBalance.getItsDate()));
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        docMaker.makeDocTableWrapping(tblTitle);
        doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        doc.setAlignHoriCont(EAlignHorizontal.LEFT);
        DocTable tblBal = docMaker.addDocTable(doc, 4, pBalance.getDetailRowsCount() + 2);
        ((TableColumn)tblBal.getItsColumns().get(0)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(0)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(1)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(1)).setWidthInPercentage(20.0);
        ((TableColumn)tblBal.getItsColumns().get(2)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(2)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(3)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(3)).setWidthInPercentage(20.0);
        ((TableCell)tblBal.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("AssetsTitle", lang));
        ((TableCell)tblBal.getItsCells().get(0)).setMergedCell((TableCell)tblBal.getItsCells().get(1));
        ((TableCell)tblBal.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("LiabilitiesTitle", lang));
        ((TableCell)tblBal.getItsCells().get(2)).setMergedCell((TableCell)tblBal.getItsCells().get(3));
        int row = 1;
        for (int i = 0; i < pBalance.getTotalLinesAssets(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getDebit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setFontNumber(1);
            ++row;
        }
        int totLeabOwnEq = pBalance.getTotalLinesLiabilities() + pBalance.getTotalLinesOwnersEquity();
        int lastRowIdx = Math.max(pBalance.getTotalLinesAssets() + 1, totLeabOwnEq + 4);
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4)).setItsContent(this.srvI18n.getMsg("total_assets", lang));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        String cntc = isPrnCurLf ? curSign + this.prn(pAddParam, pBalance.getTotalAssets()) : this.prn(pAddParam, pBalance.getTotalAssets()) + curSign;
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setItsContent(cntc);
        row = 1;
        int totAssLeab = pBalance.getTotalLinesAssets() + pBalance.getTotalLinesLiabilities();
        for (int i = pBalance.getTotalLinesAssets().intValue(); i < totAssLeab; ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 6)).setItsContent(this.srvI18n.getMsg("total_l", lang));
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7)).setItsContent(this.prn(pAddParam, pBalance.getTotalLiabilities()));
        int oetIdx = pBalance.getTotalLinesLiabilities() * 4 + 10;
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setItsContent(this.srvI18n.getMsg("OwnersEquityTitle", lang));
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setMergedCell((TableCell)tblBal.getItsCells().get(oetIdx + 1));
        row = 1 + pBalance.getTotalLinesLiabilities() + 2;
        for (int i = totAssLeab; i < totAssLeab + pBalance.getTotalLinesOwnersEquity(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? this.prn(pAddParam, pBalance.getItsLines().get(i).getCredit()) : "(" + this.prn(pAddParam, pBalance.getItsLines().get(i).getDebit()) + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 2)).setItsContent(this.srvI18n.getMsg("total_oe", lang));
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setItsContent(this.prn(pAddParam, pBalance.getTotalOwnersEquity()));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 2)).setItsContent(this.srvI18n.getMsg("total_l_oe", lang));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        cntc = isPrnCurLf ? curSign + this.prn(pAddParam, pBalance.getTotalOwnersEquity().add(pBalance.getTotalLiabilities())) : this.prn(pAddParam, pBalance.getTotalOwnersEquity().add(pBalance.getTotalLiabilities())) + curSign;
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setItsContent(cntc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("balancePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final double mmToDocUom(double pValue, EUnitOfMeasure pUom) {
        if (pUom.equals((Object)EUnitOfMeasure.INCH)) {
            return pValue / 25.4;
        }
        return pValue;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

