/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.processor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.handler.IHandlerModelChanged;
import org.beigesoft.model.IRequestData;
import org.beigesoft.replicator.persistable.ReplicationAccMethod;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcReplicationAccMethodSave<RS>
implements IEntityProcessor<ReplicationAccMethod, Long> {
    private Set<IHandlerModelChanged<ReplicationAccMethod>> replAccMethChangedHandlers = new HashSet<IHandlerModelChanged<ReplicationAccMethod>>();
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    public final ReplicationAccMethod process(Map<String, Object> pAddParam, ReplicationAccMethod pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getRequestedDatabaseId().intValue() == this.getSrvOrm().getIdDatabase()) {
            throw new ExceptionWithCode(1003, "requested_database_must_be_different");
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.srvOrm.insertEntity(pAddParam, (Object)pEntity);
        } else {
            this.srvOrm.updateEntity(pAddParam, (Object)pEntity);
        }
        for (IHandlerModelChanged<ReplicationAccMethod> replAccMethChangedHandler : this.replAccMethChangedHandlers) {
            replAccMethChangedHandler.handleModelChanged((Object)pEntity);
        }
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        return pEntity;
    }

    public final void addReplAccMethChangedHandler(IHandlerModelChanged<ReplicationAccMethod> pReplAccMethChngHandler) {
        this.replAccMethChangedHandlers.add(pReplAccMethChngHandler);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

