package org.beigesoft.accounting.persistable;

/*
 * Copyright (c) 2016 Beigesoft™
 *
 * Licensed under the GNU General Public License (GPL), Version 2.0
 * (the "License");
 * you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html
 */

import java.math.BigDecimal;
import java.util.Date;

import org.beigesoft.persistable.APersistableBaseVersion;
import org.beigesoft.accounting.persistable.base.AItem;

/**
 * <pre>
 * Model of Purchase Return Line for each work type,
 * e.g. cooking or delivery.
 * Version, reliable autoincrement algorithm.
 * </pre>
 *
 * @author Yury Demidenko
 */
public class PurchaseReturnLine extends APersistableBaseVersion
  implements IMakingWarehouseEntry, IInvoiceLine<PurchaseReturn> {

  /**
   * <p>Purchase Return.</p>
   **/
  private PurchaseReturn itsOwner;

  /**
   * <p>Purchase Invoice Line.</p>
   **/
  private PurchaseInvoiceLine purchaseInvoiceLine;

  /**
   * <p>Purchase Invoice Line Appearance.</p>
   **/
  private String purchInvLnAppearance;

  /**
   * <p>Warehouse site from (optional).
   * If it's empty (null) then withdrawal will be from the first
   * site/s that has the goods, otherwise withdrawal will be exactly
   * from this site.</p>
   **/
  private WarehouseSite warehouseSiteFo;

  /**
   * <p>ID of reversed/reversing tax line.</p>
   **/
  private Long reversedId;

  /**
   * <p>Less or equals theRest in purchaseInvoiceLine.</p>
   **/
  private BigDecimal itsQuantity = BigDecimal.ZERO;

  /**
   * <p>Total with taxes.</p>
   **/
  private BigDecimal subtotal = BigDecimal.ZERO;

  /**
   * <p>Total taxes.</p>
   **/
  private BigDecimal totalTaxes = BigDecimal.ZERO;

  /**
   * <p>Total.</p>
   **/
  private BigDecimal itsTotal = BigDecimal.ZERO;

  /**
   * <p>Taxes description, uneditable,
   * e.g. "tax1 10%=12, tax2 5%=6".</p>
   **/
  private String taxesDescription;

  /**
   * <p>Description.</p>
   **/
  private String description;

  /**
   * <p>Subtotal in foreign currency, if used.</p>
   **/
  private BigDecimal foreignSubtotal = BigDecimal.ZERO;

  /**
   * <p>Total taxes in foreign currency, if used,
   * in case of domestic sales (if law allow it).</p>
   **/
  private BigDecimal foreignTotalTaxes = BigDecimal.ZERO;

  /**
   * <p>Total in foreign currency, if used.</p>
   **/
  private BigDecimal foreignTotal = BigDecimal.ZERO;

  /**
   * <p>Geter for item.</p>
   * @return item
   **/
  @Override
  public final AItem<?, ?> getItem() {
    return this.purchaseInvoiceLine.getInvItem();
  }

  /**
   * <p>Geter for reversedId.</p>
   * @return Long
   **/
  @Override
  public final Long getReversedId() {
    return this.reversedId;
  }

  /**
   * <p>Setter for reversedId.</p>
   * @param pReversedId reference
   **/
  @Override
  public final void setReversedId(final Long pReversedId) {
    this.reversedId = pReversedId;
  }

  /**
   * <p>Getter for itsCost.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getItsPrice() {
    return this.purchaseInvoiceLine.getItsCost();
  }

  /**
   * <p>Setter for itsCost.</p>
   * @param pItsPrice reference
   **/
  @Override
  public final void setItsPrice(final BigDecimal pItsPrice) {
    throw new RuntimeException("UNEDITABLE");
  }

  /**
   * <p>Getter for taxCategory.</p>
   * @return InvItemTaxCategory
   **/
  @Override
  public final InvItemTaxCategory getTaxCategory() {
    return this.purchaseInvoiceLine.getTaxCategory();
  }

  /**
   * <p>Setter for taxCategory.</p>
   * @param pTaxCategory reference
   **/
  @Override
  public final void setTaxCategory(final InvItemTaxCategory pTaxCategory) {
    throw new RuntimeException("UNEDITABLE");
  }

  /**
   * <p>Getter for foreignPrice.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getForeignPrice() {
    return this.purchaseInvoiceLine.getForeignPrice();
  }

  /**
   * <p>Setter for foreignPrice.</p>
   * @param pForeignPrice reference
   **/
  @Override
  public final void setForeignPrice(final BigDecimal pForeignPrice) {
    throw new RuntimeException("UNEDITABLE");
  }

  /**
   * <p>Getter for foreignSubtotal.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getForeignSubtotal() {
    return this.foreignSubtotal;
  }

  /**
   * <p>Setter for foreignSubtotal.</p>
   * @param pForeignSubtotal reference
   **/
  @Override
  public final void setForeignSubtotal(final BigDecimal pForeignSubtotal) {
    this.foreignSubtotal = pForeignSubtotal;
  }

  /**
   * <p>Getter for foreignTotalTaxes.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getForeignTotalTaxes() {
    return this.foreignTotalTaxes;
  }

  /**
   * <p>Setter for foreignTotalTaxes.</p>
   * @param pForeignTotalTaxes reference
   **/
  @Override
  public final void setForeignTotalTaxes(final BigDecimal pForeignTotalTaxes) {
    this.foreignTotalTaxes = pForeignTotalTaxes;
  }

  /**
   * <p>Getter for foreignTotal.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getForeignTotal() {
    return this.foreignTotal;
  }

  /**
   * <p>Setter for foreignTotal.</p>
   * @param pForeignTotal reference
   **/
  @Override
  public final void setForeignTotal(final BigDecimal pForeignTotal) {
    this.foreignTotal = pForeignTotal;
  }

  /**
   * <p>Setter for unitOfMeasure.</p>
   * @param pUnitOfMeasure reference
   **/
  @Override
  public final void setUnitOfMeasure(final UnitOfMeasure pUnitOfMeasure) {
    throw new RuntimeException(
      "TODO remove setUnitOfMeasure from IMakingWarehouseEntry");
  }

  /**
   * <p>Setter for unitOfMeasure.</p>
   * @param pUnitOfMeasure reference
   **/
  @Override
  public final UnitOfMeasure getUnitOfMeasure() {
    return getPurchaseInvoiceLine().getUnitOfMeasure();
  }

  /**
   * <p>Setter for invItem.</p>
   * @param pInvItem reference
   **/
  @Override
  public final void setInvItem(final InvItem pInvItem) {
    throw new RuntimeException(
      "TODO remove setInvItem from IMakingWarehouseEntry");
  }

  /**
   * <p>Setter for invItem.</p>
   * @param pInvItem reference
   **/
  @Override
  public final InvItem getInvItem() {
    return getPurchaseInvoiceLine().getInvItem();
  }

  /**
   * <p>OOP friendly Constant of code type.</p>
   * @return 1007
   **/
  @Override
  public final Integer constTypeCode() {
    return 1007;
  }

  /**
   * <p>Getter for itsOwner.</p>
   * @return PurchaseReturn
   **/
  @Override
  public final PurchaseReturn getItsOwner() {
    return this.itsOwner;
  }

  /**
   * <p>Setter for itsOwner.</p>
   * @param pItsOwner reference
   **/
  @Override
  public final void setItsOwner(final PurchaseReturn pItsOwner) {
    this.itsOwner = pItsOwner;
  }

  /**
   * <p>Get for document Date.</p>
   * @return Date
   **/
  @Override
  public final Date getDocumentDate() {
    return this.getItsOwner().getItsDate();
  }

  /**
   * <p>Get Owner Type if exist  e.g. PurchaseInvoice 1.</p>
   * @return Integer
   **/
  @Override
  public final Integer getOwnerType() {
    return this.getItsOwner().constTypeCode();
  }

  /**
   * <p>Get for owner's ID.</p>
   * @return Long
   **/
  @Override
  public final Long getOwnerId() {
    return this.getItsOwner().getItsId();
  }

  /**
   * <p>Getter for description.</p>
   * @return String
   **/
  @Override
  public final String getDescription() {
    return this.description;
  }

  /**
   * <p>Setter for description.</p>
   * @param pDescription reference
   **/
  @Override
  public final void setDescription(final String pDescription) {
    this.description = pDescription;
  }

  /**
   * <p>Getter for itsQuantity.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getItsQuantity() {
    return this.itsQuantity;
  }

  /**
   * <p>Setter for itsQuantity.</p>
   * @param pItsQuantity reference
   **/
  @Override
  public final void setItsQuantity(final BigDecimal pItsQuantity) {
    this.itsQuantity = pItsQuantity;
  }

  /**
   * <p>Getter for subtotal.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getSubtotal() {
    return this.subtotal;
  }

  /**
   * <p>Setter for subtotal.</p>
   * @param pSubtotal reference
   **/
  @Override
  public final void setSubtotal(final BigDecimal pSubtotal) {
    this.subtotal = pSubtotal;
  }

  /**
   * <p>Getter for totalTaxes.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getTotalTaxes() {
    return this.totalTaxes;
  }

  /**
   * <p>Setter for totalTaxes.</p>
   * @param pTotalTaxes reference
   **/
  @Override
  public final void setTotalTaxes(final BigDecimal pTotalTaxes) {
    this.totalTaxes = pTotalTaxes;
  }

  /**
   * <p>Getter for itsTotal.</p>
   * @return BigDecimal
   **/
  @Override
  public final BigDecimal getItsTotal() {
    return this.itsTotal;
  }

  /**
   * <p>Setter for itsTotal.</p>
   * @param pItsTotal reference
   **/
  @Override
  public final void setItsTotal(final BigDecimal pItsTotal) {
    this.itsTotal = pItsTotal;
  }

  /**
   * <p>Getter for taxesDescription.</p>
   * @return String
   **/
  @Override
  public final String getTaxesDescription() {
    return this.taxesDescription;
  }

  /**
   * <p>Setter for taxesDescription.</p>
   * @param pTaxesDescription reference
   **/
  @Override
  public final void setTaxesDescription(final String pTaxesDescription) {
    this.taxesDescription = pTaxesDescription;
  }

  //Simple getters and setters:
  /**
   * <p>Getter for purchaseInvoiceLine.</p>
   * @return PurchaseInvoiceLine
   **/
  public final PurchaseInvoiceLine getPurchaseInvoiceLine() {
    return this.purchaseInvoiceLine;
  }

  /**
   * <p>Setter for purchaseInvoiceLine.</p>
   * @param pPurchaseInvoiceLine reference
   **/
  public final void setPurchaseInvoiceLine(
    final PurchaseInvoiceLine pPurchaseInvoiceLine) {
    this.purchaseInvoiceLine = pPurchaseInvoiceLine;
  }

  /**
   * <p>Getter for purchInvLnAppearance.</p>
   * @return String
   **/
  public final String getPurchInvLnAppearance() {
    return this.purchInvLnAppearance;
  }

  /**
   * <p>Setter for purchInvLnAppearance.</p>
   * @param pPurchInvLnAppearance reference
   **/
  public final void setPurchInvLnAppearance(
    final String pPurchInvLnAppearance) {
    this.purchInvLnAppearance = pPurchInvLnAppearance;
  }

  /**
   * <p>Getter for warehouseSiteFo.</p>
   * @return WarehouseSite
   **/
  public final WarehouseSite getWarehouseSiteFo() {
    return this.warehouseSiteFo;
  }

  /**
   * <p>Setter for warehouseSiteFo.</p>
   * @param pWarehouseSiteFo reference
   **/
  public final void setWarehouseSiteFo(final WarehouseSite pWarehouseSiteFo) {
    this.warehouseSiteFo = pWarehouseSiteFo;
  }
}
