/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.persistable.AccountingEntries;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcAccEntrySave<RS>
implements IEntityProcessor<AccountingEntry, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvBalance srvBalance;
    private ISrvAccSettings srvAccSettings;
    private final Integer accountingEntriesTypeCode = new AccountingEntries().constTypeCode();

    public final AccountingEntry process(Map<String, Object> pAddParam, AccountingEntry pEntity, IRequestData pRequestData) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_entry_for_foreign_src");
        }
        if (pEntity.getIsNew().booleanValue()) {
            AccSettings accSettings = this.getSrvAccSettings().lazyGetAccSettings(pAddParam);
            Calendar calCurrYear = Calendar.getInstance(new Locale("en", "US"));
            calCurrYear.setTime(accSettings.getCurrentAccYear());
            calCurrYear.set(2, 0);
            calCurrYear.set(5, 1);
            calCurrYear.set(11, 0);
            calCurrYear.set(12, 0);
            calCurrYear.set(13, 0);
            calCurrYear.set(14, 0);
            Calendar calDoc = Calendar.getInstance(new Locale("en", "US"));
            calDoc.setTime(pEntity.getItsDate());
            calDoc.set(2, 0);
            calDoc.set(5, 1);
            calDoc.set(11, 0);
            calDoc.set(12, 0);
            calDoc.set(13, 0);
            calDoc.set(14, 0);
            if (calCurrYear.getTime().getTime() != calDoc.getTime().getTime()) {
                throw new ExceptionWithCode(1003, "wrong_year");
            }
            if (pEntity.getDebit().doubleValue() == 0.0) {
                throw new ExceptionWithCode(1003, "amount_eq_zero");
            }
            if (pEntity.getDebit().doubleValue() != 0.0 && pEntity.getAccDebit() == null && pEntity.getAccCredit() == null) {
                throw new ExceptionWithCode(1003, "account_is_null");
            }
            pEntity.setSourceType(this.accountingEntriesTypeCode);
            if (pEntity.getAccCredit() != null) {
                pEntity.setCredit(pEntity.getDebit());
                pEntity.setAccCredit((Account)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getAccCredit())));
                if (pEntity.getAccCredit().getSubaccType() != null && pEntity.getSubaccCreditId() == null) {
                    throw new ExceptionWithCode(1003, "select_subaccount");
                }
            }
            if (pEntity.getAccDebit() == null) {
                pEntity.setDebit(BigDecimal.ZERO);
            } else {
                pEntity.setAccDebit((Account)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getAccDebit())));
                if (pEntity.getAccDebit().getSubaccType() != null && pEntity.getSubaccDebitId() == null) {
                    throw new ExceptionWithCode(1003, "select_subaccount");
                }
            }
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            pEntity.setIsNew(false);
            AccountingEntries itsOwner = (AccountingEntries)((Object)this.getSrvOrm().retrieveEntityById(pAddParam, AccountingEntries.class, (Object)pEntity.getSourceId()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(AccountingEntries.class.getSimpleName() + ".ownerVersion"));
            itsOwner.setItsVersion(ownerVersion);
            String query = "select sum(DEBIT) as DEBIT, sum(CREDIT) as CREDIT from ACCOUNTINGENTRY where SOURCETYPE=" + this.accountingEntriesTypeCode + " and SOURCEID=" + itsOwner.getItsId();
            String[] columns = new String[]{"DEBIT", "CREDIT"};
            Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            itsOwner.setTotalDebit(BigDecimal.valueOf(totals[0]).setScale((int)accSettings.getCostPrecision(), accSettings.getRoundingMode()));
            itsOwner.setTotalCredit(BigDecimal.valueOf(totals[1]).setScale((int)accSettings.getCostPrecision(), accSettings.getRoundingMode()));
            this.getSrvOrm().updateEntity(pAddParam, (Object)itsOwner);
            this.getSrvBalance().handleNewAccountEntry(pAddParam, null, null, pEntity.getItsDate());
            pAddParam.put("nextEntity", (Object)itsOwner);
            pAddParam.put("nameOwnerEntity", AccountingEntries.class.getSimpleName());
            pRequestData.setAttribute("accSettings", (Object)accSettings);
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final Integer getAccountingEntriesTypeCode() {
        return this.accountingEntriesTypeCode;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvBalance getSrvBalance() {
        return this.srvBalance;
    }

    public final void setSrvBalance(ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
    }
}

