/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.AdditionCostLine;
import org.beigesoft.accounting.persistable.ManufacturingProcess;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcAdditionCostLineDelete<RS>
implements IEntityProcessor<AdditionCostLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    public final AdditionCostLine process(Map<String, Object> pAddParam, AdditionCostLine pEntity, IRequestData pRequestData) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
        }
        pEntity.setItsOwner((ManufacturingProcess)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(ManufacturingProcess.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        if (pEntity.getItsOwner().getIsComplete().booleanValue()) {
            throw new ExceptionWithCode(1003, "attempt_to_change_completed_manufacturing_process");
        }
        if (pEntity.getItsOwner().getHasMadeAccEntries().booleanValue()) {
            throw new ExceptionWithCode(403, "attempt_to_change_accounted_document");
        }
        this.getSrvOrm().deleteEntity(pAddParam, (Object)pEntity);
        this.updateOwner(pAddParam, pEntity);
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", ManufacturingProcess.class.getSimpleName());
        return null;
    }

    public final void updateOwner(Map<String, Object> pAddParam, AdditionCostLine pEntity) throws Exception {
        String query = "select sum(ITSTOTAL) as ITSTOTAL from ADDITIONCOSTLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
        Double total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
        pEntity.getItsOwner().setTotalAdditionCost(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getTotalMaterialsCost().add(pEntity.getItsOwner().getTotalAdditionCost()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.getItsOwner().setItsCost(pEntity.getItsOwner().getItsTotal().divide(pEntity.getItsOwner().getItsQuantity(), (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

