/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.EBankEntryResultAction;
import org.beigesoft.accounting.model.EBankEntryResultType;
import org.beigesoft.accounting.model.EBankEntryStatus;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.persistable.BankStatement;
import org.beigesoft.accounting.persistable.BankStatementLine;
import org.beigesoft.accounting.persistable.DebtorCreditor;
import org.beigesoft.accounting.persistable.PaymentFrom;
import org.beigesoft.accounting.persistable.PaymentTo;
import org.beigesoft.accounting.persistable.PrepaymentFrom;
import org.beigesoft.accounting.persistable.PrepaymentTo;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.base.ADoc;
import org.beigesoft.accounting.processor.PrcPurchaseInvoiceSave;
import org.beigesoft.accounting.processor.PrcSalesInvoiceSave;
import org.beigesoft.accounting.service.ISrvAccEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.APersistableBase;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public class PrcBankStatementLineSave<RS>
implements IEntityProcessor<BankStatementLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvI18n srvI18n;
    private ISrvAccEntry srvAccEntry;
    private PrcSalesInvoiceSave<RS> prcSalesInvoiceSave;
    private PrcPurchaseInvoiceSave<RS> prcPurchaseInvoiceSave;
    private DateFormat dateTimeNoTzFormatIso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");

    public final BankStatementLine process(Map<String, Object> pReqVars, BankStatementLine pEntity, IRequestData pRequestData) throws Exception {
        pReqVars.put("BankStatementLineitsOwnerdeepLevel", 3);
        BankStatementLine bsl = (BankStatementLine)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity));
        pReqVars.remove("BankStatementLineitsOwnerdeepLevel");
        if (bsl.getIdDatabaseBirth().intValue() != this.getSrvOrm().getIdDatabase()) {
            throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
        }
        if (bsl.getResultAction() != null) {
            throw new ExceptionWithCode(403, "attempt_to_edit_completed_bank_statement_line");
        }
        if (bsl.getItsAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new ExceptionWithCode(1003, "amount_is_zero");
        }
        String langDef = (String)pReqVars.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        String prepaymentId = pRequestData.getParameter("prepaymentId");
        if (prepaymentId != null && !"".equals(prepaymentId)) {
            this.makePrepaymentMatchingReversed(pReqVars, prepaymentId, bsl, dateFormat, langDef);
        } else {
            String paymentId = pRequestData.getParameter("paymentId");
            if (paymentId != null && !"".equals(paymentId)) {
                this.makePaymentMatchingReversed(pReqVars, paymentId, bsl, dateFormat, langDef);
            } else {
                String accentryId = pRequestData.getParameter("accentryId");
                if (accentryId != null && !"".equals(accentryId)) {
                    this.makeAccentryMatchingReversed(pReqVars, accentryId, bsl, dateFormat, langDef);
                } else {
                    String adjDocType = pRequestData.getParameter("adjDocType");
                    if (adjDocType != null && !"".equals(adjDocType) && !"-".equals(adjDocType)) {
                        if (EBankEntryStatus.VOIDED.equals((Object)bsl.getItsStatus())) {
                            throw new ExceptionWithCode(1003, "can_not_create_for_voided");
                        }
                        if ("1".equals(adjDocType)) {
                            this.createPrepayment(pReqVars, bsl, dateFormat, langDef, pRequestData);
                        } else if ("2".equals(adjDocType)) {
                            this.createPayment(pReqVars, bsl, dateFormat, langDef, pRequestData);
                        } else {
                            this.createAccentry(pReqVars, bsl, dateFormat, langDef, pRequestData);
                        }
                    } else {
                        throw new ExceptionWithCode(1003, "wrong_paramaters");
                    }
                }
            }
        }
        this.srvOrm.updateEntity(pReqVars, (Object)bsl);
        pReqVars.put("nextEntity", (Object)pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", BankStatement.class.getSimpleName());
        return null;
    }

    public final void createPayment(Map<String, Object> pReqVars, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef, IRequestData pRequestData) throws Exception {
        Date itsDate;
        Account accCash;
        BigDecimal foreignTotal;
        try {
            String forTotStr = pRequestData.getParameter("foreignTotal");
            if (forTotStr == null || "".equals(forTotStr)) {
                foreignTotal = BigDecimal.ZERO;
            } else {
                String dsep = (String)pReqVars.get("decSepv");
                if (dsep != null) {
                    String dgsep = (String)pReqVars.get("decGrSepv");
                    forTotStr = forTotStr.replace(dgsep, "").replace(dsep, ".");
                }
                foreignTotal = new BigDecimal(forTotStr);
            }
            String accCashStr = pRequestData.getParameter("accCash");
            accCash = new Account();
            accCash.setItsId(accCashStr);
            accCash = (Account)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)accCash));
            if (accCash == null) {
                throw new Exception("cant_find_account");
            }
            String itsDateStr = pRequestData.getParameter("itsDate");
            itsDate = this.dateTimeNoTzFormatIso8601.parse(itsDateStr);
        }
        catch (Exception e) {
            throw new ExceptionWithCode(1003, "wrong_paramaters", (Throwable)e);
        }
        EBankEntryResultType resultRecordType = null;
        EBankEntryResultAction resultAction = EBankEntryResultAction.CREATE;
        String resultDescription = null;
        Long resultRecordId = null;
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            SalesInvoice inv;
            try {
                String invStr = pRequestData.getParameter("invoice");
                inv = new SalesInvoice();
                inv.setItsId(Long.parseLong(invStr));
                inv = (SalesInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)inv);
                if (inv == null) {
                    throw new Exception("cant_find_debtor_invoice");
                }
            }
            catch (Exception e) {
                throw new ExceptionWithCode(1003, "wrong_paramaters", (Throwable)e);
            }
            resultRecordType = EBankEntryResultType.PREPAYMENTFROM;
            PaymentFrom pay = new PaymentFrom();
            pay.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            pay.setItsDate(itsDate);
            pay.setSalesInvoice(inv);
            pay.setAccCash(accCash);
            pay.setSubaccCash(pBsl.getItsOwner().getBankAccount().getItsName());
            pay.setSubaccCashId(pBsl.getItsOwner().getBankAccount().getItsId());
            pay.setSubaccCashType(2002);
            pay.setItsTotal(pBsl.getItsAmount().abs());
            pay.setForeignTotal(foreignTotal);
            pay.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef));
            this.getSrvOrm().insertEntity(pReqVars, (Object)pay);
            this.srvAccEntry.makeEntries(pReqVars, pay);
            this.prcSalesInvoiceSave.calculateTotalPayment(pReqVars, pay.getSalesInvoice());
            this.getSrvOrm().updateEntity(pReqVars, (Object)pay.getSalesInvoice());
            resultRecordId = pay.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)pay, pay.getItsDate(), pLangDef);
        } else {
            PurchaseInvoice inv;
            try {
                String invStr = pRequestData.getParameter("invoice");
                inv = new PurchaseInvoice();
                inv.setItsId(Long.parseLong(invStr));
                inv = (PurchaseInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)inv);
                if (inv == null) {
                    throw new Exception("cant_find_debtor_invoice");
                }
            }
            catch (Exception e) {
                throw new ExceptionWithCode(1003, "wrong_paramaters", (Throwable)e);
            }
            resultRecordType = EBankEntryResultType.PREPAYMENTTO;
            PaymentTo pay = new PaymentTo();
            pay.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            pay.setItsDate(itsDate);
            pay.setPurchaseInvoice(inv);
            pay.setAccCash(accCash);
            pay.setSubaccCash(pBsl.getItsOwner().getBankAccount().getItsName());
            pay.setSubaccCashId(pBsl.getItsOwner().getBankAccount().getItsId());
            pay.setSubaccCashType(2002);
            pay.setItsTotal(pBsl.getItsAmount().abs());
            pay.setForeignTotal(foreignTotal);
            pay.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef));
            this.getSrvOrm().insertEntity(pReqVars, (Object)pay);
            this.srvAccEntry.makeEntries(pReqVars, pay);
            this.prcPurchaseInvoiceSave.calculateTotalPayment(pReqVars, pay.getPurchaseInvoice());
            this.getSrvOrm().updateEntity(pReqVars, (Object)pay.getPurchaseInvoice());
            resultRecordId = pay.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)pay, pay.getItsDate(), pLangDef);
        }
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void createPrepayment(Map<String, Object> pReqVars, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef, IRequestData pRequestData) throws Exception {
        Date itsDate;
        Account accCash;
        DebtorCreditor dc;
        BigDecimal foreignTotal;
        try {
            String forTotStr = pRequestData.getParameter("foreignTotal");
            if (forTotStr == null || "".equals(forTotStr)) {
                foreignTotal = BigDecimal.ZERO;
            } else {
                String dsep = (String)pReqVars.get("decSepv");
                if (dsep != null) {
                    String dgsep = (String)pReqVars.get("decGrSepv");
                    forTotStr = forTotStr.replace(dgsep, "").replace(dsep, ".");
                }
                foreignTotal = new BigDecimal(forTotStr);
            }
            String dcIdStr = pRequestData.getParameter("debtorCreditor");
            dc = new DebtorCreditor();
            dc.setItsId(Long.parseLong(dcIdStr));
            dc = (DebtorCreditor)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)dc));
            if (dc == null) {
                throw new Exception("cant_find_debtor_creditor");
            }
            String accCashStr = pRequestData.getParameter("accCash");
            accCash = new Account();
            accCash.setItsId(accCashStr);
            accCash = (Account)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)accCash));
            if (accCash == null) {
                throw new Exception("cant_find_account");
            }
            String itsDateStr = pRequestData.getParameter("itsDate");
            itsDate = this.dateTimeNoTzFormatIso8601.parse(itsDateStr);
        }
        catch (Exception e) {
            throw new ExceptionWithCode(1003, "wrong_paramaters", (Throwable)e);
        }
        EBankEntryResultType resultRecordType = null;
        EBankEntryResultAction resultAction = EBankEntryResultAction.CREATE;
        String resultDescription = null;
        Long resultRecordId = null;
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            resultRecordType = EBankEntryResultType.PREPAYMENTFROM;
            PrepaymentFrom prep = new PrepaymentFrom();
            prep.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            prep.setItsDate(itsDate);
            prep.setCustomer(dc);
            prep.setAccCash(accCash);
            prep.setSubaccCash(pBsl.getItsOwner().getBankAccount().getItsName());
            prep.setSubaccCashId(pBsl.getItsOwner().getBankAccount().getItsId());
            prep.setSubaccCashType(2002);
            prep.setItsTotal(pBsl.getItsAmount().abs());
            prep.setForeignTotal(foreignTotal);
            prep.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef));
            this.getSrvOrm().insertEntity(pReqVars, (Object)prep);
            this.srvAccEntry.makeEntries(pReqVars, prep);
            resultRecordId = prep.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)prep, prep.getItsDate(), pLangDef);
        } else {
            resultRecordType = EBankEntryResultType.PREPAYMENTTO;
            PrepaymentTo prep = new PrepaymentTo();
            prep.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
            prep.setVendor(dc);
            prep.setItsDate(itsDate);
            prep.setAccCash(accCash);
            prep.setSubaccCash(pBsl.getItsOwner().getBankAccount().getItsName());
            prep.setSubaccCashId(pBsl.getItsOwner().getBankAccount().getItsId());
            prep.setSubaccCashType(2002);
            prep.setItsTotal(pBsl.getItsAmount().abs());
            prep.setForeignTotal(foreignTotal);
            prep.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef));
            this.getSrvOrm().insertEntity(pReqVars, (Object)prep);
            this.srvAccEntry.makeEntries(pReqVars, prep);
            resultRecordId = prep.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)prep, prep.getItsDate(), pLangDef);
        }
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void createAccentry(Map<String, Object> pReqVars, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef, IRequestData pRequestData) throws Exception {
        Date itsDate;
        Account corAcc;
        Account accCash;
        String subcorAcc = null;
        Long subcorAccId = null;
        Integer subcorAccType = null;
        try {
            String accCashStr = pRequestData.getParameter("accCash");
            accCash = new Account();
            accCash.setItsId(accCashStr);
            accCash = (Account)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)accCash));
            if (accCash == null) {
                throw new Exception("cant_find_account");
            }
            String corAccStr = pRequestData.getParameter("corAcc");
            corAcc = new Account();
            corAcc.setItsId(corAccStr);
            corAcc = (Account)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)corAcc));
            if (corAcc == null) {
                throw new Exception("cant_find_account");
            }
            if (corAcc.getSubaccType() != null) {
                subcorAcc = pRequestData.getParameter("subcorAcc");
                String subcorAccTypeStr = pRequestData.getParameter("subcorAccType");
                subcorAccType = Integer.parseInt(subcorAccTypeStr);
                String subcorAccIdStr = pRequestData.getParameter("subcorAccId");
                subcorAccId = Long.parseLong(subcorAccIdStr);
            }
            String itsDateStr = pRequestData.getParameter("itsDate");
            itsDate = this.dateTimeNoTzFormatIso8601.parse(itsDateStr);
        }
        catch (Exception e) {
            throw new ExceptionWithCode(1003, "wrong_paramaters", (Throwable)e);
        }
        EBankEntryResultType resultRecordType = EBankEntryResultType.ACC_ENTRY;
        EBankEntryResultAction resultAction = EBankEntryResultAction.CREATE;
        String resultDescription = null;
        Long resultRecordId = null;
        AccountingEntry accent = new AccountingEntry();
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            accent.setAccDebit(accCash);
            accent.setSubaccDebit(pBsl.getItsOwner().getBankAccount().getItsName());
            accent.setSubaccDebitId(pBsl.getItsOwner().getBankAccount().getItsId());
            accent.setSubaccDebitType(2002);
            accent.setAccCredit(corAcc);
            accent.setSubaccCredit(subcorAcc);
            accent.setSubaccCreditId(subcorAccId);
            accent.setSubaccCreditType(subcorAccType);
        } else {
            accent.setAccDebit(corAcc);
            accent.setSubaccDebit(subcorAcc);
            accent.setSubaccDebitId(subcorAccId);
            accent.setSubaccDebitType(subcorAccType);
            accent.setAccCredit(accCash);
            accent.setSubaccCredit(pBsl.getItsOwner().getBankAccount().getItsName());
            accent.setSubaccCreditId(pBsl.getItsOwner().getBankAccount().getItsId());
            accent.setSubaccCreditType(2002);
        }
        accent.setSourceType(pBsl.constTypeCode());
        accent.setSourceId(pBsl.getItsId());
        accent.setSourceDatabaseBirth(pBsl.getIdDatabaseBirth());
        accent.setIdDatabaseBirth(pBsl.getIdDatabaseBirth());
        accent.setItsDate(itsDate);
        accent.setDebit(pBsl.getItsAmount().abs());
        accent.setCredit(accent.getDebit());
        accent.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef));
        this.getSrvOrm().insertEntity(pReqVars, (Object)accent);
        accent.setIsNew(false);
        resultRecordId = accent.getItsId();
        resultDescription = this.makeBslResDescr(resultAction, pDateFormat, accent, accent.getItsDate(), pLangDef);
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void makeAccentryMatchingReversed(Map<String, Object> pReqVars, String pEntryId, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef) throws Exception {
        EBankEntryResultType resultRecordType = EBankEntryResultType.ACC_ENTRY;
        EBankEntryResultAction resultAction = null;
        String resultDescription = null;
        Long resultRecordId = null;
        AccountingEntry accent = (AccountingEntry)((Object)this.getSrvOrm().retrieveEntityById(pReqVars, AccountingEntry.class, (Object)Long.parseLong(pEntryId)));
        if (accent == null) {
            throw new ExceptionWithCode(1003, "cant_found_accentry");
        }
        if (accent.getSourceType() == 1010) {
            throw new ExceptionWithCode(1003, "AlreadyDone");
        }
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0 && pBsl.getItsAmount().compareTo(accent.getDebit()) != 0 && accent.getSubaccDebitType() != 2002 && !pBsl.getItsOwner().getBankAccount().getItsId().equals(accent.getSubaccDebitId())) {
            throw new ExceptionWithCode(1003, "record_is_not_matching");
        }
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) < 0 && pBsl.getItsAmount().abs().compareTo(accent.getCredit()) != 0 && accent.getSubaccCreditType() != 2002 && !pBsl.getItsOwner().getBankAccount().getItsId().equals(accent.getSubaccCreditId())) {
            throw new ExceptionWithCode(1003, "record_is_not_matching");
        }
        if (EBankEntryStatus.VOIDED.equals((Object)pBsl.getItsStatus())) {
            if (accent.getIdDatabaseBirth().intValue() != this.getSrvOrm().getIdDatabase()) {
                throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
            }
            resultAction = EBankEntryResultAction.CREATE;
            AccountingEntry reversed = accent;
            accent = new AccountingEntry();
            accent.setSourceType(pBsl.constTypeCode());
            accent.setSourceId(pBsl.getItsId());
            accent.setSourceDatabaseBirth(pBsl.getIdDatabaseBirth());
            accent.setIdDatabaseBirth(reversed.getIdDatabaseBirth());
            accent.setReversedId(reversed.getItsId());
            accent.setReversedIdDatabaseBirth(reversed.getIdDatabaseBirth());
            accent.setItsDate(new Date(reversed.getItsDate().getTime() + 1L));
            accent.setAccDebit(reversed.getAccDebit());
            accent.setSubaccDebit(reversed.getSubaccDebit());
            accent.setSubaccDebitId(reversed.getSubaccDebitId());
            accent.setSubaccDebitType(reversed.getSubaccDebitType());
            accent.setDebit(reversed.getDebit().negate());
            accent.setAccCredit(reversed.getAccCredit());
            accent.setSubaccCredit(reversed.getSubaccCredit());
            accent.setSubaccCreditId(reversed.getSubaccCreditId());
            accent.setSubaccCreditType(reversed.getSubaccCreditType());
            accent.setCredit(reversed.getCredit().negate());
            accent.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef) + " " + this.getSrvI18n().getMsg("reversed_n", pLangDef) + accent.getReversedIdDatabaseBirth() + "-" + accent.getReversedId());
            this.getSrvOrm().insertEntity(pReqVars, (Object)accent);
            accent.setIsNew(false);
            String oldDesr = "";
            if (reversed.getDescription() != null) {
                oldDesr = reversed.getDescription();
            }
            reversed.setDescription(oldDesr + " " + this.getSrvI18n().getMsg("reversing_n", pLangDef) + accent.getIdDatabaseBirth() + "-" + accent.getItsId());
            reversed.setReversedId(accent.getItsId());
            reversed.setReversedIdDatabaseBirth(accent.getIdDatabaseBirth());
            this.getSrvOrm().updateEntity(pReqVars, (Object)reversed);
        } else {
            resultAction = EBankEntryResultAction.MATCH;
        }
        resultRecordId = accent.getItsId();
        resultDescription = this.makeBslResDescr(resultAction, pDateFormat, accent, accent.getItsDate(), pLangDef);
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void makePaymentMatchingReversed(Map<String, Object> pReqVars, String pPayId, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef) throws Exception {
        EBankEntryResultType resultRecordType = null;
        EBankEntryResultAction resultAction = null;
        String resultDescription = null;
        Long resultRecordId = null;
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            PaymentFrom pay = (PaymentFrom)this.getSrvOrm().retrieveEntityById(pReqVars, PaymentFrom.class, (Object)Long.parseLong(pPayId));
            if (!pay.getHasMadeAccEntries().booleanValue() || pBsl.getItsAmount().abs().compareTo(pay.getItsTotal()) != 0 || pay.getSubaccCashType() != 2002 || !pBsl.getItsOwner().getBankAccount().getItsId().equals(pay.getSubaccCashId())) {
                throw new ExceptionWithCode(1003, "record_is_not_matching");
            }
            resultRecordType = EBankEntryResultType.PAYMENTFROM;
            if (EBankEntryStatus.VOIDED.equals((Object)pBsl.getItsStatus()) && pay.getReversedId() == null) {
                resultAction = EBankEntryResultAction.CREATE;
                PaymentFrom reversed = pay;
                pay = new PaymentFrom();
                pay.setAccCash(reversed.getAccCash());
                pay.setSubaccCash(reversed.getSubaccCash());
                pay.setSubaccCashId(reversed.getSubaccCashId());
                pay.setSubaccCashType(2002);
                pay.setSalesInvoice(reversed.getSalesInvoice());
                pay.setForeignTotal(reversed.getForeignTotal().negate());
                pay.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef) + " " + this.getSrvI18n().getMsg("reversed_n", pLangDef) + reversed.getIdDatabaseBirth() + "-" + reversed.getItsId());
                this.makeDocReversed(pReqVars, pay, reversed, pLangDef);
            } else {
                resultAction = EBankEntryResultAction.MATCH;
            }
            resultRecordId = pay.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)pay, pay.getItsDate(), pLangDef);
        } else {
            PaymentTo pay = (PaymentTo)this.getSrvOrm().retrieveEntityById(pReqVars, PaymentTo.class, (Object)Long.parseLong(pPayId));
            if (!pay.getHasMadeAccEntries().booleanValue() || pBsl.getItsAmount().abs().compareTo(pay.getItsTotal()) != 0 || pay.getSubaccCashType() != 2002 || !pBsl.getItsOwner().getBankAccount().getItsId().equals(pay.getSubaccCashId())) {
                throw new ExceptionWithCode(1003, "record_is_not_matching");
            }
            resultRecordType = EBankEntryResultType.PAYMENTTO;
            if (EBankEntryStatus.VOIDED.equals((Object)pBsl.getItsStatus()) && pay.getReversedId() == null) {
                resultAction = EBankEntryResultAction.CREATE;
                PaymentTo reversed = pay;
                pay = new PaymentTo();
                pay.setAccCash(reversed.getAccCash());
                pay.setSubaccCash(reversed.getSubaccCash());
                pay.setSubaccCashId(reversed.getSubaccCashId());
                pay.setSubaccCashType(2002);
                pay.setPurchaseInvoice(reversed.getPurchaseInvoice());
                pay.setForeignTotal(reversed.getForeignTotal().negate());
                pay.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef) + " " + this.getSrvI18n().getMsg("reversed_n", pLangDef) + reversed.getIdDatabaseBirth() + "-" + reversed.getItsId());
                this.makeDocReversed(pReqVars, pay, reversed, pLangDef);
            } else {
                resultAction = EBankEntryResultAction.MATCH;
            }
            resultRecordId = pay.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)pay, pay.getItsDate(), pLangDef);
        }
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void makePrepaymentMatchingReversed(Map<String, Object> pReqVars, String pPrepayId, BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef) throws Exception {
        EBankEntryResultType resultRecordType = null;
        EBankEntryResultAction resultAction = null;
        String resultDescription = null;
        Long resultRecordId = null;
        if (pBsl.getItsAmount().compareTo(BigDecimal.ZERO) > 0) {
            PrepaymentFrom prep = (PrepaymentFrom)this.getSrvOrm().retrieveEntityById(pReqVars, PrepaymentFrom.class, (Object)Long.parseLong(pPrepayId));
            if (!prep.getHasMadeAccEntries().booleanValue() || pBsl.getItsAmount().abs().compareTo(prep.getItsTotal().abs()) != 0 || prep.getSubaccCashType() != 2002 || !pBsl.getItsOwner().getBankAccount().getItsId().equals(prep.getSubaccCashId())) {
                throw new ExceptionWithCode(1003, "record_is_not_matching");
            }
            resultRecordType = EBankEntryResultType.PREPAYMENTFROM;
            if (EBankEntryStatus.VOIDED.equals((Object)pBsl.getItsStatus()) && prep.getReversedId() == null) {
                resultAction = EBankEntryResultAction.CREATE;
                PrepaymentFrom reversed = prep;
                prep = new PrepaymentFrom();
                prep.setAccCash(reversed.getAccCash());
                prep.setSubaccCash(reversed.getSubaccCash());
                prep.setSubaccCashId(reversed.getSubaccCashId());
                prep.setSubaccCashType(2002);
                prep.setCustomer(reversed.getCustomer());
                prep.setForeignTotal(reversed.getForeignTotal().negate());
                prep.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef) + " " + this.getSrvI18n().getMsg("reversed_n", pLangDef) + reversed.getIdDatabaseBirth() + "-" + reversed.getItsId());
                this.makeDocReversed(pReqVars, prep, reversed, pLangDef);
            } else {
                resultAction = EBankEntryResultAction.MATCH;
            }
            resultRecordId = prep.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)prep, prep.getItsDate(), pLangDef);
        } else {
            PrepaymentTo prep = (PrepaymentTo)this.getSrvOrm().retrieveEntityById(pReqVars, PrepaymentTo.class, (Object)Long.parseLong(pPrepayId));
            if (!prep.getHasMadeAccEntries().booleanValue() || pBsl.getItsAmount().abs().compareTo(prep.getItsTotal().abs()) != 0 || prep.getSubaccCashType() != 2002 || !pBsl.getItsOwner().getBankAccount().getItsId().equals(prep.getSubaccCashId())) {
                throw new ExceptionWithCode(1003, "record_is_not_matching");
            }
            resultRecordType = EBankEntryResultType.PREPAYMENTTO;
            if (EBankEntryStatus.VOIDED.equals((Object)pBsl.getItsStatus()) && prep.getReversedId() == null) {
                resultAction = EBankEntryResultAction.CREATE;
                PrepaymentTo reversed = prep;
                prep = new PrepaymentTo();
                prep.setAccCash(reversed.getAccCash());
                prep.setSubaccCash(reversed.getSubaccCash());
                prep.setSubaccCashId(reversed.getSubaccCashId());
                prep.setSubaccCashType(2002);
                prep.setVendor(reversed.getVendor());
                prep.setForeignTotal(reversed.getForeignTotal().negate());
                prep.setDescription(this.makeDescrForCreated(pBsl, pDateFormat, pLangDef) + " " + this.getSrvI18n().getMsg("reversed_n", pLangDef) + reversed.getIdDatabaseBirth() + "-" + reversed.getItsId());
                this.makeDocReversed(pReqVars, prep, reversed, pLangDef);
            } else {
                resultAction = EBankEntryResultAction.MATCH;
            }
            resultRecordId = prep.getItsId();
            resultDescription = this.makeBslResDescr(resultAction, pDateFormat, (APersistableBase)prep, prep.getItsDate(), pLangDef);
        }
        pBsl.setResultAction(resultAction);
        pBsl.setResultRecordType(resultRecordType);
        pBsl.setResultRecordId(resultRecordId);
        pBsl.setResultDescription(resultDescription);
        this.getSrvOrm().updateEntity(pReqVars, (Object)pBsl);
    }

    public final void makeDocReversed(Map<String, Object> pReqVars, ADoc pReversing, ADoc pReversed, String pLangDef) throws Exception {
        pReversing.setIdDatabaseBirth(pReversed.getIdDatabaseBirth());
        pReversing.setReversedId(pReversed.getItsId());
        pReversing.setReversedIdDatabaseBirth(pReversed.getIdDatabaseBirth());
        pReversing.setItsDate(new Date(pReversed.getItsDate().getTime() + 1L));
        pReversing.setItsTotal(pReversed.getItsTotal().negate());
        pReversing.setHasMadeAccEntries(false);
        this.getSrvOrm().insertEntity(pReqVars, (Object)pReversing);
        pReversing.setIsNew(false);
        String oldDesr = "";
        if (pReversed.getDescription() != null) {
            oldDesr = pReversed.getDescription();
        }
        pReversed.setDescription(oldDesr + " " + this.getSrvI18n().getMsg("reversing_n", pLangDef) + pReversing.getIdDatabaseBirth() + "-" + pReversing.getItsId());
        pReversed.setReversedId(pReversing.getItsId());
        pReversed.setReversedIdDatabaseBirth(pReversing.getIdDatabaseBirth());
        this.getSrvOrm().updateEntity(pReqVars, (Object)pReversed);
        this.srvAccEntry.reverseEntries(pReqVars, pReversing, pReversed);
    }

    public final String makeBslResDescr(EBankEntryResultAction pResAct, DateFormat pDateFormat, APersistableBase pRecord, Date pDate, String pLangDef) {
        StringBuffer sb = new StringBuffer();
        if (EBankEntryResultAction.MATCH.equals((Object)pResAct)) {
            sb.append(this.getSrvI18n().getMsg("Found", pLangDef));
        } else {
            sb.append(this.getSrvI18n().getMsg("Created", pLangDef));
        }
        sb.append(" " + this.getSrvI18n().getMsg(pRecord.getClass().getSimpleName() + "short", pLangDef));
        sb.append("#" + pRecord.getIdDatabaseBirth() + "-" + pRecord.getItsId() + ", " + pDateFormat.format(pDate));
        return sb.toString();
    }

    public final String makeDescrForCreated(BankStatementLine pBsl, DateFormat pDateFormat, String pLangDef) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSrvI18n().getMsg("Created", pLangDef) + " " + this.getSrvI18n().getMsg("by", pLangDef));
        sb.append(" " + this.getSrvI18n().getMsg(((Object)((Object)pBsl)).getClass().getSimpleName() + "short", pLangDef));
        sb.append("#" + pBsl.getIdDatabaseBirth() + "-" + pBsl.getItsId() + ", " + pDateFormat.format(pBsl.getItsDate()));
        sb.append(" (" + pBsl.getDescriptionStatus() + ")");
        return sb.toString();
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvAccEntry getSrvAccEntry() {
        return this.srvAccEntry;
    }

    public final void setSrvAccEntry(ISrvAccEntry pSrvAccEntry) {
        this.srvAccEntry = pSrvAccEntry;
    }

    public final PrcPurchaseInvoiceSave<RS> getPrcPurchaseInvoiceSave() {
        return this.prcPurchaseInvoiceSave;
    }

    public final void setPrcPurchaseInvoiceSave(PrcPurchaseInvoiceSave<RS> pPrcPurchaseInvoiceSave) {
        this.prcPurchaseInvoiceSave = pPrcPurchaseInvoiceSave;
    }

    public final PrcSalesInvoiceSave<RS> getPrcSalesInvoiceSave() {
        return this.prcSalesInvoiceSave;
    }

    public final void setPrcSalesInvoiceSave(PrcSalesInvoiceSave<RS> pPrcSalesInvoiceSave) {
        this.prcSalesInvoiceSave = pPrcSalesInvoiceSave;
    }
}

