/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.IInvoice;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.persistable.base.ADocTaxLine;
import org.beigesoft.accounting.persistable.base.ADocTaxLineFc;
import org.beigesoft.accounting.persistable.base.AInvTxLn;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcInvTaxLnSave<RS, T extends IInvoice, TL extends AInvTxLn<T>>
implements IEntityProcessor<TL, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;
    private UtlInvLine<RS, T, ?, ?, ?> utlInvLine;

    public final TL process(Map<String, Object> pReqVars, TL pEntity, IRequestData pRequestData) throws Exception {
        if (((ADocTaxLine)((Object)pEntity)).getItsTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
        }
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, (IInvoice)pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromPurchase());
        if (txRules == null) {
            throw new ExceptionWithCode(1003, "non_taxable");
        }
        if (!txRules.getSalTaxIsInvoiceBase().booleanValue()) {
            throw new ExceptionWithCode(1003, "cant_edit_item_basis_tax");
        }
        AInvTxLn oldEntity = (AInvTxLn)((Object)this.getSrvOrm().retrieveEntity(pReqVars, pEntity));
        ((ADocTaxLine)((Object)pEntity)).setTax(oldEntity.getTax());
        ((AInvTxLn)((Object)pEntity)).setTaxableInvBas(oldEntity.getTaxableInvBas());
        ((AInvTxLn)((Object)pEntity)).setTaxableInvBasFc(oldEntity.getTaxableInvBasFc());
        ((ADocTaxLine)((Object)pEntity)).setItsTotal(((ADocTaxLine)((Object)pEntity)).getItsTotal().setScale((int)as.getPricePrecision(), txRules.getSalTaxRoundMode()));
        if (((IInvoice)pEntity.getItsOwner()).getForeignCurrency() != null) {
            BigDecimal exchRate = ((IInvoice)pEntity.getItsOwner()).getExchangeRate();
            if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
            }
            ((ADocTaxLineFc)((Object)pEntity)).setForeignTotalTaxes(((ADocTaxLine)((Object)pEntity)).getItsTotal().divide(exchRate, (int)as.getPricePrecision(), as.getRoundingMode()));
        }
        if (((ADocTaxLine)((Object)pEntity)).getItsTotal().compareTo(oldEntity.getItsTotal()) != 0) {
            if (((IInvoice)pEntity.getItsOwner()).getDescription() == null) {
                ((IInvoice)pEntity.getItsOwner()).setDescription(((ADocTaxLine)((Object)pEntity)).getTax().getItsName() + ": " + oldEntity.getItsTotal() + "->" + ((ADocTaxLine)((Object)pEntity)).getItsTotal() + "!");
            } else {
                ((IInvoice)pEntity.getItsOwner()).setDescription(((IInvoice)pEntity.getItsOwner()).getDescription() + " " + ((ADocTaxLine)((Object)pEntity)).getTax().getItsName() + ": " + oldEntity.getItsTotal() + "->" + ((ADocTaxLine)((Object)pEntity)).getItsTotal() + "!");
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, pEntity);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(((IInvoice)pEntity.getItsOwner()).getClass().getSimpleName() + ".ownerVersion"));
        ((IInvoice)pEntity.getItsOwner()).setItsVersion(ownerVersion);
        this.utlInvLine.adjInvLnsUpdTots(pReqVars, (IInvoice)pEntity.getItsOwner(), as, txRules);
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", ((IInvoice)pEntity.getItsOwner()).getClass().getSimpleName());
        return null;
    }

    public final UtlInvLine<RS, T, ?, ?, ?> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, T, ?, ?, ?> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

