/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.DebtorCreditor;
import org.beigesoft.accounting.persistable.PaymentTo;
import org.beigesoft.accounting.persistable.PrepaymentTo;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceTaxLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.processor.APrcAccDocFullSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcPurchaseInvoiceSave<RS>
extends APrcAccDocFullSave<RS, PurchaseInvoice> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pReqVars, PurchaseInvoice pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getPrepaymentTo() != null) {
            pEntity.setPrepaymentTo((PrepaymentTo)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getPrepaymentTo()));
            if (pEntity.getReversedId() == null && pEntity.getPrepaymentTo().getPurchaseInvoiceId() != null && !pEntity.getHasMadeAccEntries().booleanValue()) {
                throw new ExceptionWithCode(1003, "prepayment_already_in_use");
            }
            if (pEntity.getReversedId() == null && !pEntity.getPrepaymentTo().getVendor().getItsId().equals(pEntity.getVendor().getItsId())) {
                throw new ExceptionWithCode(1003, "prepayment_for_different_vendor");
            }
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentTo() != null && pEntity.getPaymentTotal().compareTo(pEntity.getPrepaymentTo().getItsTotal()) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentTo() == null && pEntity.getPaymentTotal().compareTo(BigDecimal.ZERO) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() == null) {
            this.calculateTotalPayment(pReqVars, pEntity);
        }
        if (!pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        }
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pReqVars, PurchaseInvoice pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd)) {
            if (pEntity.getReversedId() != null) {
                PurchaseInvoiceLine pil = new PurchaseInvoiceLine();
                PurchaseInvoice reversed = new PurchaseInvoice();
                reversed.setItsId(pEntity.getReversedId());
                pil.setItsOwner(reversed);
                List reversedLines = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pil, "itsOwner");
                String langDef = (String)pReqVars.get("langDef");
                for (PurchaseInvoiceLine reversedLine : reversedLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    if (!reversedLine.getItsQuantity().equals(reversedLine.getTheRest())) {
                        throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
                    }
                    PurchaseInvoiceLine reversingLine = new PurchaseInvoiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setWarehouseSite(reversedLine.getWarehouseSite());
                    reversingLine.setInvItem(reversedLine.getInvItem());
                    reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                    reversingLine.setItsCost(reversedLine.getItsCost());
                    reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setForeignPrice(reversedLine.getForeignPrice());
                    reversingLine.setForeignSubtotal(reversedLine.getForeignSubtotal().negate());
                    reversingLine.setForeignTotalTaxes(reversedLine.getForeignTotalTaxes().negate());
                    reversingLine.setForeignTotal(reversedLine.getForeignTotal().negate());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_entry_n", langDef) + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                    this.getSrvOrm().insertEntity(pReqVars, (Object)reversingLine);
                    reversingLine.setIsNew(false);
                    this.getSrvWarehouseEntry().load(pReqVars, reversingLine, reversingLine.getWarehouseSite());
                    String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                    reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                    reversedLine.setReversedId(reversingLine.getItsId());
                    reversedLine.setTheRest(BigDecimal.ZERO);
                    this.getSrvOrm().updateEntity(pReqVars, (Object)reversedLine);
                    PurchaseInvoiceGoodsTaxLine pigtlt = new PurchaseInvoiceGoodsTaxLine();
                    pigtlt.setItsOwner(reversedLine);
                    List tls = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pigtlt, "itsOwner");
                    for (PurchaseInvoiceGoodsTaxLine pigtl : tls) {
                        this.getSrvOrm().deleteEntity(pReqVars, (Object)pigtl);
                    }
                }
                PurchaseInvoiceServiceLine pisl = new PurchaseInvoiceServiceLine();
                pisl.setItsOwner(reversed);
                List revServLines = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pisl, "itsOwner");
                for (PurchaseInvoiceServiceLine reversedLine : revServLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    PurchaseInvoiceServiceLine reversingLine = new PurchaseInvoiceServiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setService(reversedLine.getService());
                    reversingLine.setAccExpense(reversedLine.getAccExpense());
                    reversingLine.setItsCost(reversedLine.getItsCost().negate());
                    reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                    reversingLine.setItsCost(reversedLine.getItsCost());
                    reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setForeignPrice(reversedLine.getForeignPrice());
                    reversingLine.setForeignSubtotal(reversedLine.getForeignSubtotal().negate());
                    reversingLine.setForeignTotalTaxes(reversedLine.getForeignTotalTaxes().negate());
                    reversingLine.setForeignTotal(reversedLine.getForeignTotal().negate());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pReqVars, (Object)reversingLine);
                    reversingLine.setIsNew(false);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pReqVars, (Object)reversedLine);
                    PurchaseInvoiceServiceTaxLine pigtlt = new PurchaseInvoiceServiceTaxLine();
                    pigtlt.setItsOwner(reversedLine);
                    List tls = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pigtlt, "itsOwner");
                    for (PurchaseInvoiceServiceTaxLine pigtl : tls) {
                        this.getSrvOrm().deleteEntity(pReqVars, (Object)pigtl);
                    }
                }
                PurchaseInvoiceTaxLine pitl = new PurchaseInvoiceTaxLine();
                pitl.setItsOwner(reversed);
                List reversedTaxLines = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pitl, "itsOwner");
                for (PurchaseInvoiceTaxLine reversedLine : reversedTaxLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    PurchaseInvoiceTaxLine reversingLine = new PurchaseInvoiceTaxLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setForeignTotalTaxes(reversedLine.getForeignTotalTaxes().negate());
                    reversingLine.setTax(reversedLine.getTax());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pReqVars, (Object)reversingLine);
                    reversingLine.setIsNew(false);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pReqVars, (Object)reversedLine);
                }
            }
            if (pEntity.getPrepaymentTo() != null) {
                if (pEntity.getReversedId() != null) {
                    pEntity.getPrepaymentTo().setPurchaseInvoiceId(null);
                } else {
                    pEntity.getPrepaymentTo().setPurchaseInvoiceId(pEntity.getItsId());
                }
                this.getSrvOrm().updateEntity(pReqVars, (Object)pEntity.getPrepaymentTo());
            }
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pReqVars, PurchaseInvoice pEntity, IRequestData pRequestData, PurchaseInvoice pOldEntity) throws Exception {
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        pReqVars.remove("DebtorCreditorneededFields");
        if (pEntity.getItsTotal().compareTo(BigDecimal.ZERO) == 1) {
            if (!pOldEntity.getVendor().getItsId().equals(pEntity.getVendor().getItsId())) {
                pEntity.setVendor((DebtorCreditor)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getVendor())));
                if (pOldEntity.getVendor().getTaxDestination() != null || pEntity.getVendor().getTaxDestination() != null) {
                    throw new ExceptionWithCode(1003, "can_not_cange_customer_with_another_tax_destination");
                }
            }
            if (!pOldEntity.getOmitTaxes().equals(pEntity.getOmitTaxes()) || !pOldEntity.getPriceIncTax().equals(pEntity.getPriceIncTax())) {
                throw new ExceptionWithCode(1003, "can_not_change_tax_method");
            }
        }
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pReqVars, PurchaseInvoice pEntity, IRequestData pRequestData) throws Exception {
    }

    public final void calculateTotalPayment(Map<String, Object> pReqVars, PurchaseInvoice pEntity) throws Exception {
        String langDef = (String)pReqVars.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        if (pEntity.getPrepaymentTo() != null) {
            if (pEntity.getForeignCurrency() != null) {
                pEntity.setPaymentTotal(pEntity.getPrepaymentTo().getForeignTotal());
            } else {
                pEntity.setPaymentTotal(pEntity.getPrepaymentTo().getItsTotal());
            }
            pEntity.setPaymentDescription(this.getSrvI18n().getMsg(PrepaymentTo.class.getSimpleName() + "short", langDef) + " #" + pEntity.getPrepaymentTo().getIdDatabaseBirth() + "-" + pEntity.getPrepaymentTo().getItsId() + ", " + dateFormat.format(pEntity.getPrepaymentTo().getItsDate()) + ", " + pEntity.getPaymentTotal());
        } else {
            pEntity.setPaymentTotal(BigDecimal.ZERO);
            pEntity.setPaymentDescription("");
        }
        List payments = this.getSrvOrm().retrieveListWithConditions(pReqVars, PaymentTo.class, "where PAYMENTTO.HASMADEACCENTRIES=1 and PAYMENTTO.REVERSEDID is null and PURCHASEINVOICE=" + pEntity.getItsId());
        for (PaymentTo payment : payments) {
            if (pEntity.getForeignCurrency() != null) {
                pEntity.setPaymentTotal(pEntity.getPaymentTotal().add(payment.getForeignTotal()));
            } else {
                pEntity.setPaymentTotal(pEntity.getPaymentTotal().add(payment.getItsTotal()));
            }
            pEntity.setPaymentDescription(pEntity.getPaymentDescription() + " " + this.getSrvI18n().getMsg(PaymentTo.class.getSimpleName() + "short", langDef) + " #" + payment.getIdDatabaseBirth() + "-" + payment.getItsId() + ", " + dateFormat.format(payment.getItsDate()) + ", " + payment.getItsTotal());
        }
    }
}

