/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceTaxLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.persistable.ServicePurchased;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseInvoiceServiceLineSave<RS>
implements IEntityProcessor<PurchaseInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceServiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceServiceTaxLine> utlInvLine;
    private ISrvAccSettings srvAccSettings;

    public final PurchaseInvoiceServiceLine process(Map<String, Object> pReqVars, PurchaseInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
        }
        if (pEntity.getItsCost().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pReqVars.get("user"));
        }
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner((PurchaseInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        pEntity.setService((ServicePurchased)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getService())));
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromPurchase());
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
            if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
            }
            pEntity.setItsCost(pEntity.getForeignPrice().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                pEntity.setItsTotal(pEntity.getForeignTotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            } else {
                pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            }
        }
        this.utlInvLine.makeLine(pReqVars, pEntity, as, txRules);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlInvLine.makeTotals(pReqVars, pEntity, as, txRules);
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
        return null;
    }

    public final UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceServiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceServiceTaxLine> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, PurchaseInvoice, PurchaseInvoiceServiceLine, PurchaseInvoiceTaxLine, PurchaseInvoiceServiceTaxLine> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

