/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.CogsEntry;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<CogsEntry> srvCogsEntry;
    private ISrvAccSettings srvAccSettings;
    private UtlInvLine<RS, SalesInvoice, SalesInvoiceLine, SalesInvoiceTaxLine, SalesInvoiceGoodsTaxLine> utlInvLine;

    public final SalesInvoiceLine process(Map<String, Object> pReqVars, SalesInvoiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            pEntity.setItsOwner((SalesInvoice)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromSales());
            if (pEntity.getReversedId() != null) {
                SalesInvoiceLine reversed = (SalesInvoiceLine)this.getSrvOrm().retrieveEntityById(pReqVars, SalesInvoiceLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pReqVars.get("user"));
                }
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setTaxCategory(reversed.getTaxCategory());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsPrice(reversed.getItsPrice());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                pEntity.setForeignPrice(reversed.getForeignPrice());
                pEntity.setForeignSubtotal(reversed.getForeignSubtotal().negate());
                pEntity.setForeignTotalTaxes(reversed.getForeignTotalTaxes().negate());
                pEntity.setForeignTotal(reversed.getForeignTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, (Object)pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, (Object)reversed);
                this.srvWarehouseEntry.reverseDraw(pReqVars, pEntity);
                this.srvCogsEntry.reverseDraw(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
                this.getSrvOrm().deleteEntityWhere(pReqVars, SalesInvoiceGoodsTaxLine.class, "ITSOWNER=" + reversed.getItsId());
            } else {
                if (pEntity.getItsQuantity().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getReversedId() == null) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
                }
                if (pEntity.getItsPrice().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new ExceptionWithCode(1003, "price_less_eq_0::" + pReqVars.get("user"));
                }
                pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getInvItem())));
                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
                    if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                        exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                    }
                    pEntity.setItsPrice(pEntity.getForeignPrice().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getForeignTotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    }
                }
                this.utlInvLine.makeLine(pReqVars, pEntity, as, txRules);
                this.srvWarehouseEntry.withdrawal(pReqVars, pEntity, pEntity.getWarehouseSiteFo());
                this.srvCogsEntry.withdrawal(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            }
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.utlInvLine.makeTotals(pReqVars, pEntity, as, txRules);
            pReqVars.put("nextEntity", pEntity.getItsOwner());
            pReqVars.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pReqVars.get("user"));
    }

    public final UtlInvLine<RS, SalesInvoice, SalesInvoiceLine, SalesInvoiceTaxLine, SalesInvoiceGoodsTaxLine> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, SalesInvoice, SalesInvoiceLine, SalesInvoiceTaxLine, SalesInvoiceGoodsTaxLine> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<CogsEntry> getSrvCogsEntry() {
        return this.srvCogsEntry;
    }

    public final void setSrvCogsEntry(ISrvDrawItemEntry<CogsEntry> pSrvCogsEntry) {
        this.srvCogsEntry = pSrvCogsEntry;
    }
}

