/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.SalesReturn;
import org.beigesoft.accounting.persistable.SalesReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesReturnLine;
import org.beigesoft.accounting.persistable.SalesReturnTaxLine;
import org.beigesoft.accounting.persistable.TaxDestination;
import org.beigesoft.accounting.processor.UtlInvLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesReturnLineSave<RS>
implements IEntityProcessor<SalesReturnLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvAccSettings srvAccSettings;
    private UtlInvLine<RS, SalesReturn, SalesReturnLine, SalesReturnTaxLine, SalesReturnGoodsTaxLine> utlInvLine;

    public final SalesReturnLine process(Map<String, Object> pReqVars, SalesReturnLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            pEntity.setItsOwner((SalesReturn)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            TaxDestination txRules = this.utlInvLine.revealTaxRules(pReqVars, pEntity.getItsOwner(), as, as.getIsExtractSalesTaxFromSales());
            if (pEntity.getReversedId() != null) {
                SalesReturnLine reversed = (SalesReturnLine)this.getSrvOrm().retrieveEntityById(pReqVars, SalesReturnLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pReqVars.get("user"));
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
                }
                pEntity.setTheRest(BigDecimal.ZERO);
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSite(reversed.getWarehouseSite());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsCost(reversed.getItsCost());
                pEntity.setItsPrice(reversed.getItsPrice());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, (Object)pEntity);
                pEntity.setIsNew(false);
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, (Object)reversed);
                SalesReturnGoodsTaxLine pigtlt = new SalesReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                List tls = this.getSrvOrm().retrieveListForField(pReqVars, (Object)pigtlt, "itsOwner");
                for (SalesReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pReqVars, (Object)pigtl);
                }
            } else {
                if (pEntity.getItsQuantity().doubleValue() == 0.0) {
                    throw new ExceptionWithCode(1003, "quantity_is_0");
                }
                if (pEntity.getItsCost().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "cost_less_or_eq_zero" + pReqVars.get("user"));
                }
                if (pEntity.getForeignPrice().doubleValue() <= 0.0 && pEntity.getItsPrice().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "price_less_eq_0");
                }
                pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pReqVars, (Object)pEntity.getInvItem())));
                pEntity.setTheRest(pEntity.getItsQuantity());
                if (pEntity.getItsOwner().getForeignCurrency() != null) {
                    BigDecimal exchRate = pEntity.getItsOwner().getExchangeRate();
                    if (exchRate.compareTo(BigDecimal.ZERO) == -1) {
                        exchRate = BigDecimal.ONE.divide(exchRate.negate(), 15, RoundingMode.HALF_UP);
                    }
                    pEntity.setItsPrice(pEntity.getForeignPrice().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    if (txRules == null || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        pEntity.setItsTotal(pEntity.getForeignTotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    } else {
                        pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(exchRate).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
                    }
                }
                this.utlInvLine.makeLine(pReqVars, pEntity, as, txRules);
            }
            this.srvWarehouseEntry.load(pReqVars, pEntity, pEntity.getWarehouseSite());
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.utlInvLine.makeTotals(pReqVars, pEntity, as, txRules);
            pReqVars.put("nextEntity", pEntity.getItsOwner());
            pReqVars.put("nameOwnerEntity", SalesReturn.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "Attempt to update Sales Return line by " + pReqVars.get("user"));
    }

    public final UtlInvLine<RS, SalesReturn, SalesReturnLine, SalesReturnTaxLine, SalesReturnGoodsTaxLine> getUtlInvLine() {
        return this.utlInvLine;
    }

    public final void setUtlInvLine(UtlInvLine<RS, SalesReturn, SalesReturnLine, SalesReturnTaxLine, SalesReturnGoodsTaxLine> pUtlInvLine) {
        this.utlInvLine = pUtlInvLine;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

