/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.Wage;
import org.beigesoft.accounting.persistable.WageTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcWageTaxLineDelete<RS>
implements IEntityProcessor<WageTaxLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    public final WageTaxLine process(Map<String, Object> pAddParam, WageTaxLine pEntity, IRequestData pRequestData) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
        }
        pEntity.setItsOwner((Wage)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(Wage.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        if (pEntity.getItsOwner().getHasMadeAccEntries().booleanValue()) {
            throw new ExceptionWithCode(403, "attempt_to_change_accounted_document");
        }
        this.getSrvOrm().deleteEntity(pAddParam, (Object)pEntity);
        this.updateOwner(pAddParam, pEntity);
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", Wage.class.getSimpleName());
        return null;
    }

    public final void updateOwner(Map<String, Object> pAddParam, WageTaxLine pEntity) throws Exception {
        String query = "select sum(ITSTOTAL) as ITSTOTAL from WAGETAXLINE join TAX on TAX.ITSID = WAGETAXLINE.TAX where TAX.ITSTYPE=3 and ITSOWNER=" + pEntity.getItsOwner().getItsId();
        Double total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
        if (total == null) {
            total = 0.0;
        }
        pEntity.getItsOwner().setTotalTaxesEmployee(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        query = "select sum(ITSTOTAL) as ITSTOTAL from WAGETAXLINE join TAX on TAX.ITSID = WAGETAXLINE.TAX where TAX.ITSTYPE=4 and ITSOWNER=" + pEntity.getItsOwner().getItsId();
        total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
        if (total == null) {
            total = 0.0;
        }
        pEntity.getItsOwner().setTotalTaxesEmployer(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.getItsOwner().setNetWage(pEntity.getItsOwner().getItsTotal().subtract(pEntity.getItsOwner().getTotalTaxesEmployee()));
        this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

