/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.report.IBalanceSheetPdf;
import org.beigesoft.accounting.report.ISrvBalanceSheet;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.handler.IHndlFileReportReq;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvDate;

public class HndlBalancePdfReq<RS>
implements IHndlFileReportReq {
    private ISrvBalanceSheet srvBalanceSheet;
    private ISrvDate srvDate;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private IBalanceSheetPdf balanceSheetPdf;

    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData, OutputStream pSous) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED.intValue());
            this.srvDatabase.beginTransaction();
            Date date2 = this.srvDate.fromIso8601DateTimeNoTz(pRequestData.getParameter("date2"), null);
            BalanceSheet balanceSheet = this.getSrvBalanceSheet().retrieveBalance(pReqVars, date2);
            this.balanceSheetPdf.makeReport(pReqVars, balanceSheet, pSous);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvBalanceSheet getSrvBalanceSheet() {
        return this.srvBalanceSheet;
    }

    public final void setSrvBalanceSheet(ISrvBalanceSheet pSrvBalanceSheet) {
        this.srvBalanceSheet = pSrvBalanceSheet;
    }

    public final ISrvDate getSrvDate() {
        return this.srvDate;
    }

    public final void setSrvDate(ISrvDate pSrvDate) {
        this.srvDate = pSrvDate;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final IBalanceSheetPdf getBalanceSheetPdf() {
        return this.balanceSheetPdf;
    }

    public final void setBalanceSheetPdf(IBalanceSheetPdf pBalanceSheetPdf) {
        this.balanceSheetPdf = pBalanceSheetPdf;
    }
}

