/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.EWarehouseMovementType;
import org.beigesoft.accounting.persistable.IDocWarehouse;
import org.beigesoft.accounting.persistable.IDrawItemSource;
import org.beigesoft.accounting.persistable.IMakingWarehouseEntry;
import org.beigesoft.accounting.persistable.base.ADrawItemEntry;
import org.beigesoft.accounting.persistable.base.ADrawItemSourcesLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvTypeCode;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.orm.model.TableSql;
import org.beigesoft.orm.service.ASrvOrm;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;

public abstract class ASrvDrawItemEntry<T extends ADrawItemEntry, RS>
implements ISrvDrawItemEntry<T> {
    private ISrvI18n srvI18n;
    private ASrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private ISrvTypeCode srvTypeCode;
    private final Map<String, String> queries = new HashMap<String, String>();
    private IHolderForClassByName<Method> settersRapiHolder;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void withdrawal(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, Date pDateAccount, Long pDrawingOwnerId) throws Exception {
        BigDecimal quantityInSources;
        ArrayList<T> sources;
        block11: {
            if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
                throw new ExceptionWithCode(1003, "can_not_make_di_entry_for_foreign_src");
            }
            String queryMain = this.lazyGetQuery(this.srvAccSettings.lazyGetAccSettings(pAddParam).getCogsMethod().getFileName());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (ADrawItemSourcesLine drawItemSourceLine : this.getDrawItemSources(pAddParam)) {
                if (!drawItemSourceLine.getIsUsed().booleanValue()) continue;
                String query = this.lazyGetQuery(drawItemSourceLine.getFileName());
                query = query.replace(":IDDATABASEBIRTH", String.valueOf(this.getSrvOrm().getIdDatabase()));
                query = query.replace(":INVITEM", pEntity.getInvItem().getItsId().toString());
                query = query.replace(":UNITOFMEASURE", pEntity.getUnitOfMeasure().getItsId().toString());
                if (i++ > 0) {
                    sb.append("\nunion all\n\n");
                }
                sb.append(query);
            }
            String sourceAll = sb.toString();
            if (sourceAll.trim().length() == 0) {
                throw new ExceptionWithCode(1002, "there_is_no_draw_material_rules");
            }
            sources = new ArrayList<T>();
            queryMain = queryMain.replace(":SOURCEALL", sourceAll);
            quantityInSources = BigDecimal.ZERO;
            try (IRecordSet recordSet = null;){
                recordSet = this.getSrvDatabase().retrieveRecords(queryMain);
                if (!recordSet.moveToFirst()) break block11;
                do {
                    Long sourceId = recordSet.getLong("SOURCEID");
                    Integer sourceType = recordSet.getInteger("SOURCETYPE");
                    Long sourceOwnerId = recordSet.getLong("SOURCEOWNERID");
                    Integer sourceOwnerType = recordSet.getInteger("SOURCEOWNERTYPE");
                    BigDecimal theRest = BigDecimal.valueOf(recordSet.getDouble("THEREST"));
                    T source = this.createDrawItemEntry(pAddParam);
                    ((ADrawItemEntry)((Object)source)).setSourceId(sourceId);
                    ((ADrawItemEntry)((Object)source)).setSourceType(sourceType);
                    ((ADrawItemEntry)((Object)source)).setSourceOwnerId(sourceOwnerId);
                    ((ADrawItemEntry)((Object)source)).setSourceOwnerType(sourceOwnerType);
                    sources.add(source);
                    quantityInSources = quantityInSources.add(theRest);
                    if (quantityInSources.compareTo(pEntity.getItsQuantity()) < 0) continue;
                    break;
                } while (recordSet.moveToNext());
            }
        }
        if (quantityInSources.compareTo(pEntity.getItsQuantity()) < 0) {
            throw new ExceptionWithCode(1301, "there_is_no_goods_in_stock");
        }
        BigDecimal quantityToDrawRest = pEntity.getItsQuantity();
        for (ADrawItemEntry source : sources) {
            IFactorySimple fctDis = (IFactorySimple)this.entitiesFactoriesFatory.lazyGet(pAddParam, this.srvTypeCode.getTypeCodeMap().get(source.getSourceType()));
            IDrawItemSource drawed = (IDrawItemSource)fctDis.create(pAddParam);
            String fldIdName = ((TableSql)this.srvOrm.getTablesMap().get(drawed.getClass().getSimpleName())).getIdFieldName();
            Method setterId = (Method)this.settersRapiHolder.getFor(drawed.getClass(), fldIdName);
            setterId.invoke((Object)drawed, source.getSourceId());
            drawed = (IDrawItemSource)this.srvOrm.retrieveEntity(pAddParam, (Object)drawed);
            BigDecimal quantityToDraw = quantityToDrawRest.compareTo(drawed.getTheRest()) < 0 ? quantityToDrawRest : drawed.getTheRest();
            this.withdrawalFrom(pAddParam, pEntity, drawed, quantityToDraw);
            if ((quantityToDrawRest = quantityToDrawRest.subtract(quantityToDraw)).doubleValue() != 0.0) continue;
            break;
        }
    }

    @Override
    public final void withdrawalFrom(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, IDrawItemSource pSource, BigDecimal pQuantityToDraw) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_di_entry_for_foreign_src");
        }
        T die = this.createDrawItemEntry(pAddParam);
        ((ADrawItemEntry)((Object)die)).setItsDate(pEntity.getDocumentDate());
        die.setIdDatabaseBirth(Integer.valueOf(this.getSrvOrm().getIdDatabase()));
        ((ADrawItemEntry)((Object)die)).setSourceType(pSource.constTypeCode());
        ((ADrawItemEntry)((Object)die)).setSourceId((Long)pSource.getItsId());
        ((ADrawItemEntry)((Object)die)).setDrawingType(pEntity.constTypeCode());
        ((ADrawItemEntry)((Object)die)).setDrawingId((Long)pEntity.getItsId());
        ((ADrawItemEntry)((Object)die)).setDrawingOwnerId(pEntity.getOwnerId());
        ((ADrawItemEntry)((Object)die)).setDrawingOwnerType(pEntity.getOwnerType());
        ((ADrawItemEntry)((Object)die)).setSourceOwnerId(pSource.getOwnerId());
        ((ADrawItemEntry)((Object)die)).setSourceOwnerType(pSource.getOwnerType());
        ((ADrawItemEntry)((Object)die)).setItsQuantity(pQuantityToDraw);
        ((ADrawItemEntry)((Object)die)).setItsCost(pSource.getItsCost());
        ((ADrawItemEntry)((Object)die)).setInvItem(pEntity.getInvItem());
        ((ADrawItemEntry)((Object)die)).setUnitOfMeasure(pEntity.getUnitOfMeasure());
        ((ADrawItemEntry)((Object)die)).setItsTotal(pSource.getItsCost().multiply(((ADrawItemEntry)((Object)die)).getItsQuantity()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        ((ADrawItemEntry)((Object)die)).setDescription(this.makeDescription(pAddParam, pEntity, (ADrawItemEntry)((Object)die)));
        this.srvOrm.insertEntity(pAddParam, die);
        die.setIsNew(Boolean.valueOf(false));
        pSource.setTheRest(pSource.getTheRest().subtract(pQuantityToDraw));
        this.srvOrm.updateEntity(pAddParam, (Object)pSource);
    }

    @Override
    public final void reverseDraw(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, Date pDateAccount, Long pDrawingOwnerId) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_di_entry_for_foreign_src");
        }
        String tblNm = this.getDrawItemEntryClass().getSimpleName().toUpperCase();
        List diel = this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), " where DRAWINGTYPE=" + pEntity.constTypeCode() + " and " + tblNm + ".IDDATABASEBIRTH=" + this.getSrvOrm().getIdDatabase() + " and DRAWINGID=" + pEntity.getReversedId());
        BigDecimal quantityToLeaveRst = pEntity.getItsQuantity();
        String langDef = (String)pAddParam.get("langDef");
        for (ADrawItemEntry dies : diel) {
            if (dies.getItsQuantity().doubleValue() < 0.0) {
                throw new ExceptionWithCode(403, "Attempt to reverse reversed " + pAddParam.get("user"));
            }
            T die = this.createDrawItemEntry(pAddParam);
            ((ADrawItemEntry)((Object)die)).setItsDate(pDateAccount);
            die.setIdDatabaseBirth(Integer.valueOf(this.getSrvOrm().getIdDatabase()));
            ((ADrawItemEntry)((Object)die)).setSourceType(dies.getSourceType());
            ((ADrawItemEntry)((Object)die)).setSourceId(dies.getSourceId());
            ((ADrawItemEntry)((Object)die)).setDrawingType(pEntity.constTypeCode());
            ((ADrawItemEntry)((Object)die)).setDrawingId((Long)pEntity.getItsId());
            ((ADrawItemEntry)((Object)die)).setDrawingOwnerId(pDrawingOwnerId);
            ((ADrawItemEntry)((Object)die)).setDrawingOwnerType(pEntity.getOwnerType());
            ((ADrawItemEntry)((Object)die)).setSourceOwnerId(dies.getSourceOwnerId());
            ((ADrawItemEntry)((Object)die)).setSourceOwnerType(dies.getSourceOwnerType());
            ((ADrawItemEntry)((Object)die)).setItsCost(dies.getItsCost());
            ((ADrawItemEntry)((Object)die)).setItsTotal(dies.getItsTotal().negate());
            ((ADrawItemEntry)((Object)die)).setUnitOfMeasure(dies.getUnitOfMeasure());
            ((ADrawItemEntry)((Object)die)).setInvItem(dies.getInvItem());
            ((ADrawItemEntry)((Object)die)).setItsQuantity(dies.getItsQuantity().negate());
            quantityToLeaveRst = quantityToLeaveRst.add(dies.getItsQuantity());
            if (quantityToLeaveRst.doubleValue() > 0.0) {
                throw new ExceptionWithCode(1001, "Reversing source has different quantity against movement entries! " + pAddParam.get("user"));
            }
            ((ADrawItemEntry)((Object)die)).setReversedId(dies.getItsId());
            ((ADrawItemEntry)((Object)die)).setDescription(this.makeDescription(pAddParam, pEntity, dies) + " " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + dies.getItsId());
            this.getSrvOrm().insertEntity(pAddParam, die);
            die.setIsNew(Boolean.valueOf(false));
            IFactorySimple fctDis = (IFactorySimple)this.entitiesFactoriesFatory.lazyGet(pAddParam, this.srvTypeCode.getTypeCodeMap().get(dies.getSourceType()));
            IDrawItemSource drawed = (IDrawItemSource)fctDis.create(pAddParam);
            String fldIdName = ((TableSql)this.srvOrm.getTablesMap().get(drawed.getClass().getSimpleName())).getIdFieldName();
            Method setterId = (Method)this.settersRapiHolder.getFor(drawed.getClass(), fldIdName);
            setterId.invoke((Object)drawed, dies.getSourceId());
            drawed = (IDrawItemSource)this.srvOrm.retrieveEntity(pAddParam, (Object)drawed);
            drawed.setTheRest(drawed.getTheRest().add(dies.getItsQuantity()));
            this.srvOrm.updateEntity(pAddParam, (Object)drawed);
            dies.setReversedId(die.getItsId());
            dies.setDescription(dies.getDescription() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + this.getSrvOrm().getIdDatabase() + "-" + die.getItsId());
            this.getSrvOrm().updateEntity(pAddParam, (Object)dies);
        }
        if (quantityToLeaveRst.doubleValue() != 0.0) {
            throw new ExceptionWithCode(1001, "Reversing source has different quantity against movement entries! " + pAddParam.get("user"));
        }
    }

    @Override
    public final List<T> retrieveEntriesFor(Map<String, Object> pAddParam, IDocWarehouse pEntity) throws Exception {
        String where = null;
        Long docId = (Long)pEntity.getItsId();
        if (pEntity.getIdBirth() != null) {
            docId = pEntity.getIdBirth();
        }
        String tblNm = this.getDrawItemEntryClass().getSimpleName().toUpperCase();
        if (pEntity instanceof IDrawItemSource) {
            where = " where SOURCETYPE=" + pEntity.constTypeCode() + " and SOURCEID=" + docId + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getIdDatabaseBirth();
        } else if (pEntity instanceof IMakingWarehouseEntry) {
            where = " where DRAWINGTYPE=" + pEntity.constTypeCode() + " and DRAWINGID=" + docId + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getIdDatabaseBirth();
        }
        List result = null;
        if (where != null) {
            result = this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), where);
            where = null;
        }
        if (pEntity instanceof IDrawItemSource) {
            where = " where DRAWINGTYPE=" + pEntity.constTypeCode() + " and DRAWINGID=" + docId + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getIdDatabaseBirth();
        }
        if (where != null) {
            if (result == null) {
                result = this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), where);
            } else {
                result.addAll(this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), where));
            }
            where = null;
        }
        if (pEntity.getLinesWarehouseType() == EWarehouseMovementType.LOAD) {
            where = " where SOURCEOWNERTYPE=" + pEntity.constTypeCode() + " and SOURCEOWNERID=" + docId + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getIdDatabaseBirth();
        } else if (pEntity.getLinesWarehouseType() == EWarehouseMovementType.WITHDRAWAL) {
            where = " where DRAWINGOWNERTYPE=" + pEntity.constTypeCode() + " and DRAWINGOWNERID=" + docId + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getIdDatabaseBirth();
        }
        if (where != null) {
            if (result == null) {
                result = this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), where);
            } else {
                result.addAll(this.getSrvOrm().retrieveListWithConditions(pAddParam, this.getDrawItemEntryClass(), where));
            }
        }
        return result;
    }

    public abstract Class<T> getDrawItemEntryClass();

    public abstract T createDrawItemEntry(Map<String, Object> var1);

    public abstract List<? extends ADrawItemSourcesLine> getDrawItemSources(Map<String, Object> var1) throws Exception;

    public final String lazyGetQuery(String pFileName) throws Exception {
        if (this.queries.get(pFileName) == null) {
            String flName = "/accounting/trade/" + pFileName + ".sql";
            this.queries.put(pFileName, this.loadString(flName));
        }
        return this.queries.get(pFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = ASrvDrawItemEntry.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = ASrvDrawItemEntry.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String makeDescription(Map<String, Object> pAddParam, IMakingWarehouseEntry pEntity, ADrawItemEntry pSource) {
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        String strWho = this.getSrvI18n().getMsg(pEntity.getClass().getSimpleName() + "short", langDef) + " #" + this.getSrvOrm().getIdDatabase() + "-" + pEntity.getItsId();
        strWho = pEntity.getOwnerId() == null ? strWho + ", " + dateFormat.format(pEntity.getDocumentDate()) : strWho + " " + this.getSrvI18n().getMsg("in", langDef) + " " + this.getSrvI18n().getMsg(this.getSrvTypeCode().getTypeCodeMap().get(pEntity.getOwnerType()).getSimpleName() + "short", langDef) + " #" + this.getSrvOrm().getIdDatabase() + "-" + pEntity.getOwnerId() + ", " + dateFormat.format(pEntity.getDocumentDate());
        String strFrom = " " + this.getSrvI18n().getMsg("from", langDef) + " " + this.getSrvI18n().getMsg(this.getSrvTypeCode().getTypeCodeMap().get(pSource.getSourceType()).getSimpleName() + "short", langDef) + " #" + this.getSrvOrm().getIdDatabase() + "-" + pSource.getSourceId();
        return this.getSrvI18n().getMsg("made_at", langDef) + " " + dateFormat.format(new Date()) + " " + this.getSrvI18n().getMsg("by", langDef) + " " + strWho + strFrom;
    }

    public final ASrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ASrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvTypeCode getSrvTypeCode() {
        return this.srvTypeCode;
    }

    public final void setSrvTypeCode(ISrvTypeCode pSrvTypeCode) {
        this.srvTypeCode = pSrvTypeCode;
    }

    public final Map<String, String> getQueries() {
        return this.queries;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IHolderForClassByName<Method> getSettersRapiHolder() {
        return this.settersRapiHolder;
    }

    public final void setSettersRapiHolder(IHolderForClassByName<Method> pSettersRapiHolder) {
        this.settersRapiHolder = pSettersRapiHolder;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }
}

