/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.I18nAccounting;
import org.beigesoft.accounting.persistable.I18nCurrency;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.handler.IHandlerRequestDch;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class HndlAccVarsRequest<RS>
implements IHandlerRequestDch {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;
    private IHandlerRequestDch additionalI18nReqHndl;
    private List<I18nAccounting> i18nAccountingList;
    private List<I18nCurrency> i18nCurrencyList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        AccSettings as = this.srvAccSettings.lazyGetAccSettings(pReqVars);
        String curSign = as.getUseCurrencySign() != false ? as.getCurrency().getItsSign() : " " + as.getCurrency().getItsName() + " ";
        pReqVars.put("quantityDp", as.getQuantityPrecision());
        pReqVars.put("priceDp", as.getPricePrecision());
        pReqVars.put("costDp", as.getCostPrecision());
        pReqVars.put("taxDp", as.getTaxPrecision());
        pReqVars.put("reportDp", as.getBalancePrecision());
        pReqVars.put("curSign", curSign);
        pReqVars.put("accSet", (Object)as);
        String lang = (String)pReqVars.get("lang");
        String langDef = (String)pReqVars.get("langDef");
        if (lang != null && langDef != null && !lang.equals(langDef)) {
            List<I18nCurrency> i18nCurTmp;
            List<I18nAccounting> i18nAccTmp;
            Iterator<I18nCurrency> iterator = this;
            synchronized (iterator) {
                if (this.i18nAccountingList == null) {
                    try {
                        this.logger.info(null, HndlAccVarsRequest.class, "Refreshing I18N data...");
                        this.srvDatabase.setIsAutocommit(false);
                        this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED.intValue());
                        this.srvDatabase.beginTransaction();
                        List i18nac = this.srvOrm.retrieveList(pReqVars, I18nAccounting.class);
                        List i18ncur = this.srvOrm.retrieveList(pReqVars, I18nCurrency.class);
                        this.srvDatabase.commitTransaction();
                        this.i18nAccountingList = i18nac;
                        this.i18nCurrencyList = i18ncur;
                    }
                    catch (Exception ex) {
                        if (!this.srvDatabase.getIsAutocommit()) {
                            this.srvDatabase.rollBackTransaction();
                        }
                        throw ex;
                    }
                    finally {
                        this.srvDatabase.releaseResources();
                    }
                }
                i18nAccTmp = this.i18nAccountingList;
                i18nCurTmp = this.i18nCurrencyList;
            }
            for (I18nAccounting i18nAccounting : i18nAccTmp) {
                if (!i18nAccounting.getLang().getItsId().equals(lang)) continue;
                pReqVars.put("i18nAccounting", (Object)i18nAccounting);
                break;
            }
            for (I18nCurrency i18nCurrency : i18nCurTmp) {
                if (!i18nCurrency.getHasName().getItsId().equals(as.getCurrency().getItsId()) || !i18nCurrency.getLang().getItsId().equals(lang)) continue;
                pReqVars.put("i18nCurrency", (Object)i18nCurrency);
                break;
            }
        }
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handle(pReqVars, pRequestData);
        }
    }

    public final synchronized void handleDataChanged() throws Exception {
        this.i18nAccountingList = null;
        this.i18nCurrencyList = null;
        this.logger.info(null, HndlAccVarsRequest.class, "I18N changes are handled.");
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handleDataChanged();
        }
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final IHandlerRequestDch getAdditionalI18nReqHndl() {
        return this.additionalI18nReqHndl;
    }

    public final void setAdditionalI18nReqHndl(IHandlerRequestDch pAdditionalI18nReqHndl) {
        this.additionalI18nReqHndl = pAdditionalI18nReqHndl;
    }
}

