/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccEntriesSourcesLine;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.CogsItemSourcesLine;
import org.beigesoft.accounting.persistable.DrawMaterialSourcesLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.service.ISrvOrm;

public class SrvAccSettings<RS>
implements ISrvAccSettings {
    private AccSettings accSettings;
    private final Class<AccSettings> entityClass = AccSettings.class;
    private ISrvOrm<RS> srvOrm;

    public SrvAccSettings() {
    }

    public SrvAccSettings(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    @Override
    public final synchronized AccSettings lazyGetAccSettings(Map<String, Object> pAddParam) throws Exception {
        if (this.accSettings == null) {
            this.retrieveAccSettings(pAddParam);
        }
        return this.accSettings;
    }

    @Override
    public final synchronized void clearAccSettings(Map<String, Object> pAddParam) {
        this.accSettings = null;
    }

    @Override
    public final synchronized void saveAccSettings(Map<String, Object> pAddParam, AccSettings pEntity) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            throw new ExceptionWithCode(403, "Attempt to insert accounting settings by " + pAddParam.get("user"));
        }
        if (pEntity.getCostPrecision() < 0 || pEntity.getCostPrecision() > 4) {
            throw new ExceptionWithCode(1003, "precision_must_be_from_0_to_4");
        }
        if (pEntity.getPricePrecision() < 0 || pEntity.getPricePrecision() > 4) {
            throw new ExceptionWithCode(1003, "precision_must_be_from_0_to_4");
        }
        if (pEntity.getQuantityPrecision() < 0 || pEntity.getQuantityPrecision() > 4) {
            throw new ExceptionWithCode(1003, "precision_must_be_from_0_to_4");
        }
        if (pEntity.getBalancePrecision() < 0 || pEntity.getBalancePrecision() > 4) {
            throw new ExceptionWithCode(1003, "precision_must_be_from_0_to_4");
        }
        this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity);
        this.retrieveAccSettings(pAddParam);
    }

    public final synchronized void retrieveAccSettings(Map<String, Object> pAddParam) throws Exception {
        this.accSettings = new AccSettings();
        this.accSettings.setItsId(1L);
        this.accSettings = (AccSettings)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)this.accSettings));
        if (this.accSettings == null) {
            throw new ExceptionWithCode(1002, "There is no accounting settings!!!");
        }
        DrawMaterialSourcesLine dmsl = new DrawMaterialSourcesLine();
        dmsl.setItsOwner(this.accSettings);
        List drawMaterialSources = this.getSrvOrm().retrieveListForField(pAddParam, (Object)dmsl, "itsOwner");
        this.accSettings.setDrawMaterialSources(drawMaterialSources);
        CogsItemSourcesLine cisl = new CogsItemSourcesLine();
        cisl.setItsOwner(this.accSettings);
        List cogsItemSources = this.getSrvOrm().retrieveListForField(pAddParam, (Object)cisl, "itsOwner");
        this.accSettings.setCogsItemSources(cogsItemSources);
        AccEntriesSourcesLine aesl = new AccEntriesSourcesLine();
        aesl.setItsOwner(this.accSettings);
        List accEntriesSources = this.getSrvOrm().retrieveListForField(pAddParam, (Object)aesl, "itsOwner");
        this.accSettings.setAccEntriesSources(accEntriesSources);
    }

    public final Class<AccSettings> getEntityClass() {
        return this.entityClass;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

