/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.filter;

import java.util.Date;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.delegate.IDelegator;
import org.beigesoft.delegate.IDelegatorEval;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.handler.IHandlerModelChanged;
import org.beigesoft.replicator.filter.IFilterEntities;
import org.beigesoft.replicator.persistable.ReplExcludeAccountsCredit;
import org.beigesoft.replicator.persistable.ReplExcludeAccountsDebit;
import org.beigesoft.replicator.persistable.ReplicationAccMethod;
import org.beigesoft.service.ISrvOrm;

public class FilterAvoidAccDebtCredit<RS>
implements IFilterEntities,
IHandlerModelChanged<ReplicationAccMethod>,
IDelegatorEval<Date>,
IDelegator {
    private ISrvOrm<RS> srvOrm;
    private IFilterEntities filterId;
    private ReplicationAccMethod replicationMethod;

    public final String makeFilter(Class<?> pEntityClass, Map<String, Object> pAddParam) throws Exception {
        boolean isFirst;
        if (!AccountingEntry.class.isAssignableFrom(pEntityClass)) {
            throw new ExceptionWithCode(1002, "This class not descendant of AccountingEntry: " + pEntityClass);
        }
        this.lazyEvalReplicationMethod(pAddParam);
        StringBuffer filterAvoidAccDbCr = new StringBuffer("");
        if (this.replicationMethod.getExcludeDebitAccounts().size() > 0) {
            filterAvoidAccDbCr.append(" and ((ACCDEBIT is null or ACCDEBIT not in (");
            isFirst = true;
            for (ReplExcludeAccountsDebit repExclAccDb : this.replicationMethod.getExcludeDebitAccounts()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    filterAvoidAccDbCr.append(",");
                }
                filterAvoidAccDbCr.append("'" + repExclAccDb.getAccount().getItsId() + "'");
            }
        }
        if (this.replicationMethod.getExcludeCreditAccounts().size() > 0) {
            if (this.replicationMethod.getExcludeDebitAccounts().size() > 0) {
                filterAvoidAccDbCr.append(")) and (ACCCREDIT is null or ACCCREDIT not in (");
            } else {
                filterAvoidAccDbCr.append(" and (ACCCREDIT is null or ACCCREDIT not in (");
            }
            isFirst = true;
            for (ReplExcludeAccountsCredit repExclAccCr : this.replicationMethod.getExcludeCreditAccounts()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    filterAvoidAccDbCr.append(",");
                }
                filterAvoidAccDbCr.append("'" + repExclAccCr.getAccount().getItsId() + "'");
            }
        }
        if (this.replicationMethod.getExcludeDebitAccounts().size() > 0 && this.replicationMethod.getExcludeCreditAccounts().size() > 0) {
            filterAvoidAccDbCr.append(")))");
        } else if (this.replicationMethod.getExcludeDebitAccounts().size() > 0 || this.replicationMethod.getExcludeCreditAccounts().size() > 0) {
            filterAvoidAccDbCr.append("))");
        }
        if (this.replicationMethod.getExcludeDebitAccounts().size() > 0 || this.replicationMethod.getExcludeCreditAccounts().size() > 0) {
            return "(" + this.filterId.makeFilter(pEntityClass, pAddParam) + filterAvoidAccDbCr.toString() + ")";
        }
        return this.filterId.makeFilter(pEntityClass, pAddParam);
    }

    public final void handleModelChanged(ReplicationAccMethod pModel) {
        if (this.replicationMethod != null && this.replicationMethod.getItsId().equals(pModel.getItsId())) {
            this.replicationMethod = null;
        }
    }

    public final Date evalData(Map<String, Object> pAddParam) throws Exception {
        this.lazyEvalReplicationMethod(pAddParam);
        if (this.replicationMethod.getLastDateReplication() == null) {
            return new Date(1L);
        }
        return this.replicationMethod.getLastDateReplication();
    }

    public final void make(Map<String, Object> pAddParam) throws Exception {
        this.replicationMethod.setLastDateReplication(new Date());
        this.getSrvOrm().updateEntity(pAddParam, (Object)this.replicationMethod);
    }

    public final void lazyEvalReplicationMethod(Map<String, Object> pAddParam) throws Exception {
        Long replicationMethodId;
        try {
            replicationMethodId = Long.parseLong(pAddParam.get("replicationMethodId").toString());
        }
        catch (Exception e) {
            throw new ExceptionWithCode(1003, "Wrong or missing parameter replicationMethodId (in pAddParam): " + pAddParam.get("replicationMethodId"));
        }
        if (this.replicationMethod == null || !this.replicationMethod.getItsId().equals(replicationMethodId)) {
            this.replicationMethod = new ReplicationAccMethod();
            this.replicationMethod.setItsId(replicationMethodId);
            this.replicationMethod = (ReplicationAccMethod)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)this.replicationMethod));
            ReplExcludeAccountsDebit ead = new ReplExcludeAccountsDebit();
            ead.setItsOwner(this.replicationMethod);
            this.replicationMethod.setExcludeDebitAccounts(this.getSrvOrm().retrieveListForField(pAddParam, (Object)ead, "itsOwner"));
            ReplExcludeAccountsCredit eac = new ReplExcludeAccountsCredit();
            eac.setItsOwner(this.replicationMethod);
            this.replicationMethod.setExcludeCreditAccounts(this.getSrvOrm().retrieveListForField(pAddParam, (Object)eac, "itsOwner"));
        }
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IFilterEntities getFilterId() {
        return this.filterId;
    }

    public final void setFilterId(IFilterEntities pFilterId) {
        this.filterId = pFilterId;
    }

    public final ReplicationAccMethod getReplicationAccMethod() {
        return this.replicationMethod;
    }

    public final void setReplicationAccMethod(ReplicationAccMethod pReplicationAccMethod) {
        this.replicationMethod = pReplicationAccMethod;
    }
}

