select TAXCATEGORY as TAXCATID, INVITEMTAXCATEGORYLINE.TAX as TAXID, TAX.ITSNAME as TAXNAME, INVITEMTAXCATEGORYLINE.ITSPERCENTAGE as ITSPERCENTAGE, sum(SUBTOTAL) as SUBTOTAL, sum(FOREIGNSUBTOTAL) as FOREIGNSUBTOTAL, sum(TXTOT) as TXTOT, sum(TXTOTFC) as TXTOTFC, sum(ITSTOTAL) as ITSTOTAL, sum(FOREIGNTOTAL) as FOREIGNTOTAL
from
( select PURCHASEINVOICELINE.TAXCATEGORY, PURCHASERETURNLINE.SUBTOTAL, PURCHASERETURNLINE.FOREIGNSUBTOTAL, PURCHASERETURNLINE.ITSTOTAL, PURCHASERETURNLINE.FOREIGNTOTAL
  from PURCHASERETURNLINE
  join PURCHASEINVOICELINE on PURCHASEINVOICELINE.ITSID=PURCHASERETURNLINE.PURCHASEINVOICELINE
  where PURCHASEINVOICELINE.TAXCATEGORY is not null and PURCHASERETURNLINE.REVERSEDID is null and PURCHASERETURNLINE.ITSOWNER=:INVOICEID
) as ALL_LINES
join INVITEMTAXCATEGORY on INVITEMTAXCATEGORY.ITSID=ALL_LINES.TAXCATEGORY
join INVITEMTAXCATEGORYLINE on INVITEMTAXCATEGORYLINE.ITSOWNER=INVITEMTAXCATEGORY.ITSID
join TAX on INVITEMTAXCATEGORYLINE.TAX=TAX.ITSID
join (
select TAX, ITSTOTAL as TXTOT, FOREIGNTOTALTAXES as TXTOTFC from PURCHASERETURNTAXLINE where ITSOWNER=:INVOICEID
) as INVTLNS on INVITEMTAXCATEGORYLINE.TAX=INVTLNS.TAX
group by TAXCATID, TAXID, TAXNAME, INVITEMTAXCATEGORYLINE.ITSPERCENTAGE
order by TAXID;
