select ILID, TAXCATEGORY as TAXCATID, TAX as TAXID, TAX.ITSNAME as TAXNAME, INVITEMTAXCATEGORYLINE.ITSPERCENTAGE as ITSPERCENTAGE, sum(TOTALTAXES) as TOTALTAXES, sum(FOREIGNTOTALTAXES) as FOREIGNTOTALTAXES
from
(
  select ITSID as ILID, PURCHASEINVOICELINE.TAXCATEGORY, PURCHASERETURNLINE.TOTALTAXES, PURCHASERETURNLINE.FOREIGNTOTALTAXES
  from PURCHASERETURNLINE
  join PURCHASEINVOICELINE on PURCHASEINVOICELINE.ITSID=PURCHASERETURNLINE.PURCHASEINVOICELINE
  where PURCHASEINVOICELINE.TAXCATEGORY is not null and PURCHASERETURNLINE.REVERSEDID is null and PURCHASERETURNLINE.ITSOWNER=:INVOICEID
) as ALL_LINES
join INVITEMTAXCATEGORY on INVITEMTAXCATEGORY.ITSID=TAXCATEGORY
join INVITEMTAXCATEGORYLINE on INVITEMTAXCATEGORYLINE.ITSOWNER=INVITEMTAXCATEGORY.ITSID
join TAX on INVITEMTAXCATEGORYLINE.TAX=TAX.ITSID
group by ILID, TAXCATID, TAXID, TAXNAME, INVITEMTAXCATEGORYLINE.ITSPERCENTAGE;
