/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JDTCompiler
extends Compiler {
    private final Log log = LogFactory.getLog(JDTCompiler.class);

    @Override
    protected void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        String opt;
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        final String sourceFile = this.ctxt.getServletJavaFileName();
        final String outputDir = this.ctxt.getOptions().getScratchDir().getAbsolutePath();
        String packageName = this.ctxt.getServletPackageName();
        final String targetClassName = (packageName.length() != 0 ? packageName + "." : "") + this.ctxt.getServletClassName();
        final ClassLoader classLoader = this.ctxt.getJspLoader();
        String[] fileNames = new String[]{sourceFile};
        String[] classNames = new String[]{targetClassName};
        final ArrayList problemList = new ArrayList();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result.append(sep);
                    result.append(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(sep);
                    result.append(packageName[i]);
                    sep = ".";
                }
                result.append(sep);
                result.append(typeName);
                return this.findType(result.toString());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NameEnvironmentAnswer findType(String className) {
                block23: {
                    NameEnvironmentAnswer nameEnvironmentAnswer;
                    InputStream is = null;
                    try {
                        int count;
                        if (className.equals(targetClassName)) {
                            class CompilationUnit
                            implements ICompilationUnit {
                                private final String className;
                                private final String sourceFile;

                                CompilationUnit(String sourceFile, String className) {
                                    this.className = className;
                                    this.sourceFile = sourceFile;
                                }

                                public char[] getFileName() {
                                    return this.sourceFile.toCharArray();
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public char[] getContents() {
                                    char[] result = null;
                                    FileInputStream is = null;
                                    InputStreamReader isr = null;
                                    Reader reader = null;
                                    try {
                                        int count;
                                        is = new FileInputStream(this.sourceFile);
                                        isr = new InputStreamReader((InputStream)is, JDTCompiler.this.ctxt.getOptions().getJavaEncoding());
                                        reader = new BufferedReader(isr);
                                        char[] chars = new char[8192];
                                        StringBuilder buf = new StringBuilder();
                                        while ((count = reader.read(chars, 0, chars.length)) > 0) {
                                            buf.append(chars, 0, count);
                                        }
                                        result = new char[buf.length()];
                                        buf.getChars(0, result.length, result, 0);
                                    }
                                    catch (IOException e) {
                                        JDTCompiler.this.log.error("Compilation error", e);
                                    }
                                    finally {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (isr != null) {
                                            try {
                                                isr.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                    return result;
                                }

                                public char[] getMainTypeName() {
                                    int dot = this.className.lastIndexOf(46);
                                    if (dot > 0) {
                                        return this.className.substring(dot + 1).toCharArray();
                                    }
                                    return this.className.toCharArray();
                                }

                                public char[][] getPackageName() {
                                    StringTokenizer izer = new StringTokenizer(this.className, ".");
                                    char[][] result = new char[izer.countTokens() - 1][];
                                    for (int i = 0; i < result.length; ++i) {
                                        String tok = izer.nextToken();
                                        result[i] = tok.toCharArray();
                                    }
                                    return result;
                                }

                                public boolean ignoreOptionalProblems() {
                                    return false;
                                }
                            }
                            CompilationUnit compilationUnit = new CompilationUnit(sourceFile, className);
                            NameEnvironmentAnswer nameEnvironmentAnswer2 = new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                            return nameEnvironmentAnswer2;
                        }
                        String resourceName = className.replace('.', '/') + ".class";
                        is = classLoader.getResourceAsStream(resourceName);
                        if (is == null) break block23;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    catch (IOException exc) {
                        JDTCompiler.this.log.error("Compilation error", exc);
                        break block23;
                    }
                    catch (ClassFormatException exc) {
                        JDTCompiler.this.log.error("Compilation error", exc);
                        break block23;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException exc) {}
                        }
                    }
                    return nameEnvironmentAnswer;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = null;
                try {
                    is = classLoader.getResourceAsStream(resourceName);
                    boolean bl = is == null;
                    return bl;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder result = new StringBuilder();
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result.append(sep);
                        result.append(parentPackageName[i]);
                        sep = ".";
                    }
                }
                if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                    return false;
                }
                result.append(sep);
                result.append(packageName);
                return this.isPackage(result.toString());
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (this.ctxt.getOptions().getJavaEncoding() != null) {
            settings.put("org.eclipse.jdt.core.encoding", this.ctxt.getOptions().getJavaEncoding());
        }
        if (this.ctxt.getOptions().getClassDebugInfo()) {
            settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
        if (this.ctxt.getOptions().getCompilerSourceVM() != null) {
            opt = this.ctxt.getOptions().getCompilerSourceVM();
            if (opt.equals("1.1")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.1");
            } else if (opt.equals("1.2")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.2");
            } else if (opt.equals("1.3")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.3");
            } else if (opt.equals("1.4")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
            } else if (opt.equals("1.5")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
            } else if (opt.equals("1.6")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
            } else if (opt.equals("1.7")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.7");
            } else if (opt.equals("1.8")) {
                settings.put("org.eclipse.jdt.core.compiler.source", "1.8");
            } else {
                this.log.warn("Unknown source VM " + opt + " ignored.");
                settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
            }
        } else {
            settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
        }
        if (this.ctxt.getOptions().getCompilerTargetVM() != null) {
            opt = this.ctxt.getOptions().getCompilerTargetVM();
            if (opt.equals("1.1")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (opt.equals("1.2")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            } else if (opt.equals("1.3")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
            } else if (opt.equals("1.4")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            } else if (opt.equals("1.5")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            } else if (opt.equals("1.6")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            } else if (opt.equals("1.7")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
            } else if (opt.equals("1.8")) {
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
                settings.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
            } else {
                this.log.warn("Unknown target VM " + opt + " ignored.");
                settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            }
        } else {
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            settings.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acceptResult(CompilationResult result) {
                block17: {
                    try {
                        int i;
                        if (result.hasProblems()) {
                            CategorizedProblem[] problems = result.getProblems();
                            for (i = 0; i < problems.length; ++i) {
                                CategorizedProblem problem = problems[i];
                                if (!problem.isError()) continue;
                                String name = new String(problems[i].getOriginatingFileName());
                                try {
                                    problemList.add(ErrorDispatcher.createJavacError(name, JDTCompiler.this.pageNodes, new StringBuilder(problem.getMessage()), problem.getSourceLineNumber(), JDTCompiler.this.ctxt));
                                    continue;
                                }
                                catch (JasperException e) {
                                    JDTCompiler.this.log.error("Error visiting node", e);
                                }
                            }
                        }
                        if (!problemList.isEmpty()) break block17;
                        ClassFile[] classFiles = result.getClassFiles();
                        for (i = 0; i < classFiles.length; ++i) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            StringBuilder classFileName = new StringBuilder(outputDir).append('/');
                            for (int j = 0; j < compoundName.length; ++j) {
                                if (j > 0) {
                                    classFileName.append('/');
                                }
                                classFileName.append(compoundName[j]);
                            }
                            byte[] bytes = classFile.getBytes();
                            classFileName.append(".class");
                            FileOutputStream fout = null;
                            FilterOutputStream bos = null;
                            try {
                                fout = new FileOutputStream(classFileName.toString());
                                bos = new BufferedOutputStream(fout);
                                bos.write(bytes);
                                continue;
                            }
                            finally {
                                if (bos != null) {
                                    try {
                                        bos.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    }
                    catch (IOException exc) {
                        JDTCompiler.this.log.error("Compilation error", exc);
                    }
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        for (int i = 0; i < compilationUnits.length; ++i) {
            String className = classNames[i];
            compilationUnits[i] = new CompilationUnit(fileNames[i], className);
        }
        CompilerOptions cOptions = new CompilerOptions(settings);
        cOptions.parseLiteralExpressionsAsConstants = true;
        org.eclipse.jdt.internal.compiler.Compiler compiler = new org.eclipse.jdt.internal.compiler.Compiler(env, policy, cOptions, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(this.ctxt.getServletJavaFileName());
            javaFile.delete();
        }
        if (!problemList.isEmpty()) {
            JavacErrorDetail[] jeds = problemList.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(jeds);
        }
        if (this.log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            this.log.debug("Compiled " + this.ctxt.getServletJavaFileName() + " " + (t2 - t1) + "ms");
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
    }
}

