/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.IDoc;
import org.beigesoft.accounting.service.ISrvAccEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public abstract class APrcAccDocSave<RS, T extends IDoc>
implements IEntityProcessor<T, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvI18n srvI18n;
    private ISrvAccEntry srvAccEntry;
    private ISrvAccSettings srvAccSettings;

    @Override
    public final T process(Map<String, Object> pAddParam, T pEntity, IRequestData pRequestData) throws Exception {
        Class<?> entityClass = pEntity.getClass();
        boolean isNew = pEntity.getIsNew();
        this.makeFirstPrepareForSave(pAddParam, pEntity, pRequestData);
        String actionAdd = pRequestData.getParameter("actionAdd");
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getReversedId() != null && pEntity.getItsTotal().doubleValue() >= 0.0) {
                throw new ExceptionWithCode(1003, "Reversed Total must be less than 0! " + pAddParam.get("user"));
            }
            if (pEntity.getReversedId() == null && pEntity.getItsTotal().doubleValue() < 0.0) {
                throw new ExceptionWithCode(1003, "Total must be less than 0 only in reversal! " + pAddParam.get("user"));
            }
            String langDef = (String)pAddParam.get("langDef");
            if (pEntity.getReversedId() != null) {
                String descr = pEntity.getDescription() == null ? "" : pEntity.getDescription();
                pEntity.setDescription(descr + " " + this.getSrvI18n().getMsg("reversed_n", langDef) + pEntity.getReversedIdDatabaseBirth() + "-" + pEntity.getReversedId());
            }
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
            if (pEntity.getReversedId() != null) {
                IDoc reversed;
                if (pEntity.getIdDatabaseBirth().equals(pEntity.getReversedIdDatabaseBirth())) {
                    reversed = (IDoc)this.getSrvOrm().retrieveEntityById(pAddParam, entityClass, pEntity.getReversedId());
                } else {
                    String tblNm = entityClass.getSimpleName().toUpperCase();
                    String whereStr = " where " + tblNm + ".IDBIRTH=" + pEntity.getReversedId() + " and " + tblNm + ".IDDATABASEBIRTH=" + pEntity.getReversedIdDatabaseBirth();
                    reversed = (IDoc)this.getSrvOrm().retrieveEntityWithConditions(pAddParam, entityClass, whereStr);
                }
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse! " + pAddParam.get("user"));
                }
                String oldDesr = "";
                if (reversed.getDescription() != null) {
                    oldDesr = reversed.getDescription();
                }
                reversed.setDescription(oldDesr + " " + this.getSrvI18n().getMsg("reversing_n", langDef) + pEntity.getIdDatabaseBirth() + "-" + pEntity.getItsId());
                reversed.setReversedId((Long)pEntity.getItsId());
                reversed.setReversedIdDatabaseBirth(pEntity.getIdDatabaseBirth());
                this.getSrvOrm().updateEntity(pAddParam, reversed);
                this.srvAccEntry.reverseEntries(pAddParam, (IDoc)pEntity, reversed);
            }
        } else {
            if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
                throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
            }
            IDoc oldEntity = (IDoc)this.getSrvOrm().retrieveEntityById(pAddParam, entityClass, pEntity.getItsId());
            if (oldEntity.getHasMadeAccEntries().booleanValue()) {
                throw new ExceptionWithCode(403, "Attempt to update accounted document by " + pAddParam.get("user"));
            }
            this.checkOtherFraudUpdate(pAddParam, pEntity, pRequestData, oldEntity);
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
        }
        if (!pEntity.getHasMadeAccEntries().booleanValue() && "makeAccEntries".equals(actionAdd)) {
            if (pEntity.getItsTotal().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
            }
            this.addCheckIsReadyToAccount(pAddParam, pEntity, pRequestData);
            this.srvAccEntry.makeEntries(pAddParam, (IDoc)pEntity);
        }
        this.makeOtherEntries(pAddParam, pEntity, pRequestData, isNew);
        return pEntity;
    }

    public abstract void makeFirstPrepareForSave(Map<String, Object> var1, T var2, IRequestData var3) throws Exception;

    public abstract void makeOtherEntries(Map<String, Object> var1, T var2, IRequestData var3, boolean var4) throws Exception;

    public abstract void checkOtherFraudUpdate(Map<String, Object> var1, T var2, IRequestData var3, T var4) throws Exception;

    public abstract void addCheckIsReadyToAccount(Map<String, Object> var1, T var2, IRequestData var3) throws Exception;

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvAccEntry getSrvAccEntry() {
        return this.srvAccEntry;
    }

    public final void setSrvAccEntry(ISrvAccEntry pSrvAccEntry) {
        this.srvAccEntry = pSrvAccEntry;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

