/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.ManufactureForDraw;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.Manufacture;
import org.beigesoft.accounting.persistable.ManufacturingProcess;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.processor.APrcAccDocUseMaterialSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcManufactureSave<RS>
extends APrcAccDocUseMaterialSave<RS, Manufacture> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, Manufacture pEntity, IRequestData pRequestData) throws Exception {
        pEntity.setManufacturingProcess(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getManufacturingProcess()));
        pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getInvItem()));
        if (!InvItem.FINISHED_PRODUCT_ID.equals(pEntity.getInvItem().getItsType().getItsId()) && !InvItem.MATERIAL_ID.equals(pEntity.getInvItem().getItsType().getItsId())) {
            throw new ExceptionWithCode(1003, "type_must_be_product_material");
        }
        if (pEntity.getItsQuantity().compareTo(pEntity.getManufacturingProcess().getItsQuantity()) > 0) {
            throw new ExceptionWithCode(1003, "source_has_no_enough_item");
        }
        if (!pEntity.getUnitOfMeasure().getItsId().equals(pEntity.getManufacturingProcess().getUnitOfMeasure().getItsId())) {
            throw new ExceptionWithCode(1003, "UnitOfMeasure_fiffer_with_source");
        }
        if (pEntity.getItsQuantity().doubleValue() < 0.0 && pEntity.getReversedId() == null) {
            throw new ExceptionWithCode(1003, "reversed_manufacture_is_null");
        }
        pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        if (pEntity.getReversedId() != null) {
            Manufacture reversed = this.getSrvOrm().retrieveEntityById(pAddParam, Manufacture.class, pEntity.getReversedId());
            if (reversed.getReversedId() != null) {
                throw new ExceptionWithCode(403, "Attempt to double reverse" + pAddParam.get("user"));
            }
            if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
            }
            reversed.setTheRest(BigDecimal.ZERO);
            this.getSrvOrm().updateEntity(pAddParam, reversed);
            pEntity.setTheRest(BigDecimal.ZERO);
        } else {
            pEntity.setTheRest(pEntity.getItsQuantity());
        }
        pEntity.setItsCost(pEntity.getManufacturingProcess().getItsCost());
        pEntity.setItsTotal(pEntity.getItsCost().multiply(pEntity.getItsQuantity()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, Manufacture pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        ManufactureForDraw manufactureForDraw = new ManufactureForDraw(pEntity);
        if (pEntity.getReversedId() != null) {
            this.getSrvWarehouseEntry().reverseDraw(pAddParam, manufactureForDraw);
            this.useMaterialReverse(pAddParam, pEntity);
        } else {
            this.getSrvWarehouseEntry().withdrawal(pAddParam, manufactureForDraw, pEntity.getWarehouseSiteFo());
            this.useMaterial(pAddParam, pEntity);
            this.getSrvAccEntry().makeEntries(pAddParam, pEntity);
        }
        this.getSrvWarehouseEntry().load(pAddParam, pEntity, pEntity.getWarehouseSite());
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, Manufacture pEntity, IRequestData pRequestData, Manufacture pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, Manufacture pEntity, IRequestData pRequestData) throws Exception {
    }

    public final String makeDescription(Manufacture pEntity, String pLangDef, DateFormat pDateFormat) {
        String strWho = this.getSrvI18n().getMsg(pEntity.getClass().getSimpleName() + "short", pLangDef) + " #" + pEntity.getIdDatabaseBirth() + "-" + pEntity.getItsId() + ", " + pDateFormat.format(pEntity.getItsDate());
        String strFrom = " " + this.getSrvI18n().getMsg("from", pLangDef) + " " + this.getSrvI18n().getMsg(ManufacturingProcess.class.getSimpleName() + "short", pLangDef) + " #" + pEntity.getManufacturingProcess().getIdDatabaseBirth() + "-" + pEntity.getManufacturingProcess().getItsId();
        return this.getSrvI18n().getMsg("made_at", pLangDef) + " " + pDateFormat.format(new Date()) + " " + this.getSrvI18n().getMsg("by", pLangDef) + " " + strWho + strFrom;
    }

    public final void useMaterial(Map<String, Object> pAddParam, Manufacture pEntity) throws Exception {
        pEntity.getManufacturingProcess().setTheRest(pEntity.getManufacturingProcess().getTheRest().subtract(pEntity.getItsQuantity()));
        this.getSrvOrm().updateEntity(pAddParam, pEntity.getManufacturingProcess());
        UseMaterialEntry die = new UseMaterialEntry();
        die.setItsDate(pEntity.getItsDate());
        die.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
        die.setSourceType(pEntity.getManufacturingProcess().constTypeCode());
        die.setSourceId(pEntity.getManufacturingProcess().getItsId());
        die.setDrawingType(pEntity.constTypeCode());
        die.setDrawingId(pEntity.getItsId());
        die.setDrawingOwnerId(null);
        die.setDrawingOwnerType(null);
        die.setSourceOwnerId(null);
        die.setSourceOwnerType(null);
        die.setItsQuantity(pEntity.getItsQuantity());
        die.setItsCost(pEntity.getManufacturingProcess().getItsCost());
        die.setInvItem(pEntity.getManufacturingProcess().getInvItem());
        die.setUnitOfMeasure(pEntity.getManufacturingProcess().getUnitOfMeasure());
        die.setItsTotal(die.getItsCost().multiply(die.getItsQuantity()));
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        die.setDescription(this.makeDescription(pEntity, langDef, dateFormat));
        this.getSrvOrm().insertEntity(pAddParam, die);
        die.setIsNew(false);
    }

    public final void useMaterialReverse(Map<String, Object> pAddParam, Manufacture pEntity) throws Exception {
        UseMaterialEntry dies = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, UseMaterialEntry.class, " where DRAWINGTYPE=" + pEntity.constTypeCode() + " and DRAWINGID=" + pEntity.getReversedId());
        UseMaterialEntry die = new UseMaterialEntry();
        die.setItsDate(pEntity.getItsDate());
        die.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
        die.setSourceType(dies.getSourceType());
        die.setSourceId(dies.getSourceId());
        die.setDrawingType(pEntity.constTypeCode());
        die.setDrawingId(pEntity.getItsId());
        die.setDrawingOwnerId(null);
        die.setDrawingOwnerType(null);
        die.setSourceOwnerId(dies.getSourceOwnerId());
        die.setSourceOwnerType(dies.getSourceOwnerType());
        die.setItsCost(dies.getItsCost());
        die.setItsTotal(dies.getItsTotal().negate());
        die.setUnitOfMeasure(dies.getUnitOfMeasure());
        die.setInvItem(dies.getInvItem());
        die.setItsQuantity(dies.getItsQuantity().negate());
        die.setReversedId(die.getItsId());
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        die.setDescription(this.makeDescription(pEntity, langDef, dateFormat) + " " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + dies.getIdDatabaseBirth() + "-" + dies.getItsId());
        this.getSrvOrm().insertEntity(pAddParam, die);
        die.setIsNew(false);
        pEntity.getManufacturingProcess().setTheRest(pEntity.getManufacturingProcess().getTheRest().add(dies.getItsQuantity()));
        this.getSrvOrm().updateEntity(pAddParam, pEntity.getManufacturingProcess());
        dies.setReversedId(die.getItsId());
        dies.setDescription(dies.getDescription() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + die.getIdDatabaseBirth() + "-" + die.getItsId());
        this.getSrvOrm().updateEntity(pAddParam, dies);
    }
}

