/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceTaxLine;
import org.beigesoft.accounting.processor.UtlPurchaseGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseInvoiceServiceLineSave<RS>
implements IEntityProcessor<PurchaseInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlPurchaseGoodsServiceLine<RS> utlPurchaseGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final PurchaseInvoiceServiceLine process(Map<String, Object> pAddParam, PurchaseInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
        }
        if (pEntity.getItsCost().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pAddParam.get("user"));
        }
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getItsOwner()));
        pEntity.setService(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getService()));
        pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.setItsCost(pEntity.getItsCost().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getItsCost()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        BigDecimal totalTaxes = BigDecimal.ZERO;
        String taxesDescription = "";
        ArrayList<PurchaseInvoiceServiceTaxLine> tls = null;
        if (!pEntity.getItsOwner().getVendor().getIsForeigner().booleanValue() && this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue() && pEntity.getService().getTaxCategory() != null) {
            tls = new ArrayList<PurchaseInvoiceServiceTaxLine>();
            List<InvItemTaxCategoryLine> pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getService().getTaxCategory().getItsId());
            BigDecimal bigDecimal100 = new BigDecimal("100.00");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (InvItemTaxCategoryLine pst : pstl) {
                if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                totalTaxes = totalTaxes.add(addTx);
                if (i++ > 0) {
                    sb.append(", ");
                }
                PurchaseInvoiceServiceTaxLine pistl = new PurchaseInvoiceServiceTaxLine();
                pistl.setIsNew(true);
                pistl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                pistl.setItsTotal(addTx);
                pistl.setTax(pst.getTax());
                tls.add(pistl);
                sb.append(pst.getTax().getItsName() + " " + this.prn(pAddParam, addTx));
            }
            taxesDescription = sb.toString();
        }
        pEntity.setTaxesDescription(taxesDescription);
        pEntity.setTotalTaxes(totalTaxes);
        pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
        }
        PurchaseInvoiceServiceTaxLine pistlt = new PurchaseInvoiceServiceTaxLine();
        pistlt.setItsOwner(pEntity);
        List<PurchaseInvoiceServiceTaxLine> tlsw = this.getSrvOrm().retrieveListForField(pAddParam, pistlt, "itsOwner");
        if (tls != null) {
            for (int i = 0; i < tls.size(); ++i) {
                if (i < tlsw.size()) {
                    tlsw.get(i).setTax(((PurchaseInvoiceServiceTaxLine)tls.get(i)).getTax());
                    tlsw.get(i).setItsTotal(((PurchaseInvoiceServiceTaxLine)tls.get(i)).getItsTotal());
                    this.getSrvOrm().updateEntity(pAddParam, tlsw.get(i));
                    continue;
                }
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setItsOwner(pEntity);
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setInvoiceId(pEntity.getItsOwner().getItsId());
                this.getSrvOrm().insertEntity(pAddParam, tls.get(i));
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setIsNew(false);
            }
            for (int j = tls.size(); j < tlsw.size(); ++j) {
                this.getSrvOrm().deleteEntity(pAddParam, tlsw.get(j));
            }
        } else {
            for (PurchaseInvoiceServiceTaxLine pistlw : tlsw) {
                this.getSrvOrm().deleteEntity(pAddParam, pistlw);
            }
        }
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlPurchaseGoodsServiceLine.updateOwner(pAddParam, pEntity.getItsOwner());
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
        return null;
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("pricePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlPurchaseGoodsServiceLine<RS> getUtlPurchaseGoodsServiceLine() {
        return this.utlPurchaseGoodsServiceLine;
    }

    public final void setUtlPurchaseGoodsServiceLine(UtlPurchaseGoodsServiceLine<RS> pUtlPurchaseGoodsServiceLine) {
        this.utlPurchaseGoodsServiceLine = pUtlPurchaseGoodsServiceLine;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

