/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.CogsEntry;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.processor.UtlSalesGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<CogsEntry> srvCogsEntry;
    private UtlSalesGoodsServiceLine<RS> utlSalesGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final SalesInvoiceLine process(Map<String, Object> pAddParam, SalesInvoiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            if (pEntity.getReversedId() != null) {
                SalesInvoiceLine reversed = this.getSrvOrm().retrieveEntityById(pAddParam, SalesInvoiceLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pAddParam.get("user"));
                }
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsPrice(reversed.getItsPrice());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                this.getSrvOrm().insertEntity(pAddParam, pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, reversed);
                this.srvWarehouseEntry.reverseDraw(pAddParam, pEntity);
                this.srvCogsEntry.reverseDraw(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
                SalesInvoiceGoodsTaxLine pigtlt = new SalesInvoiceGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                List<SalesInvoiceGoodsTaxLine> tls = this.getSrvOrm().retrieveListForField(pAddParam, pigtlt, "itsOwner");
                for (SalesInvoiceGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pAddParam, pigtl);
                }
            } else {
                if (pEntity.getItsQuantity().doubleValue() <= 0.0 && pEntity.getReversedId() == null) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
                }
                if (pEntity.getItsPrice().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "price_less_eq_0::" + pAddParam.get("user"));
                }
                pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getInvItem()));
                pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                pEntity.setItsPrice(pEntity.getItsPrice().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getItsPrice()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                BigDecimal totalTaxes = BigDecimal.ZERO;
                String taxesDescription = "";
                HashSet<SalesInvoiceGoodsTaxLine> tls = null;
                if (!pEntity.getItsOwner().getCustomer().getIsForeigner().booleanValue() && this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue() && pEntity.getInvItem().getTaxCategory() != null) {
                    tls = new HashSet<SalesInvoiceGoodsTaxLine>();
                    List<InvItemTaxCategoryLine> pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getInvItem().getTaxCategory().getItsId());
                    BigDecimal bigDecimal100 = new BigDecimal("100.00");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine pst : pstl) {
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                        BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                        totalTaxes = totalTaxes.add(addTx);
                        SalesInvoiceGoodsTaxLine pigtl = new SalesInvoiceGoodsTaxLine();
                        pigtl.setIsNew(true);
                        pigtl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        pigtl.setItsTotal(addTx);
                        pigtl.setTax(pst.getTax());
                        tls.add(pigtl);
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        sb.append(pst.getTax().getItsName() + " " + this.prn(pAddParam, addTx));
                    }
                    taxesDescription = sb.toString();
                }
                pEntity.setTaxesDescription(taxesDescription);
                pEntity.setTotalTaxes(totalTaxes);
                pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
                this.getSrvOrm().insertEntity(pAddParam, pEntity);
                pEntity.setIsNew(false);
                if (tls != null) {
                    for (SalesInvoiceGoodsTaxLine pigtl : tls) {
                        pigtl.setItsOwner(pEntity);
                        pigtl.setInvoiceId(pEntity.getItsOwner().getItsId());
                        this.getSrvOrm().insertEntity(pAddParam, pigtl);
                        pigtl.setIsNew(false);
                    }
                }
                this.srvWarehouseEntry.withdrawal(pAddParam, pEntity, pEntity.getWarehouseSiteFo());
                this.srvCogsEntry.withdrawal(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            }
            this.utlSalesGoodsServiceLine.updateOwner(pAddParam, pEntity.getItsOwner());
            pAddParam.put("nextEntity", pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("pricePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlSalesGoodsServiceLine<RS> getUtlSalesGoodsServiceLine() {
        return this.utlSalesGoodsServiceLine;
    }

    public final void setUtlSalesGoodsServiceLine(UtlSalesGoodsServiceLine<RS> pUtlSalesGoodsServiceLine) {
        this.utlSalesGoodsServiceLine = pUtlSalesGoodsServiceLine;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<CogsEntry> getSrvCogsEntry() {
        return this.srvCogsEntry;
    }

    public final void setSrvCogsEntry(ISrvDrawItemEntry<CogsEntry> pSrvCogsEntry) {
        this.srvCogsEntry = pSrvCogsEntry;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

