/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.PaymentFrom;
import org.beigesoft.accounting.persistable.PrepaymentFrom;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceTaxLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.processor.APrcAccDocCogsSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcSalesInvoiceSave<RS>
extends APrcAccDocCogsSave<RS, SalesInvoice> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getPrepaymentFrom() != null) {
            pEntity.setPrepaymentFrom(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getPrepaymentFrom()));
            if (pEntity.getReversedId() == null && pEntity.getPrepaymentFrom().getSalesInvoiceId() != null && !pEntity.getHasMadeAccEntries().booleanValue()) {
                throw new ExceptionWithCode(1003, "prepayment_already_in_use");
            }
            if (pEntity.getReversedId() == null && !pEntity.getPrepaymentFrom().getCustomer().getItsId().equals(pEntity.getCustomer().getItsId())) {
                throw new ExceptionWithCode(1003, "prepayment_for_different_vendor");
            }
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentFrom() != null && pEntity.getPaymentTotal().compareTo(pEntity.getPrepaymentFrom().getItsTotal()) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentFrom() == null && pEntity.getPaymentTotal().compareTo(BigDecimal.ZERO) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() == null) {
            this.calculateTotalPayment(pAddParam, pEntity);
        }
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd)) {
            if (pEntity.getReversedId() != null) {
                SalesInvoiceLine sil = new SalesInvoiceLine();
                SalesInvoice reversed = new SalesInvoice();
                reversed.setItsId(pEntity.getReversedId());
                sil.setItsOwner(reversed);
                List<SalesInvoiceLine> reversedLines = this.getSrvOrm().retrieveListForField(pAddParam, sil, "itsOwner");
                String langDef = (String)pAddParam.get("langDef");
                for (SalesInvoiceLine reversedLine : reversedLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceLine reversingLine = new SalesInvoiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setInvItem(reversedLine.getInvItem());
                    reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                    reversingLine.setItsPrice(reversedLine.getItsPrice());
                    reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_n", langDef) + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                    this.getSrvOrm().insertEntity(pAddParam, reversingLine);
                    reversingLine.setIsNew(false);
                    this.getSrvWarehouseEntry().reverseDraw(pAddParam, reversingLine);
                    this.getSrvCogsEntry().reverseDraw(pAddParam, reversingLine, pEntity.getItsDate(), pEntity.getItsId());
                    String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                    reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_n", langDef) + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, reversedLine);
                    SalesInvoiceGoodsTaxLine pigtlt = new SalesInvoiceGoodsTaxLine();
                    pigtlt.setItsOwner(reversedLine);
                    List<SalesInvoiceGoodsTaxLine> tls = this.getSrvOrm().retrieveListForField(pAddParam, pigtlt, "itsOwner");
                    for (SalesInvoiceGoodsTaxLine pigtl : tls) {
                        this.getSrvOrm().deleteEntity(pAddParam, pigtl);
                    }
                }
                SalesInvoiceServiceLine sisl = new SalesInvoiceServiceLine();
                sisl.setItsOwner(reversed);
                List<SalesInvoiceServiceLine> revServLines = this.getSrvOrm().retrieveListForField(pAddParam, sisl, "itsOwner");
                for (SalesInvoiceServiceLine reversedLine : revServLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceServiceLine reversingLine = new SalesInvoiceServiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setService(reversedLine.getService());
                    reversingLine.setItsPrice(reversedLine.getItsPrice().negate());
                    reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                    reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                    reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pAddParam, reversingLine);
                    reversingLine.setIsNew(false);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, reversedLine);
                    SalesInvoiceServiceTaxLine pigtlt = new SalesInvoiceServiceTaxLine();
                    pigtlt.setItsOwner(reversedLine);
                    List<SalesInvoiceServiceTaxLine> tls = this.getSrvOrm().retrieveListForField(pAddParam, pigtlt, "itsOwner");
                    for (SalesInvoiceServiceTaxLine pigtl : tls) {
                        this.getSrvOrm().deleteEntity(pAddParam, pigtl);
                    }
                }
                SalesInvoiceTaxLine sitl = new SalesInvoiceTaxLine();
                sitl.setItsOwner(reversed);
                List<SalesInvoiceTaxLine> reversedTaxLines = this.getSrvOrm().retrieveListForField(pAddParam, sitl, "itsOwner");
                for (SalesInvoiceTaxLine reversedLine : reversedTaxLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceTaxLine reversingLine = new SalesInvoiceTaxLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setTax(reversedLine.getTax());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pAddParam, reversingLine);
                    reversingLine.setIsNew(false);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, reversedLine);
                }
            }
            if (pEntity.getPrepaymentFrom() != null) {
                if (pEntity.getReversedId() != null) {
                    pEntity.getPrepaymentFrom().setSalesInvoiceId(null);
                } else {
                    pEntity.getPrepaymentFrom().setSalesInvoiceId(pEntity.getItsId());
                }
                this.getSrvOrm().updateEntity(pAddParam, pEntity.getPrepaymentFrom());
            }
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData, SalesInvoice pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData) throws Exception {
    }

    public final void calculateTotalPayment(Map<String, Object> pAddParam, SalesInvoice pEntity) throws Exception {
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        if (pEntity.getPrepaymentFrom() != null) {
            pEntity.setPaymentTotal(pEntity.getPrepaymentFrom().getItsTotal());
            pEntity.setPaymentDescription(this.getSrvI18n().getMsg(PrepaymentFrom.class.getSimpleName() + "short", langDef) + " #" + pEntity.getPrepaymentFrom().getIdDatabaseBirth() + "-" + pEntity.getPrepaymentFrom().getItsId() + ", " + dateFormat.format(pEntity.getPrepaymentFrom().getItsDate()) + ", " + pEntity.getPaymentTotal());
        } else {
            pEntity.setPaymentTotal(BigDecimal.ZERO);
            pEntity.setPaymentDescription("");
        }
        List<PaymentFrom> payments = this.getSrvOrm().retrieveListWithConditions(pAddParam, PaymentFrom.class, "where PAYMENTFROM.HASMADEACCENTRIES=1 and PAYMENTFROM.REVERSEDID is null and SALESINVOICE=" + pEntity.getItsId());
        for (PaymentFrom payment : payments) {
            pEntity.setPaymentTotal(pEntity.getPaymentTotal().add(payment.getItsTotal()));
            pEntity.setPaymentDescription(pEntity.getPaymentDescription() + " " + this.getSrvI18n().getMsg(PaymentFrom.class.getSimpleName() + "short", langDef) + " #" + payment.getIdDatabaseBirth() + "-" + payment.getItsId() + ", " + dateFormat.format(payment.getItsDate()) + ", " + payment.getItsTotal());
        }
    }
}

