/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceTaxLine;
import org.beigesoft.accounting.processor.UtlSalesGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceServiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlSalesGoodsServiceLine<RS> utlSalesGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final SalesInvoiceServiceLine process(Map<String, Object> pAddParam, SalesInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
        }
        if (pEntity.getItsPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "price_less_or_eq_zero");
        }
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getItsOwner()));
        pEntity.setService(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getService()));
        pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.setItsPrice(pEntity.getItsPrice().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getItsPrice()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        BigDecimal totalTaxes = BigDecimal.ZERO;
        String taxesDescription = "";
        ArrayList<SalesInvoiceServiceTaxLine> tls = null;
        if (!pEntity.getItsOwner().getCustomer().getIsForeigner().booleanValue() && this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue() && pEntity.getService().getTaxCategory() != null) {
            tls = new ArrayList<SalesInvoiceServiceTaxLine>();
            List<InvItemTaxCategoryLine> pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getService().getTaxCategory().getItsId());
            BigDecimal bigDecimal100 = new BigDecimal("100.00");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (InvItemTaxCategoryLine pst : pstl) {
                if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                totalTaxes = totalTaxes.add(addTx);
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(pst.getTax().getItsName() + " " + this.prn(pAddParam, addTx));
                SalesInvoiceServiceTaxLine pistl = new SalesInvoiceServiceTaxLine();
                pistl.setIsNew(true);
                pistl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                pistl.setItsTotal(addTx);
                pistl.setTax(pst.getTax());
                tls.add(pistl);
            }
            taxesDescription = sb.toString();
        }
        pEntity.setTaxesDescription(taxesDescription);
        pEntity.setTotalTaxes(totalTaxes);
        pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
        }
        SalesInvoiceServiceTaxLine pistlt = new SalesInvoiceServiceTaxLine();
        pistlt.setItsOwner(pEntity);
        List<SalesInvoiceServiceTaxLine> tlsw = this.getSrvOrm().retrieveListForField(pAddParam, pistlt, "itsOwner");
        if (tls != null) {
            for (int i = 0; i < tls.size(); ++i) {
                if (i < tlsw.size()) {
                    tlsw.get(i).setTax(((SalesInvoiceServiceTaxLine)tls.get(i)).getTax());
                    tlsw.get(i).setItsTotal(((SalesInvoiceServiceTaxLine)tls.get(i)).getItsTotal());
                    this.getSrvOrm().updateEntity(pAddParam, tlsw.get(i));
                    continue;
                }
                ((SalesInvoiceServiceTaxLine)tls.get(i)).setItsOwner(pEntity);
                ((SalesInvoiceServiceTaxLine)tls.get(i)).setInvoiceId(pEntity.getItsOwner().getItsId());
                this.getSrvOrm().insertEntity(pAddParam, tls.get(i));
                ((SalesInvoiceServiceTaxLine)tls.get(i)).setIsNew(false);
            }
            for (int j = tls.size(); j < tlsw.size(); ++j) {
                this.getSrvOrm().deleteEntity(pAddParam, tlsw.get(j));
            }
        } else {
            for (SalesInvoiceServiceTaxLine pistlw : tlsw) {
                this.getSrvOrm().deleteEntity(pAddParam, pistlw);
            }
        }
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlSalesGoodsServiceLine.updateOwner(pAddParam, pEntity.getItsOwner());
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
        return null;
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("pricePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlSalesGoodsServiceLine<RS> getUtlSalesGoodsServiceLine() {
        return this.utlSalesGoodsServiceLine;
    }

    public final void setUtlSalesGoodsServiceLine(UtlSalesGoodsServiceLine<RS> pUtlSalesGoodsServiceLine) {
        this.utlSalesGoodsServiceLine = pUtlSalesGoodsServiceLine;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

