/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.SalesReturn;
import org.beigesoft.accounting.persistable.SalesReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesReturnLine;
import org.beigesoft.accounting.persistable.SalesReturnTaxLine;
import org.beigesoft.accounting.processor.APrcAccDocFullSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcSalesReturnSave<RS>
extends APrcAccDocFullSave<RS, SalesReturn> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, SalesReturn pEntity, IRequestData pRequestData) throws Exception {
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, SalesReturn pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd) && pEntity.getReversedId() != null) {
            SalesReturnLine srl = new SalesReturnLine();
            SalesReturn reversed = new SalesReturn();
            reversed.setItsId(pEntity.getReversedId());
            srl.setItsOwner(reversed);
            List<SalesReturnLine> reversedLines = this.getSrvOrm().retrieveListForField(pAddParam, srl, "itsOwner");
            String langDef = (String)pAddParam.get("langDef");
            for (SalesReturnLine reversedLine : reversedLines) {
                if (reversedLine.getReversedId() != null) continue;
                if (!reversedLine.getItsQuantity().equals(reversedLine.getTheRest())) {
                    throw new ExceptionWithCode(1303, "There is withdrawals from this source!");
                }
                SalesReturnLine reversingLine = new SalesReturnLine();
                reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                reversingLine.setReversedId(reversedLine.getItsId());
                reversingLine.setWarehouseSite(reversedLine.getWarehouseSite());
                reversingLine.setInvItem(reversedLine.getInvItem());
                reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                reversingLine.setItsCost(reversedLine.getItsCost());
                reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                reversingLine.setIsNew(true);
                reversingLine.setItsOwner(pEntity);
                reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_n", langDef) + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                this.getSrvOrm().insertEntity(pAddParam, reversingLine);
                reversingLine.setIsNew(false);
                this.getSrvWarehouseEntry().load(pAddParam, reversingLine, reversingLine.getWarehouseSite());
                String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_n", langDef) + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                reversedLine.setReversedId(reversingLine.getItsId());
                reversedLine.setTheRest(BigDecimal.ZERO);
                this.getSrvOrm().updateEntity(pAddParam, reversedLine);
                SalesReturnGoodsTaxLine pigtlt = new SalesReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversedLine);
                List<SalesReturnGoodsTaxLine> tls = this.getSrvOrm().retrieveListForField(pAddParam, pigtlt, "itsOwner");
                for (SalesReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pAddParam, pigtl);
                }
            }
            SalesReturnTaxLine srtl = new SalesReturnTaxLine();
            srtl.setItsOwner(reversed);
            List<SalesReturnTaxLine> reversedTaxLines = this.getSrvOrm().retrieveListForField(pAddParam, srtl, "itsOwner");
            for (SalesReturnTaxLine reversedLine : reversedTaxLines) {
                if (reversedLine.getReversedId() != null) continue;
                SalesReturnTaxLine reversingLine = new SalesReturnTaxLine();
                reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                reversingLine.setReversedId(reversedLine.getItsId());
                reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                reversingLine.setTax(reversedLine.getTax());
                reversingLine.setIsNew(true);
                reversingLine.setItsOwner(pEntity);
                this.getSrvOrm().insertEntity(pAddParam, reversingLine);
                reversingLine.setIsNew(false);
                reversedLine.setReversedId(reversingLine.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, reversedLine);
            }
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, SalesReturn pEntity, IRequestData pRequestData, SalesReturn pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, SalesReturn pEntity, IRequestData pRequestData) throws Exception {
    }
}

