/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class UtlSalesGoodsServiceLine<RS> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private String fileQuerySalesInvoiceTaxes = "salesInvoiceTaxes.sql";
    private String querySalesInvoiceTaxes;
    private String fileQuerySalesInvoiceTotals = "salesInvoiceTotals.sql";
    private String querySalesInvoiceTotals;
    private ISrvAccSettings srvAccSettings;

    public final void updateOwner(Map<String, Object> pAddParam, SalesInvoice pItsOwner) throws Exception {
        String query = this.lazyGetQuerySalesInvoiceTotals();
        query = query.replace(":ITSOWNER", pItsOwner.getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        pItsOwner.setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pItsOwner.setItsTotal(pItsOwner.getSubtotal().add(pItsOwner.getTotalTaxes()));
        this.getSrvOrm().updateEntity(pAddParam, pItsOwner);
        this.updateTaxLines(pAddParam, pItsOwner);
    }

    public final String lazyGetQuerySalesInvoiceTaxes() throws Exception {
        if (this.querySalesInvoiceTaxes == null) {
            String flName = "/accounting/trade/" + this.fileQuerySalesInvoiceTaxes;
            this.querySalesInvoiceTaxes = this.loadString(flName);
        }
        return this.querySalesInvoiceTaxes;
    }

    public final String lazyGetQuerySalesInvoiceTotals() throws Exception {
        if (this.querySalesInvoiceTotals == null) {
            String flName = "/accounting/trade/" + this.fileQuerySalesInvoiceTotals;
            this.querySalesInvoiceTotals = this.loadString(flName);
        }
        return this.querySalesInvoiceTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = UtlSalesGoodsServiceLine.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = UtlSalesGoodsServiceLine.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pAddParam, SalesInvoice pOwner) throws Exception {
        block14: {
            List<SalesInvoiceTaxLine> sitl;
            block13: {
                sitl = this.getSrvOrm().retrieveListWithConditions(pAddParam, SalesInvoiceTaxLine.class, "where ITSOWNER=" + pOwner.getItsId());
                String query = this.lazyGetQuerySalesInvoiceTaxes().replace(":INVOICEID", pOwner.getItsId().toString());
                if (pOwner.getCustomer().getIsForeigner().booleanValue() || !this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue()) break block13;
                int countUpdatedSitl = 0;
                try (IRecordSet<RS> recordSet = null;){
                    recordSet = this.getSrvDatabase().retrieveRecords(query);
                    if (recordSet.moveToFirst()) {
                        do {
                            SalesInvoiceTaxLine sit;
                            Long taxId = recordSet.getLong("TAXID");
                            Double totalTax = recordSet.getDouble("TOTALTAX");
                            if (sitl.size() > countUpdatedSitl) {
                                sit = sitl.get(countUpdatedSitl);
                                ++countUpdatedSitl;
                            } else {
                                sit = new SalesInvoiceTaxLine();
                                sit.setItsOwner(pOwner);
                                sit.setIsNew(true);
                                sit.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                            }
                            Tax tax = new Tax();
                            tax.setItsId(taxId);
                            sit.setTax(tax);
                            sit.setItsTotal(BigDecimal.valueOf(totalTax).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                            if (sit.getIsNew().booleanValue()) {
                                this.getSrvOrm().insertEntity(pAddParam, sit);
                                sit.setIsNew(false);
                                continue;
                            }
                            this.getSrvOrm().updateEntity(pAddParam, sit);
                        } while (recordSet.moveToNext());
                    }
                }
                if (countUpdatedSitl >= sitl.size()) break block14;
                for (int j = countUpdatedSitl; j < sitl.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pAddParam, sitl.get(j));
                }
                break block14;
            }
            if (sitl.size() > 0) {
                for (SalesInvoiceTaxLine sitln : sitl) {
                    this.getSrvOrm().deleteEntity(pAddParam, sitln);
                }
            }
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getFileQuerySalesInvoiceTaxes() {
        return this.fileQuerySalesInvoiceTaxes;
    }

    public final void setFileQuerySalesInvoiceTaxes(String pFileQuerySalesInvoiceTaxes) {
        this.fileQuerySalesInvoiceTaxes = pFileQuerySalesInvoiceTaxes;
    }

    public final String getQuerySalesInvoiceTaxes() {
        return this.querySalesInvoiceTaxes;
    }

    public final void setQuerySalesInvoiceTaxes(String pQuerySalesInvoiceTaxes) {
        this.querySalesInvoiceTaxes = pQuerySalesInvoiceTaxes;
    }

    public final String getFileQuerySalesInvoiceTotals() {
        return this.fileQuerySalesInvoiceTotals;
    }

    public final void setFileQuerySalesInvoiceTotals(String pFileQuerySalesInvoiceTotals) {
        this.fileQuerySalesInvoiceTotals = pFileQuerySalesInvoiceTotals;
    }

    public final String getQuerySalesInvoiceTotals() {
        return this.querySalesInvoiceTotals;
    }

    public final void setQuerySalesInvoiceTotals(String pQuerySalesInvoiceTotals) {
        this.querySalesInvoiceTotals = pQuerySalesInvoiceTotals;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

