/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.WarehouseRestLine;
import org.beigesoft.accounting.service.ISrvWarehouseRests;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;

public class SrvWarehouseRests<RS>
implements ISrvWarehouseRests {
    private ISrvDatabase<RS> srvDatabase;
    private String queryMain;

    public SrvWarehouseRests() {
    }

    public SrvWarehouseRests(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WarehouseRestLine> retrieveWarehouseRests(Map<String, Object> pAddParam) throws Exception {
        ArrayList<WarehouseRestLine> result = new ArrayList<WarehouseRestLine>();
        if (this.queryMain == null) {
            String flName = "/accounting/warehouse/rests-in-warehouses.sql";
            this.queryMain = this.loadString(flName);
        }
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(this.queryMain);
            if (recordSet.moveToFirst()) {
                do {
                    WarehouseRestLine wrl = new WarehouseRestLine();
                    wrl.setWarehouse(recordSet.getString("WAREHOUSE"));
                    wrl.setInvItemId(recordSet.getLong("INVITEMID"));
                    wrl.setInvItem(recordSet.getString("INVITEM"));
                    wrl.setUnitOfMeasure(recordSet.getString("UNITOFMEASURE"));
                    wrl.setTheRest(BigDecimal.valueOf(recordSet.getDouble("THEREST")));
                    result.add(wrl);
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = SrvWarehouseRests.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvWarehouseRests.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final String getQueryMain() {
        return this.queryMain;
    }

    public final void setQueryMain(String pQueryMain) {
        this.queryMain = pQueryMain;
    }
}

