/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.doc.service;

import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocString;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.MetricsString;
import org.beigesoft.doc.model.Pagination;
import org.beigesoft.doc.service.IDeriverElements;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.doc.service.IEvalMetricsString;
import org.beigesoft.doc.service.IFctElement;

public class DeriverElPagination<WI>
implements IDeriverElements<WI, Pagination<WI>> {
    private IFctElement<WI> elementFactory;
    private IDocumentMaker<WI> documentMaker;
    private IEvalMetricsString evalMetricsString;

    @Override
    public final void derive(Pagination<WI> pPaging) throws Exception {
        Integer totalPg = pPaging.getDocument().getPages().size();
        String fntNm = pPaging.getDocument().getFonts().get(pPaging.getFontNumber() - 1).getItsName();
        Integer numberPg = pPaging.getStart();
        Integer pgNum = pPaging.getStart();
        while (pgNum <= totalPg) {
            StringBuffer sb = new StringBuffer();
            if (pPaging.getTitle() == null) {
                sb.append(numberPg.toString());
            } else {
                sb.append(pPaging.getTitle() + numberPg);
            }
            if (pPaging.getFrom() != null) {
                sb.append(pPaging.getFrom() + totalPg);
            }
            String str = sb.toString();
            DocPage docPg = pPaging.getDocument().getPages().get(pgNum - 1);
            double wd = docPg.getWidth() - docPg.getMarginLeft() - docPg.getMarginRight();
            MetricsString ms = this.evalMetricsString.eval(str, fntNm, pPaging.getFontSize(), wd, 0.0);
            if (EAlignHorizontal.LEFT.equals((Object)pPaging.getAlignHorizontal())) {
                pPaging.setX1(docPg.getMarginLeft());
            } else if (pPaging.getAlignHorizontal() == null || EAlignHorizontal.RIGHT.equals((Object)pPaging.getAlignHorizontal())) {
                pPaging.setX1(docPg.getWidth() - docPg.getMarginRight() - ms.getWidth());
            } else if (EAlignHorizontal.CENTER.equals((Object)pPaging.getAlignHorizontal())) {
                pPaging.setX1((docPg.getWidth() - ms.getWidth()) / 2.0);
            }
            pPaging.setX2(pPaging.getX1() + ms.getWidth());
            pPaging.setY1(docPg.getHeight() - docPg.getMarginBottom() / 2.0 - pPaging.getFontSize() / 2.0);
            pPaging.setY2(pPaging.getY1() + pPaging.getFontSize());
            DocString<WI> dstr = this.elementFactory.createDocString(pPaging);
            dstr.setX1(pPaging.getX1());
            dstr.setX2(pPaging.getX2());
            dstr.setY1(pPaging.getY1());
            dstr.setY2(pPaging.getY2());
            dstr.setFontNumber(pPaging.getFontNumber());
            dstr.setFontSize(pPaging.getFontSize());
            dstr.setValue(str);
            docPg.getElements().add(dstr);
            Integer n = numberPg;
            Integer n2 = numberPg = Integer.valueOf(numberPg + 1);
            Integer n3 = pgNum;
            Integer n4 = pgNum = Integer.valueOf(pgNum + 1);
        }
    }

    @Override
    public final void initAfterChanges(Pagination<WI> pPaging) throws Exception {
    }

    public final IFctElement<WI> getElementFactory() {
        return this.elementFactory;
    }

    public final void setElementFactory(IFctElement<WI> pElementFactory) {
        this.elementFactory = pElementFactory;
    }

    public final IDocumentMaker<WI> getDocumentMaker() {
        return this.documentMaker;
    }

    public final void setDocumentMaker(IDocumentMaker<WI> pDocumentMaker) {
        this.documentMaker = pDocumentMaker;
    }

    public final IEvalMetricsString getEvalMetricsString() {
        return this.evalMetricsString;
    }

    public final void setEvalMetricsString(IEvalMetricsString pEvalMetricsString) {
        this.evalMetricsString = pEvalMetricsString;
    }
}

