/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.doc.service;

import java.util.ArrayList;
import java.util.List;
import org.beigesoft.doc.exception.ExceptionBdw;
import org.beigesoft.doc.model.DocLine;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocString;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EAlignVertical;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.model.IDocContainer;
import org.beigesoft.doc.model.MetricsString;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.model.TableRow;
import org.beigesoft.doc.service.IDeriverElements;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.doc.service.IEvalMetricsString;
import org.beigesoft.doc.service.IFctElement;

public class DeriverElTable<WI>
implements IDeriverElements<WI, DocTable<WI>> {
    private IFctElement<WI> elementFactory;
    private IDocumentMaker<WI> documentMaker;
    private IEvalMetricsString evalMetricsString;

    @Override
    public final void derive(DocTable<WI> pTbl) throws Exception {
        if (EWraping.FILL_PARENT.equals((Object)pTbl.getWraping()) && pTbl.getIsWidthFixed() && pTbl.getWidthInPercentage() < 3.0) {
            throw new ExceptionBdw("Table that Fill parent has wrong fixed width in no %!!!: " + pTbl.getWidthInPercentage());
        }
        if (pTbl.getIsWidthFixed() && EWraping.WRAP_CONTENT.equals((Object)pTbl.getWraping())) {
            throw new ExceptionBdw("Table has Wrap content and fixed width!!!");
        }
        this.evalWidthPosForTableAndRows(pTbl);
        this.evalFloatColumnWidths(pTbl);
        this.evalColumnPosX(pTbl);
        this.evalContentHeightsAndPosY(pTbl);
        this.generateAtomics(pTbl);
    }

    @Override
    public final void initAfterChanges(DocTable<WI> pTbl) throws Exception {
        for (TableCell cel : pTbl.getItsCells()) {
            cel.setMetricsString(null);
            cel.setIsMerged(false);
            cel.setMergingCell(null);
            cel.setIsMergedVertically(false);
        }
        for (TableRow row : pTbl.getItsRows()) {
            if (!row.getIsHeightFixed()) {
                row.setWidth(0.0);
                row.setWidthInPercentage(0.0);
                row.setX1(0.0);
                row.setX2(0.0);
                row.setHeight(0.0);
                row.setY1(0.0);
                row.setY2(0.0);
            }
            row.setIfHasHorizontalMerged(false);
            row.setIfHasVerticalMerged(false);
        }
        for (TableColumn col : pTbl.getItsColumns()) {
            if (!col.getIsWidthFixed()) {
                col.setWidth(0.0);
                col.setWidthInPercentage(0.0);
                col.setX1(0.0);
                col.setX2(0.0);
            }
            col.setIfHasHorizontalMerged(false);
        }
        if (!pTbl.getIsWidthFixed()) {
            pTbl.setWidth(0.0);
            pTbl.setWidthInPercentage(0.0);
            pTbl.setX1(0.0);
            pTbl.setX2(0.0);
        }
    }

    public final void addTopRowLine(DocTable<WI> pTbl, TableRow pRow, Integer pPgNum) throws Exception {
        DocLine<WI> dln = this.elementFactory.createDocLine(pTbl);
        dln.setWidth(pTbl.getBorder());
        dln.setX1(pRow.getX1());
        dln.setY1(pRow.getY1());
        dln.setX2(pRow.getX2());
        dln.setY2(pRow.getY1());
        pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dln);
    }

    public final void addBottomRowLine(DocTable<WI> pTbl, TableRow pRow, Integer pPgNum) throws Exception {
        DocLine<WI> dlnb = this.elementFactory.createDocLine(pTbl);
        dlnb.setWidth(pTbl.getBorder());
        dlnb.setX1(pRow.getX1());
        dlnb.setY1(pRow.getY2());
        dlnb.setX2(pRow.getX2());
        dlnb.setY2(pRow.getY2());
        pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dlnb);
    }

    public final void addBottomCellsLines(DocTable<WI> pTbl, TableRow pRow, Integer pPgNum, Integer pRowIdxOri) throws Exception {
        int startIdx;
        int colCnt = pTbl.getItsColumns().size();
        TableCell startCel = null;
        TableCell endCel = null;
        for (int celIdx = startIdx = pRowIdxOri * colCnt; celIdx < startIdx + colCnt; ++celIdx) {
            TableCell cel = pTbl.getItsCells().get(celIdx);
            if (cel.getMergedCell() != null && cel.getIsMergedVertically()) {
                if (startCel == null) continue;
                DocLine<WI> dlnb = this.elementFactory.createDocLine(pTbl);
                dlnb.setWidth(pRow.getBorder());
                int celStartIdx = pTbl.getItsCells().indexOf(startCel);
                TableColumn colStart = pTbl.getItsColumns().get((celStartIdx + colCnt) % colCnt);
                int celEndIdx = pTbl.getItsCells().indexOf(endCel);
                TableColumn colEnd = pTbl.getItsColumns().get((celEndIdx + colCnt) % colCnt);
                dlnb.setX1(colStart.getX1());
                dlnb.setY1(pRow.getY2());
                dlnb.setX2(colEnd.getX2());
                dlnb.setY2(pRow.getY2());
                pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dlnb);
                startCel = null;
                endCel = null;
                continue;
            }
            if (startCel == null) {
                startCel = cel;
            }
            endCel = cel;
        }
        if (startCel != null) {
            DocLine<WI> dlnb = this.elementFactory.createDocLine(pTbl);
            dlnb.setWidth(pRow.getBorder());
            int celStartIdx = pTbl.getItsCells().indexOf(startCel);
            TableColumn colStart = pTbl.getItsColumns().get((celStartIdx + colCnt) % colCnt);
            int celEndIdx = pTbl.getItsCells().indexOf(endCel);
            TableColumn colEnd = pTbl.getItsColumns().get((celEndIdx + colCnt) % colCnt);
            dlnb.setX1(colStart.getX1());
            dlnb.setY1(pRow.getY2());
            dlnb.setX2(colEnd.getX2());
            dlnb.setY2(pRow.getY2());
            pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dlnb);
        }
    }

    public final void addLine(DocTable<WI> pParent, double pX1, double pY1, double pX2, double pY2, double pBorder, Integer pPgNum) throws Exception {
        DocLine<WI> dln = this.elementFactory.createDocLine(pParent);
        dln.setWidth(pBorder);
        dln.setX1(pX1);
        dln.setY1(pY1);
        dln.setX2(pX2);
        dln.setY2(pY2);
        pParent.getDocument().getPages().get(pPgNum - 1).getElements().add(dln);
    }

    public final void addLeftRightRowLines(DocTable<WI> pTbl, TableRow pRow, Integer pPgNum) throws Exception {
        DocLine<WI> dlnl = this.elementFactory.createDocLine(pTbl);
        dlnl.setWidth(pTbl.getBorder());
        dlnl.setX1(pRow.getX1());
        dlnl.setY1(pRow.getY1());
        dlnl.setX2(pRow.getX1());
        dlnl.setY2(pRow.getY2());
        pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dlnl);
        DocLine<WI> dlnr = this.elementFactory.createDocLine(pTbl);
        dlnr.setWidth(pTbl.getBorder());
        dlnr.setX1(pRow.getX2());
        dlnr.setY1(pRow.getY1());
        dlnr.setX2(pRow.getX2());
        dlnr.setY2(pRow.getY2());
        pTbl.getDocument().getPages().get(pPgNum - 1).getElements().add(dlnr);
    }

    public final void addRightColumnLineForRows(DocTable<WI> pTbl, TableColumn pCol, int pColIdx, List<TableRow> pRows, Integer pPgNum) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        int rowIdx = 0;
        for (TableRow row : pRows) {
            if (!row.getIfHasCustomBordersBelow()) {
                boolean needLn = true;
                if (pCol.getIfHasHorizontalMerged()) {
                    TableCell mscel;
                    TableCell cel = pTbl.getItsCells().get(rowIdx * colCnt + pColIdx);
                    if (cel.getMergedCell() != null && !cel.getIsMergedVertically()) {
                        needLn = false;
                    } else if (cel.getIsMerged() && !(mscel = cel.getMergingCell()).getIsMergedVertically() && !cel.equals(mscel.getMergedCells().get(mscel.getMergedCells().size() - 1))) {
                        needLn = false;
                    }
                }
                if (needLn) {
                    DocLine<WI> dlnr = this.elementFactory.createDocLine(pTbl);
                    dlnr.setWidth(pTbl.getBorder());
                    dlnr.setX1(pCol.getX2());
                    dlnr.setY1(row.getY1());
                    dlnr.setX2(pCol.getX2());
                    dlnr.setY2(row.getY2());
                    Integer pgNum = pPgNum;
                    if (pgNum == null) {
                        pgNum = row.getPageNumber();
                    }
                    pTbl.getDocument().getPages().get(pgNum - 1).getElements().add(dlnr);
                }
            }
            ++rowIdx;
        }
    }

    public final void generateStrings(DocTable<WI> pTbl, List<TableCell> pCells, List<TableRow> pRows, Integer pPgNum) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        int colIdx = 0;
        int rowIdx = 0;
        TableRow row = null;
        for (TableCell cel : pCells) {
            if (!cel.getIsMerged()) {
                TableColumn col = pTbl.getItsColumns().get(colIdx);
                if (row == null) {
                    row = pRows.get(rowIdx);
                }
                for (int i = 0; i < cel.getMetricsString().getStrings().size(); ++i) {
                    String str = cel.getMetricsString().getStrings().get(i);
                    DocString<WI> dstr = this.elementFactory.createDocString(pTbl);
                    dstr.setFontNumber(cel.getFontNumber());
                    dstr.setFontSize(cel.getFontSize());
                    dstr.setValue(str);
                    if (cel.getAlignHorizontal() == null || EAlignHorizontal.LEFT.equals((Object)cel.getAlignHorizontal())) {
                        dstr.setX1(col.getX1() + pTbl.getBorder() + col.getPaddingLeft());
                    } else if (EAlignHorizontal.RIGHT.equals((Object)cel.getAlignHorizontal())) {
                        dstr.setX1(col.getX2() - pTbl.getBorder() - col.getPaddingRight() - cel.getMetricsString().getWidths().get(i));
                    } else if (EAlignHorizontal.CENTER.equals((Object)cel.getAlignHorizontal())) {
                        double colWd = col.getWidth();
                        if (cel.getMergedCell() != null && !cel.getIsMergedVertically()) {
                            for (TableCell mcel : cel.getMergedCells()) {
                                int mcelIdx = pTbl.getItsCells().indexOf(mcel);
                                TableColumn mcol = pTbl.getItsColumns().get((mcelIdx + colCnt) % colCnt);
                                colWd += mcol.getWidth() + col.getBorder();
                            }
                        }
                        double dw = (colWd - cel.getMetricsString().getWidths().get(i)) / 2.0;
                        dstr.setX1(col.getX1() + dw);
                    }
                    dstr.setX2(dstr.getX1() + cel.getMetricsString().getWidth());
                    if (cel.getAlignVertical() == null || EAlignVertical.TOP.equals((Object)cel.getAlignVertical())) {
                        dstr.setY1(row.getY1() + pTbl.getBorder() + row.getPaddingTop() + cel.getFontSize() * (double)i);
                    } else if (EAlignVertical.BOTTOM.equals((Object)cel.getAlignVertical())) {
                        dstr.setY1(row.getY2() - pTbl.getBorder() - row.getPaddingTop() - cel.getMetricsString().getHeight() + cel.getFontSize() * (double)i);
                    } else if (EAlignVertical.MIDDLE.equals((Object)cel.getAlignVertical())) {
                        double dh = (row.getWidth() - cel.getMetricsString().getHeight()) / 2.0;
                        dstr.setY1(row.getY1() + dh + cel.getFontSize() * (double)i);
                    }
                    dstr.setY2(dstr.getY1() + cel.getFontSize());
                    Integer pgNum = pPgNum;
                    if (pgNum == null) {
                        pgNum = row.getPageNumber();
                    }
                    pTbl.getDocument().getPages().get(pgNum - 1).getElements().add(dstr);
                }
            }
            if (++colIdx != colCnt) continue;
            colIdx = 0;
            ++rowIdx;
            row = null;
        }
    }

    public final void generateAtomics(DocTable<WI> pTbl) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        if (pTbl.getBorder() > 1.0E-7 && !pTbl.getIsThereCellWithCustomBorder()) {
            boolean isFirst;
            Integer pgFistRow = pTbl.getItsRows().get(0).getPageNumber();
            Integer pgLastRow = pTbl.getItsRows().get(pTbl.getItsRows().size() - 1).getPageNumber();
            if (pTbl.getIsRepeatHead() && !pgFistRow.equals(pgLastRow)) {
                isFirst = true;
                Integer pgCurr = pgFistRow + 1;
                while (pgCurr <= pgLastRow) {
                    isFirst = true;
                    for (TableRow tableRow : pTbl.getRepHeadRows()) {
                        if (isFirst) {
                            isFirst = false;
                            this.addTopRowLine(pTbl, tableRow, pgCurr);
                        }
                        this.addLeftRightRowLines(pTbl, tableRow, pgCurr);
                        if (!tableRow.getIfHasVerticalMerged()) {
                            this.addBottomRowLine(pTbl, tableRow, pgCurr);
                            continue;
                        }
                        this.addBottomCellsLines(pTbl, tableRow, pgCurr, pTbl.getRepHeadRows().indexOf(tableRow));
                    }
                    int colIdx232 = 0;
                    for (TableColumn col : pTbl.getItsColumns()) {
                        if (colIdx232 + 1 < colCnt) {
                            this.addRightColumnLineForRows(pTbl, col, colIdx232, pTbl.getRepHeadRows(), pgCurr);
                        }
                        ++colIdx232;
                    }
                    this.generateStrings(pTbl, pTbl.getRepHeadCells(), pTbl.getRepHeadRows(), pgCurr);
                    Integer colIdx232 = pgCurr;
                    Integer n = pgCurr = Integer.valueOf(pgCurr + 1);
                }
            }
            isFirst = true;
            Integer curPgNum = pTbl.getItsRows().get(0).getPageNumber();
            for (TableRow tableRow : pTbl.getItsRows()) {
                int startIdx;
                if (!tableRow.getIfHasCustomBordersBelow()) {
                    if (isFirst || !curPgNum.equals(tableRow.getPageNumber()) && !pTbl.getIsRepeatHead()) {
                        isFirst = false;
                        curPgNum = tableRow.getPageNumber();
                        this.addTopRowLine(pTbl, tableRow, tableRow.getPageNumber());
                    }
                    this.addLeftRightRowLines(pTbl, tableRow, tableRow.getPageNumber());
                    if (!tableRow.getIfHasVerticalMerged()) {
                        this.addBottomRowLine(pTbl, tableRow, tableRow.getPageNumber());
                        continue;
                    }
                    this.addBottomCellsLines(pTbl, tableRow, tableRow.getPageNumber(), pTbl.getItsRows().indexOf(tableRow));
                    continue;
                }
                for (int celIdx = startIdx = pTbl.getItsRows().indexOf(tableRow) * colCnt; celIdx < startIdx + colCnt; ++celIdx) {
                    TableCell cel = pTbl.getItsCells().get(celIdx);
                    this.addBordersToCell(pTbl, cel);
                }
            }
            int colIdx = 0;
            for (TableColumn col : pTbl.getItsColumns()) {
                if (colIdx + 1 < colCnt) {
                    this.addRightColumnLineForRows(pTbl, col, colIdx, pTbl.getItsRows(), null);
                }
                ++colIdx;
            }
        } else if (pTbl.getBorder() > 1.0E-7 && pTbl.getIsThereCellWithCustomBorder()) {
            for (TableCell cel : pTbl.getItsCells()) {
                this.addBordersToCell(pTbl, cel);
            }
        }
        this.generateStrings(pTbl, pTbl.getItsCells(), pTbl.getItsRows(), null);
    }

    public final void addBordersToCell(DocTable<WI> pTbl, TableCell pCel) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        if (pCel.getIsShowBorderTop() || pCel.getIsShowBorderBottom() || pCel.getIsShowBorderLeft() || pCel.getIsShowBorderRight()) {
            int celIdx = pTbl.getItsCells().indexOf(pCel);
            int colIdx = (celIdx + colCnt) % colCnt;
            int rowIdx = celIdx / colCnt;
            TableColumn col = pTbl.getItsColumns().get(colIdx);
            TableRow row = pTbl.getItsRows().get(rowIdx);
            if (pCel.getIsShowBorderTop()) {
                this.addLine(pTbl, col.getX1(), row.getY1(), col.getX2(), row.getY1(), row.getBorder(), row.getPageNumber());
            }
            if (pCel.getIsShowBorderBottom()) {
                this.addLine(pTbl, col.getX1(), row.getY2(), col.getX2(), row.getY2(), row.getBorder(), row.getPageNumber());
            }
            if (pCel.getIsShowBorderLeft()) {
                this.addLine(pTbl, col.getX1(), row.getY1(), col.getX1(), row.getY2(), row.getBorder(), row.getPageNumber());
            }
            if (pCel.getIsShowBorderRight()) {
                this.addLine(pTbl, col.getX2(), row.getY1(), col.getX2(), row.getY2(), row.getBorder(), row.getPageNumber());
            }
        }
    }

    public final void evalFloatColumnWidths(DocTable<WI> pTbl) throws Exception {
        double fixedColWd = 0.0;
        double fixedPrColWdPr = 0.0;
        double floatColWdPr = 0.0;
        int floatColCn = 0;
        for (TableColumn col : pTbl.getItsColumns()) {
            if (EWraping.WRAP_CONTENT.equals((Object)col.getWraping())) {
                fixedColWd += col.getWidth();
                continue;
            }
            if (col.getIsWidthFixed() && !EWraping.FILL_PARENT.equals((Object)col.getWraping())) {
                fixedColWd += col.getWidth();
                continue;
            }
            if (col.getIsWidthFixed() && EWraping.FILL_PARENT.equals((Object)col.getWraping())) {
                if (col.getWidthInPercentage() < 2.0) {
                    throw new ExceptionBdw("Wrong float column width%: " + col.getWidthInPercentage());
                }
                fixedPrColWdPr += col.getWidthInPercentage();
                continue;
            }
            ++floatColCn;
        }
        double tblWidth = pTbl.getX2() - pTbl.getX1();
        double wd100pr = tblWidth - fixedColWd;
        if (wd100pr < -1.0E-4) {
            throw new ExceptionBdw("Wrong fixed column widths: tbl/cols " + tblWidth + "/" + fixedColWd);
        }
        if (wd100pr < -1.0E-4 && (fixedPrColWdPr > 2.0 || floatColCn > 0)) {
            throw new ExceptionBdw("Wrong fixed column widths: tbl/cols " + tblWidth + "/" + fixedColWd);
        }
        if (fixedPrColWdPr > 100.0001) {
            throw new ExceptionBdw("Wrong fixed column percentage widths: " + fixedPrColWdPr);
        }
        if (floatColCn > 0) {
            if (100.0 - fixedPrColWdPr < 2.0) {
                throw new ExceptionBdw("There is no place for float columns: " + fixedPrColWdPr);
            }
            floatColWdPr = (100.0 - fixedPrColWdPr) / (double)floatColCn;
        }
        for (TableColumn col : pTbl.getItsColumns()) {
            if (EWraping.FILL_PARENT.equals((Object)col.getWraping()) && col.getIsWidthFixed()) {
                col.setWidth(wd100pr * col.getWidthInPercentage() / 100.0);
                continue;
            }
            if (!EWraping.FILL_PARENT.equals((Object)col.getWraping())) continue;
            col.setWidth(wd100pr * floatColWdPr / 100.0);
        }
    }

    public final void evalColumnPosX(DocTable<WI> pTbl) throws Exception {
        double lastX2 = pTbl.getX1();
        for (TableColumn col : pTbl.getItsColumns()) {
            col.setX1(lastX2);
            col.setX2(lastX2 + col.getWidth());
            lastX2 = col.getX2();
        }
    }

    public final void evalContentHeightsAndPosY(DocTable<WI> pTbl) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        int rowIdx = 0;
        int colIdx = 0;
        TableRow row = pTbl.getItsRows().get(0);
        for (TableCell cel : pTbl.getItsCells()) {
            TableColumn col = pTbl.getItsColumns().get(colIdx);
            if (!cel.getIsMerged() && !EWraping.WRAP_CONTENT.equals((Object)col.getWraping())) {
                if (row == null) {
                    row = pTbl.getItsRows().get(rowIdx);
                }
                double borderWd = colIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                double borderHt = rowIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                double colWd = col.getWidth();
                if (cel.getMergedCell() != null && !cel.getIsMergedVertically()) {
                    for (TableCell mcel : cel.getMergedCells()) {
                        int mcelIdx = pTbl.getItsCells().indexOf(mcel);
                        TableColumn mcol = pTbl.getItsColumns().get((mcelIdx + colCnt) % colCnt);
                        colWd += mcol.getWidth() + col.getBorder();
                    }
                }
                String fntNm = pTbl.getDocument().getFonts().get(cel.getFontNumber() - 1).getItsName();
                MetricsString ms = this.evalMetricsString.eval(cel.getItsContent(), fntNm, cel.getFontSize(), colWd - col.getPaddingLeft() - col.getPaddingRight() - borderWd, 0.0);
                cel.setMetricsString(ms);
                double celHeight = row.getPaddingTop() + ms.getHeight() + row.getPaddingBottom() + borderHt;
                if (row.getHeight() < celHeight) {
                    if (cel.getMergedCell() != null && cel.getIsMergedVertically()) {
                        double htRowAvr = celHeight / (double)(cel.getMergedCells().size() + 1);
                        if (row.getHeight() < htRowAvr) {
                            row.setHeight(htRowAvr);
                        }
                        for (TableCell mcel : cel.getMergedCells()) {
                            int mcelIdx = pTbl.getItsCells().indexOf(mcel);
                            TableRow mrow = pTbl.getItsRows().get(mcelIdx / colCnt);
                            if (!(mrow.getHeight() < htRowAvr)) continue;
                            mrow.setHeight(htRowAvr);
                        }
                    } else {
                        row.setHeight(celHeight);
                    }
                }
            }
            if (++colIdx != colCnt) continue;
            colIdx = 0;
            ++rowIdx;
            row = null;
        }
        DocPage curPg = pTbl.getStartPage();
        rowIdx = 0;
        colIdx = 0;
        row = pTbl.getItsRows().get(0);
        double repHeaderHeight = 0.0;
        if (pTbl.getIsRepeatHead()) {
            TableRow hrow;
            pTbl.setRepHeadRows(new ArrayList<TableRow>());
            if (row.getIsHead()) {
                hrow = new TableRow(row);
                pTbl.getRepHeadRows().add(hrow);
                repHeaderHeight += hrow.getHeight();
            } else {
                throw new ExceptionBdw("Repeated header without itself!!!");
            }
            hrow.setY1(curPg.getMarginBottom() + pTbl.getMarginTop());
            hrow.setY2(hrow.getY1() + hrow.getHeight());
            TableRow hrowPrev = hrow;
            pTbl.setRepHeadCells(new ArrayList<TableCell>());
            for (TableCell cel : pTbl.getItsCells()) {
                if (row == null && (row = pTbl.getItsRows().get(rowIdx)).getIsHead()) {
                    if (pTbl.getRepHeadRows().size() == rowIdx) {
                        hrow = new TableRow(row);
                        pTbl.getRepHeadRows().add(hrow);
                        repHeaderHeight += hrow.getHeight();
                        hrow.setY1(hrowPrev.getY2());
                        hrow.setY2(hrow.getY1() + hrow.getHeight());
                        hrowPrev = hrow;
                    } else {
                        throw new ExceptionBdw("Row header after non-header!!! idx " + rowIdx);
                    }
                }
                if (row.getIsHead()) {
                    pTbl.getRepHeadCells().add(cel);
                }
                if (++colIdx != colCnt) continue;
                colIdx = 0;
                ++rowIdx;
                row = null;
            }
        }
        row = pTbl.getItsRows().get(0);
        if (pTbl.getY1() + row.getHeight() > curPg.getHeight()) {
            if (pTbl.getIsY1Fixed()) {
                throw new ExceptionBdw("Table Y1 fixed exceed page! Y1/row1 height: " + pTbl.getY1() + "/" + row.getHeight());
            }
            curPg = this.evalNextOrNewPage(pTbl, curPg);
            pTbl.setY1(curPg.getMarginBottom() + pTbl.getMarginTop());
        }
        row.setPageNumber(pTbl.getDocument().getPageNumber());
        row.setY1(pTbl.getY1());
        row.setY2(pTbl.getY1() + row.getHeight());
        for (int i = 1; i < pTbl.getItsRows().size(); ++i) {
            TableRow rowPrev = row;
            row = pTbl.getItsRows().get(i);
            if (rowPrev.getY2() + row.getHeight() > curPg.getHeight() - curPg.getMarginBottom()) {
                curPg = this.evalNextOrNewPage(pTbl, curPg);
                row.setY1(curPg.getMarginBottom() + repHeaderHeight);
            } else {
                row.setY1(rowPrev.getY2());
            }
            row.setPageNumber(pTbl.getDocument().getPageNumber());
            row.setY2(row.getY1() + row.getHeight());
        }
        pTbl.setY2(row.getY2());
    }

    public final DocPage<WI> evalNextOrNewPage(DocTable<WI> pTbl, DocPage pDocPg) throws Exception {
        int pgIdx = pTbl.getDocument().getPages().indexOf(pDocPg);
        if (pgIdx + 1 == pTbl.getDocument().getPages().size()) {
            this.documentMaker.addPage(pTbl.getDocument());
        }
        return pTbl.getDocument().getPages().get(pgIdx + 1);
    }

    public final boolean evalMergedCells(DocTable<WI> pTbl, TableCell pCel, TableColumn pCol, int pCelIdx, int pRowIdx, int pColIdx) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        TableCell mcel = pCel.getMergedCell();
        int mcelIdx = pTbl.getItsCells().indexOf(mcel);
        int mcolIdx = (mcelIdx + colCnt) % colCnt;
        int mrowIdx = mcelIdx / colCnt;
        if (pTbl.getItsColumns().size() > 1) {
            pCel.setIsMergedVertically(mcelIdx - pCelIdx != 1);
        } else {
            pCel.setIsMergedVertically(true);
        }
        if (!pCel.getIsMergedVertically() && mrowIdx != pRowIdx) {
            throw new ExceptionBdw("Merged cells wrong! cel #/# " + mcelIdx + "/" + pCelIdx);
        }
        if (pCel.getIsMergedVertically() && mcolIdx != pColIdx && mrowIdx - pRowIdx != 1) {
            throw new ExceptionBdw("Merged cells wrong! cel #/# " + mcelIdx + "/" + pCelIdx);
        }
        TableColumn mcol = pTbl.getItsColumns().get(mcolIdx);
        boolean wasMergedWrapped = false;
        if (EWraping.WRAP_CONTENT.equals((Object)pCol.getWraping())) {
            wasMergedWrapped = true;
            if (!(pCel.getIsMergedVertically() || EWraping.WRAP_CONTENT.equals((Object)mcol.getWraping()) || mcol.getIsWidthFixed() && !EWraping.FILL_PARENT.equals((Object)mcol.getWraping()))) {
                throw new ExceptionBdw("Merged columns must has wraping or fixed widths! # " + mcolIdx);
            }
        }
        TableRow row = pTbl.getItsRows().get(pRowIdx);
        if (pCel.getIsMergedVertically()) {
            row.setIfHasVerticalMerged(true);
            row = pTbl.getItsRows().get(mrowIdx);
            row.setIfHasVerticalMerged(true);
        } else {
            pCol.setIfHasHorizontalMerged(true);
            mcol.setIfHasHorizontalMerged(true);
            row.setIfHasHorizontalMerged(true);
        }
        mcel.setIsMerged(true);
        mcel.setMergingCell(pCel);
        pCel.setMergedCells(new ArrayList<TableCell>());
        pCel.getMergedCells().add(mcel);
        while ((mcel = mcel.getMergedCell()) != null) {
            int mcelPrevIdx = mcelIdx;
            int mcolPrevIdx = mcolIdx;
            int mrowPrevIdx = mrowIdx;
            mcelIdx = pTbl.getItsCells().indexOf(mcel);
            mcolIdx = (mcelIdx + colCnt) % colCnt;
            mrowIdx = mcelIdx / colCnt;
            if (!pCel.getIsMergedVertically() && mrowIdx != mrowPrevIdx) {
                throw new ExceptionBdw("Merged cells wrong! cel #/# " + mcelIdx + "/" + mcelPrevIdx);
            }
            if (pCel.getIsMergedVertically() && mcolIdx != mcolPrevIdx && mrowIdx - mrowPrevIdx != 1) {
                throw new ExceptionBdw("Merged cells wrong! cel #/# " + mcelIdx + "/" + mcelPrevIdx);
            }
            mcol = pTbl.getItsColumns().get(mcolIdx);
            if (!(pCel.getIsMergedVertically() || EWraping.WRAP_CONTENT.equals((Object)mcol.getWraping()) || mcol.getIsWidthFixed() && !EWraping.FILL_PARENT.equals((Object)mcol.getWraping()))) {
                throw new ExceptionBdw("Merged columns must has wraping or fixed widths! # " + mcolIdx);
            }
            if (pCel.getIsMergedVertically()) {
                row = pTbl.getItsRows().get(mrowIdx);
                row.setIfHasVerticalMerged(true);
            } else {
                mcol.setIfHasHorizontalMerged(true);
            }
            mcel.setIsMerged(true);
            mcel.setMergingCell(pCel);
            pCel.getMergedCells().add(mcel);
        }
        return wasMergedWrapped;
    }

    public final void evalWrappedMergedColumnsWidth(DocTable<WI> pTbl, TableCell pCel, TableColumn pCol, double pWidth) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        double wrappedWidths = pCol.getWidth();
        double fixedWidths = 0.0;
        int wrapingCount = 1;
        for (TableCell mcel : pCel.getMergedCells()) {
            int mcelIdx = pTbl.getItsCells().indexOf(mcel);
            int mcolIdx = (mcelIdx + colCnt) % colCnt;
            TableColumn mcol = pTbl.getItsColumns().get(mcolIdx);
            if (EWraping.WRAP_CONTENT.equals((Object)mcol.getWraping())) {
                ++wrapingCount;
                wrappedWidths += mcol.getWidth();
                continue;
            }
            fixedWidths += mcol.getWidth();
        }
        if (fixedWidths + wrappedWidths < pWidth) {
            if (wrapingCount == 1) {
                if (pCol.getWidth() < pWidth) {
                    pCol.setWidth(pWidth);
                }
            } else {
                double awd = (pWidth - fixedWidths) / (double)wrapingCount;
                double wrapedWidthNonCorrected = 0.0;
                int wrapingNonCorrectedCount = 0;
                for (TableCell mcel : pCel.getMergedCells()) {
                    int mcelIdx = pTbl.getItsCells().indexOf(mcel);
                    int mcolIdx = (mcelIdx + colCnt) % colCnt;
                    TableColumn mcol = pTbl.getItsColumns().get(mcolIdx);
                    if (!EWraping.WRAP_CONTENT.equals((Object)mcol.getWraping())) continue;
                    if (mcol.getWidth() < awd) {
                        mcol.setWidth(mcol.getWidth() + awd);
                        continue;
                    }
                    awd = (pWidth - fixedWidths - (wrapedWidthNonCorrected += awd)) / (double)(wrapingCount - ++wrapingNonCorrectedCount);
                }
            }
        }
    }

    public final void evalWrappedMergedContentSize(DocTable<WI> pTbl) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        int colIdx = 0;
        int rowIdx = 0;
        TableRow row = null;
        for (TableCell cel : pTbl.getItsCells()) {
            TableColumn col = pTbl.getItsColumns().get(colIdx);
            if (!cel.getIsMerged() && cel.getMergedCell() != null && EWraping.WRAP_CONTENT.equals((Object)col.getWraping())) {
                if (row == null) {
                    row = pTbl.getItsRows().get(rowIdx);
                }
                double borderWd = colIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                double borderHt = rowIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                double wd = col.getPaddingLeft() + cel.getMetricsString().getWidth() + col.getPaddingRight() + borderWd;
                double ht = row.getPaddingTop() + cel.getMetricsString().getHeight() + row.getPaddingBottom() + borderHt;
                if (!cel.getIsMergedVertically()) {
                    if (row.getHeight() < ht) {
                        row.setHeight(ht);
                    }
                    this.evalWrappedMergedColumnsWidth(pTbl, cel, col, wd + col.getBorder() * (double)cel.getMergedCells().size());
                } else if (col.getWidth() < wd) {
                    col.setWidth(wd);
                }
            }
            if (++colIdx != colCnt) continue;
            colIdx = 0;
            ++rowIdx;
            row = null;
        }
    }

    public final void evalWrappedContentSize(DocTable<WI> pTbl, double pMaxWidth) throws Exception {
        int colCnt = pTbl.getItsColumns().size();
        int rowIdx = 0;
        int colIdx = 0;
        int celIdx = 0;
        TableRow row = null;
        boolean wasMergedWrapped = false;
        for (TableCell cel : pTbl.getItsCells()) {
            if (!cel.getIsMerged()) {
                MetricsString ms;
                String fntNm;
                TableColumn col = pTbl.getItsColumns().get(colIdx);
                if (row == null) {
                    row = pTbl.getItsRows().get(rowIdx);
                }
                double borderWd = colIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                double borderHt = rowIdx == 0 ? col.getBorder() * 2.0 : col.getBorder();
                if (cel.getMergedCell() != null) {
                    if (EWraping.WRAP_CONTENT.equals((Object)col.getWraping())) {
                        fntNm = pTbl.getDocument().getFonts().get(cel.getFontNumber() - 1).getItsName();
                        ms = this.evalMetricsString.eval(cel.getItsContent(), fntNm, cel.getFontSize(), pMaxWidth, 0.0);
                        cel.setMetricsString(ms);
                    }
                    if (!wasMergedWrapped) {
                        wasMergedWrapped = this.evalMergedCells(pTbl, cel, col, celIdx, rowIdx, colIdx);
                    } else {
                        this.evalMergedCells(pTbl, cel, col, celIdx, rowIdx, colIdx);
                    }
                } else {
                    if (EWraping.WRAP_CONTENT.equals((Object)pTbl.getWraping()) && EWraping.FILL_PARENT.equals((Object)col.getWraping())) {
                        throw new ExceptionBdw("Column fill for wrapping parent! # " + colIdx);
                    }
                    if (EWraping.WRAP_CONTENT.equals((Object)col.getWraping()) && col.getIsWidthFixed()) {
                        throw new ExceptionBdw("Column has wraping and fixed widths! # " + colIdx);
                    }
                    if (EWraping.WRAP_CONTENT.equals((Object)col.getWraping())) {
                        fntNm = pTbl.getDocument().getFonts().get(cel.getFontNumber() - 1).getItsName();
                        ms = this.evalMetricsString.eval(cel.getItsContent(), fntNm, cel.getFontSize(), pMaxWidth, 0.0);
                        cel.setMetricsString(ms);
                        double wd = col.getPaddingLeft() + ms.getWidth() + col.getPaddingRight() + borderWd;
                        if (col.getWidth() < wd) {
                            col.setWidth(wd);
                        }
                        double ht = row.getPaddingTop() + ms.getHeight() + row.getPaddingBottom() + borderHt;
                        if (row.getHeight() < ht) {
                            row.setHeight(ht);
                        }
                    }
                }
            }
            ++celIdx;
            if (++colIdx != colCnt) continue;
            colIdx = 0;
            ++rowIdx;
            row = null;
        }
        if (wasMergedWrapped) {
            this.evalWrappedMergedContentSize(pTbl);
        }
    }

    public final void evalWidthPosForTableAndRows(DocTable<WI> pTbl) throws Exception {
        int idxTbl;
        IDocContainer prnt = pTbl.getParent();
        IDocContainer prev = null;
        if (prnt == null && (idxTbl = pTbl.getDocument().getDerivingElementsList().indexOf(pTbl)) > 0) {
            for (int i = idxTbl - 1; i >= 0; --i) {
                if (!pTbl.getDocument().getDerivingElementsList().get(i).getIsAffectedOnOtherPositions()) continue;
                prev = pTbl.getDocument().getDerivingElementsList().get(i);
                break;
            }
        }
        if (!pTbl.getIsY1Fixed()) {
            if (prnt != null) {
                pTbl.setY1(prnt.getY2() + prnt.getPaddingBottom() + pTbl.getMarginTop());
            } else if (prev != null) {
                pTbl.setY1(prev.getY2() + prev.getMarginBottom() + pTbl.getMarginTop());
            } else {
                pTbl.setY1(pTbl.getStartPage().getMarginTop() + pTbl.getMarginTop());
            }
        }
        double parentWd = prnt != null ? prnt.getX2() - prnt.getX1() - prnt.getPaddingLeft() - prnt.getPaddingRight() - pTbl.getMarginLeft() - pTbl.getMarginRight() - prnt.getBorder() * 2.0 : pTbl.getStartPage().getWidth() - pTbl.getStartPage().getMarginLeft() - pTbl.getStartPage().getMarginRight() - pTbl.getMarginLeft() - pTbl.getMarginRight();
        if (EWraping.WRAP_CONTENT.equals((Object)pTbl.getWraping())) {
            double maxWd = prnt != null ? prnt.getWidth() : pTbl.getStartPage().getWidth() - pTbl.getStartPage().getMarginLeft() - pTbl.getStartPage().getMarginRight();
            if (maxWd < pTbl.getStartPage().getWidth() / 40.0) {
                throw new ExceptionBdw("Can't evaluate table max width!!!");
            }
            this.evalWrappedContentSize(pTbl, maxWd);
            double tblWd = 0.0;
            for (TableColumn col : pTbl.getItsColumns()) {
                tblWd += col.getWidth();
            }
            pTbl.setWidth(tblWd);
        } else if (EWraping.FILL_PARENT.equals((Object)pTbl.getWraping())) {
            double wdprc;
            if (pTbl.getIsWidthFixed()) {
                if (pTbl.getWidthInPercentage() > 100.0 || pTbl.getWidthInPercentage() < 3.0) {
                    throw new ExceptionBdw("Wrong fixed width %!!!: " + pTbl.getWidthInPercentage());
                }
                wdprc = pTbl.getWidthInPercentage();
            } else {
                wdprc = 100.0;
            }
            pTbl.setWidth(parentWd * wdprc / 100.0);
            this.evalWrappedContentSize(pTbl, pTbl.getWidth());
        } else if (pTbl.getIsWidthFixed()) {
            if (pTbl.getWidth() > parentWd || pTbl.getWidth() < parentWd * 0.1) {
                throw new ExceptionBdw("Wrong fixed width!!!: wd/parent wd " + pTbl.getWidth() + "/" + parentWd);
            }
            this.evalWrappedContentSize(pTbl, pTbl.getWidth());
        } else {
            throw new ExceptionBdw("Wrong table width data!!!");
        }
        if (!pTbl.getIsX1Fixed() && !pTbl.getIsX2Fixed()) {
            if (EAlignHorizontal.CENTER.equals((Object)pTbl.getAlignHorizontal())) {
                double sp = (parentWd - pTbl.getWidth()) / 2.0;
                if (prnt != null) {
                    pTbl.setX1(prnt.getX1() + prnt.getPaddingLeft() + prnt.getBorder() + pTbl.getMarginLeft() + sp);
                } else {
                    pTbl.setX1(pTbl.getStartPage().getMarginLeft() + pTbl.getMarginLeft() + sp);
                }
                pTbl.setX2(pTbl.getX1() + pTbl.getWidth());
            } else if (EAlignHorizontal.LEFT.equals((Object)pTbl.getAlignHorizontal())) {
                if (prnt != null) {
                    pTbl.setX1(prnt.getX1() + prnt.getPaddingLeft() + prnt.getBorder() + pTbl.getMarginLeft());
                } else {
                    pTbl.setX1(pTbl.getStartPage().getMarginLeft() + pTbl.getMarginLeft());
                }
                pTbl.setX2(pTbl.getX1() + pTbl.getWidth());
            } else if (EAlignHorizontal.RIGHT.equals((Object)pTbl.getAlignHorizontal())) {
                if (prnt != null) {
                    pTbl.setX2(prnt.getX2() - prnt.getPaddingRight() - prnt.getBorder() - pTbl.getMarginRight());
                } else {
                    pTbl.setX2(pTbl.getStartPage().getWidth() - pTbl.getStartPage().getMarginRight() - pTbl.getMarginRight());
                }
                pTbl.setX1(pTbl.getX2() - pTbl.getWidth());
            }
        } else if (!pTbl.getIsX1Fixed() && pTbl.getIsX2Fixed()) {
            pTbl.setX1(pTbl.getX2() - pTbl.getWidth());
        } else if (pTbl.getIsX1Fixed() && !pTbl.getIsX2Fixed()) {
            pTbl.setX2(pTbl.getX1() + pTbl.getWidth());
        } else if (pTbl.getWidth() - pTbl.getX2() + pTbl.getX1() < 1.0E-5) {
            throw new ExceptionBdw("Wrong table fixed width, X1, X2: " + pTbl.getWidth() + ", " + pTbl.getX1() + ", " + pTbl.getX2());
        }
        for (TableRow row : pTbl.getItsRows()) {
            row.setX1(pTbl.getX1());
            row.setX2(pTbl.getX2());
            row.setWidth(pTbl.getWidth());
        }
    }

    public final IFctElement<WI> getElementFactory() {
        return this.elementFactory;
    }

    public final void setElementFactory(IFctElement<WI> pElementFactory) {
        this.elementFactory = pElementFactory;
    }

    public final IDocumentMaker<WI> getDocumentMaker() {
        return this.documentMaker;
    }

    public final void setDocumentMaker(IDocumentMaker<WI> pDocumentMaker) {
        this.documentMaker = pDocumentMaker;
    }

    public final IEvalMetricsString getEvalMetricsString() {
        return this.evalMetricsString;
    }

    public final void setEvalMetricsString(IEvalMetricsString pEvalMetricsString) {
        this.evalMetricsString = pEvalMetricsString;
    }
}

