/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.log.ILogger;

public abstract class ALogger
implements ILogger {
    private String lineSeparator = System.getProperty("line.separator");
    private boolean isShowDebugMessage = false;
    private Map<Class<?>, Boolean> isShowDebugMessageMap;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private Map<String, Object> clientPreferences;
    private int detailLevel = 0;

    @Override
    public final int getDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public final void setDetailLevel(int pDetailLevel) {
        this.detailLevel = pDetailLevel;
    }

    @Override
    public final void setIsShowDebugMessages(boolean pIsShowDebugMessage) {
        this.isShowDebugMessage = pIsShowDebugMessage;
    }

    @Override
    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessage;
    }

    @Override
    public final void setIsShowDebugMessagesFor(Class<?> pClazz, boolean pIsShowDebugMessage) {
        if (this.isShowDebugMessageMap == null) {
            this.isShowDebugMessageMap = new HashMap();
        }
        this.isShowDebugMessageMap.put(pClazz, pIsShowDebugMessage);
    }

    @Override
    public final boolean getIsShowDebugMessagesFor(Class<?> pClazz) {
        Boolean result = null;
        if (this.isShowDebugMessageMap != null) {
            result = this.isShowDebugMessageMap.get(pClazz);
        }
        if (result == null) {
            return this.isShowDebugMessage;
        }
        return result;
    }

    @Override
    public final Map<String, Object> getClientPreferences() {
        return this.clientPreferences;
    }

    @Override
    public final void setClientPreferences(Map<String, Object> pClientPreferences) {
        this.clientPreferences = pClientPreferences;
    }

    public final void exceptionToString(StringBuffer pBuffer, Throwable pThrown) {
        if (pThrown == null) {
            pBuffer.append(" ex-null");
        } else {
            pBuffer.append(pThrown.toString());
            StackTraceElement[] elements = pThrown.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                pBuffer.append(this.lineSeparator + "\tat ");
                pBuffer.append(elements[i].toString());
            }
            for (Throwable suppressed : pThrown.getSuppressed()) {
                pBuffer.append(this.lineSeparator + "Suppressed: ");
                pBuffer.append(suppressed.toString() + "\t|");
            }
            Throwable cause = pThrown.getCause();
            if (cause != null && cause != pThrown) {
                this.exceptionToStringNext(pBuffer, cause);
            }
        }
        pBuffer.append(this.lineSeparator);
    }

    private void exceptionToStringNext(StringBuffer pBuffer, Throwable pCause) {
        pBuffer.append(this.lineSeparator).append("Caused by: ");
        pBuffer.append(pCause);
        StackTraceElement[] elements = pCause.getStackTrace();
        for (int i = 0; elements != null && i < elements.length; ++i) {
            pBuffer.append(this.lineSeparator + "\tat ");
            pBuffer.append(elements[i].toString());
        }
        for (Throwable suppressed : pCause.getSuppressed()) {
            pBuffer.append(this.lineSeparator + "Suppressed: ");
            pBuffer.append(suppressed.toString() + "\t|");
        }
        Throwable causeNext = pCause.getCause();
        if (causeNext != null && causeNext != pCause) {
            this.exceptionToStringNext(pBuffer, causeNext);
        }
    }

    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    public final void setLineSeparator(String pLineSeparator) {
        this.lineSeparator = pLineSeparator;
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat pDateFormat) {
        this.dateFormat = pDateFormat;
    }

    public final Map<Class<?>, Boolean> getIsShowDebugMessageMap() {
        return this.isShowDebugMessageMap;
    }

    public final void setIsShowDebugMessageMap(Map<Class<?>, Boolean> pIsShowDebugMessageMap) {
        this.isShowDebugMessageMap = pIsShowDebugMessageMap;
    }
}

