/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.converter.IConverter;
import org.beigesoft.converter.IConverterIntoByName;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.orm.model.ETypeField;
import org.beigesoft.orm.model.FieldSql;
import org.beigesoft.orm.model.TableSql;

public class CnvObjectToColumnsValues<T>
implements IConverter<T, ColumnsValues> {
    private ILogger logger;
    private Map<String, TableSql> tablesMap;
    private IFactoryAppBeansByName<IConverterIntoByName<?, ColumnsValues>> fieldsConvertersFatory;
    private IHolderForClassByName<String> fieldsConvertersNamesHolder;
    private Class<T> objectClass;
    private IHolderForClassByName<Field> fieldsRapiHolder;
    private IHolderForClassByName<Method> gettersRapiHolder;

    @Override
    public final ColumnsValues convert(Map<String, Object> pAddParam, T pObject) throws Exception {
        ColumnsValues result = new ColumnsValues();
        TableSql tableSql = this.tablesMap.get(this.objectClass.getSimpleName());
        result.setIdColumnsNames(tableSql.getIdColumnsNames());
        if (pAddParam.get("isOnlyId") != null) {
            if (tableSql.getIdColumnsNames().length > 0 && tableSql.getFieldsMap().get(tableSql.getIdColumnsNames()[0]).getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE)) {
                for (Map.Entry<String, FieldSql> entry : tableSql.getFieldsMap().entrySet()) {
                    if (!entry.getValue().getTypeField().equals((Object)ETypeField.COMPOSITE_FK_PK)) continue;
                    this.convertField(pAddParam, entry.getKey(), pObject, true, result, tableSql);
                    break;
                }
            } else {
                for (String idFldNm : tableSql.getIdColumnsNames()) {
                    this.convertField(pAddParam, idFldNm, pObject, true, result, tableSql);
                }
            }
        } else if (pAddParam.get("fieldsNames") != null) {
            String[] fieldsNames;
            for (String fldNm : fieldsNames = (String[])pAddParam.get("fieldsNames")) {
                this.convertField(pAddParam, fldNm, pObject, false, result, tableSql);
            }
        } else {
            for (Map.Entry<String, FieldSql> entry : tableSql.getFieldsMap().entrySet()) {
                if (entry.getValue().getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE)) continue;
                this.convertField(pAddParam, entry.getKey(), pObject, false, result, tableSql);
            }
        }
        return result;
    }

    public final void convertField(Map<String, Object> pAddParam, String pFieldName, T pObject, boolean pIsItId, ColumnsValues pResult, TableSql pTableSql) throws Exception {
        Map<String, Object> addParam;
        Method getter = this.gettersRapiHolder.getFor(this.objectClass, pFieldName);
        Object fieldVal = getter.invoke(pObject, new Object[0]);
        boolean isShowDbMsg = this.logger.getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.logger.getDetailLevel();
        if (fieldVal == null) {
            boolean isPk = false;
            if (pIsItId) {
                isPk = true;
            }
            if (pTableSql.getFieldsMap().get(pFieldName).getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE)) {
                isPk = true;
            }
            for (String idFldNm : pTableSql.getIdColumnsNames()) {
                if (!idFldNm.equals(pFieldName)) continue;
                isPk = true;
                break;
            }
            if (isPk && isShowDbMsg) {
                this.getLogger().debug(null, CnvObjectToColumnsValues.class, "PK is null for CV field/object - " + pFieldName + "/" + pObject);
                return;
            }
        }
        if ((addParam = pAddParam) == null) {
            addParam = new HashMap<String, Object>();
        }
        Field field = this.fieldsRapiHolder.getFor(this.objectClass, pFieldName);
        addParam.put("fromClass", field.getType());
        String cnvrtName = this.fieldsConvertersNamesHolder.getFor(this.objectClass, pFieldName);
        if (isShowDbMsg && dbgDetLev > 32000) {
            this.getLogger().debug(null, CnvObjectToColumnsValues.class, "Attempt to convert into CV field/type/value/converter - " + pFieldName + "/" + field.getType().getSimpleName() + "/" + fieldVal + "/" + cnvrtName);
        }
        IConverterIntoByName<?, ColumnsValues> confFld = this.fieldsConvertersFatory.lazyGet(null, cnvrtName);
        confFld.convert(addParam, fieldVal, pResult, pFieldName);
        addParam.remove("fromClass");
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final Map<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final void setTablesMap(Map<String, TableSql> pTablesMap) {
        this.tablesMap = pTablesMap;
    }

    public final IFactoryAppBeansByName<IConverterIntoByName<?, ColumnsValues>> getFieldsConvertersFatory() {
        return this.fieldsConvertersFatory;
    }

    public final void setFieldsConvertersFatory(IFactoryAppBeansByName<IConverterIntoByName<?, ColumnsValues>> pFieldsConvertersFatory) {
        this.fieldsConvertersFatory = pFieldsConvertersFatory;
    }

    public final IHolderForClassByName<String> getFieldsConvertersNamesHolder() {
        return this.fieldsConvertersNamesHolder;
    }

    public final void setFieldsConvertersNamesHolder(IHolderForClassByName<String> pFieldsConvertersNamesHolder) {
        this.fieldsConvertersNamesHolder = pFieldsConvertersNamesHolder;
    }

    public final IHolderForClassByName<Field> getFieldsRapiHolder() {
        return this.fieldsRapiHolder;
    }

    public final void setFieldsRapiHolder(IHolderForClassByName<Field> pFieldsRapiHolder) {
        this.fieldsRapiHolder = pFieldsRapiHolder;
    }

    public final Class<T> getObjectClass() {
        return this.objectClass;
    }

    public final void setObjectClass(Class<T> pObjectClass) {
        this.objectClass = pObjectClass;
    }

    public final IHolderForClassByName<Method> getGettersRapiHolder() {
        return this.gettersRapiHolder;
    }

    public final void setGettersRapiHolder(IHolderForClassByName<Method> pGettersRapiHolder) {
        this.gettersRapiHolder = pGettersRapiHolder;
    }
}

