/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.converter.IConverter;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.orm.model.ETypeField;
import org.beigesoft.orm.model.FieldSql;
import org.beigesoft.orm.model.PropertiesBase;
import org.beigesoft.orm.model.TableSql;
import org.beigesoft.persistable.DatabaseInfo;
import org.beigesoft.service.HlpInsertUpdate;
import org.beigesoft.service.IFillerObjectFields;
import org.beigesoft.service.IFillerObjectsFrom;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.service.IUtlReflection;
import org.beigesoft.settings.IMngSettings;

public abstract class ASrvOrm<RS>
implements ISrvOrm<RS> {
    public static final String ORM_PROP_DIRECTORY = "beige-orm";
    public static final String TABLE_EXISTENCE_QUERY_FILE_NAME = "checkTableExist.sql";
    public static final String TABLE_PARAM_NAME_IN_EXISTENCE_QUERY = ":tableName";
    public static final String WORD_CURRENT_DIR = "#currentDir#";
    public static final String WORD_CURRENT_PARENT_DIR = "#currentParentDir#";
    public static final Integer VERSION_ALG_INCREMENT = 0;
    public static final Integer VERSION_ALG_CHANGED_TIME = 1;
    private ILogger logger;
    private IMngSettings mngSettings;
    private PropertiesBase propertiesBase;
    private LinkedHashMap<String, TableSql> tablesMap = new LinkedHashMap();
    private IUtlReflection utlReflection;
    private ISrvDatabase<RS> srvDatabase;
    private HlpInsertUpdate hlpInsertUpdate;
    private IFactoryAppBeansByClass<IConverter<?, ColumnsValues>> factoryCnvEntityToColumnsValues;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;
    private IFillerObjectsFrom<IRecordSet<RS>> fillerEntitiesFromRs;
    private IFactoryAppBeansByClass<IFillerObjectFields<?>> fctFillersObjectFields;
    private int newDatabaseId = 1;

    @Override
    public final int getNewDatabaseId() {
        return this.newDatabaseId;
    }

    @Override
    public final void setNewDatabaseId(int pNewDatabaseId) {
        this.newDatabaseId = pNewDatabaseId;
    }

    @Override
    public final <T> T retrieveEntity(Map<String, Object> pAddParam, T pEntity) throws Exception {
        String query = this.evalSqlSelect(pAddParam, pEntity.getClass());
        pAddParam.put("isOnlyId", Boolean.TRUE);
        ColumnsValues columnsValues = this.evalColumnsValues(pAddParam, pEntity);
        pAddParam.remove("isOnlyId");
        String whereStr = this.evalWhereId(pEntity, columnsValues);
        Class<?> entityClass = pEntity.getClass();
        return (T)this.retrieveEntity(pAddParam, entityClass, query + " where " + whereStr);
    }

    @Override
    public final <T> T retrieveEntityById(Map<String, Object> pAddParam, Class<T> pEntityClass, Object pItsId) throws Exception {
        String query = this.evalSqlSelect(pAddParam, pEntityClass);
        IFactorySimple<?> facEn = this.entitiesFactoriesFatory.lazyGet(pAddParam, pEntityClass);
        Object entity = facEn.create(pAddParam);
        IFillerObjectFields<?> filler = this.fctFillersObjectFields.lazyGet(pAddParam, pEntityClass);
        String idFldName = this.tablesMap.get(pEntityClass.getSimpleName()).getIdFieldName();
        filler.fill(pAddParam, entity, pItsId, idFldName);
        pAddParam.put("isOnlyId", Boolean.TRUE);
        ColumnsValues columnsValues = this.evalColumnsValues(pAddParam, entity);
        pAddParam.remove("isOnlyId");
        String whereId = this.evalWhereId(entity, columnsValues);
        return this.retrieveEntity(pAddParam, pEntityClass, query + " where " + whereId + ";\n");
    }

    @Override
    public final <T> T retrieveEntityWithConditions(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQueryConditions) throws Exception {
        if (pQueryConditions == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        String query = this.evalSqlSelect(pAddParam, pEntityClass);
        return this.retrieveEntity(pAddParam, pEntityClass, query + " " + pQueryConditions + ";\n");
    }

    @Override
    public final <T> void updateEntity(Map<String, Object> pAddParam, T pEntity) throws Exception {
        ColumnsValues columnsValues = this.evalColumnsValues(pAddParam, pEntity);
        String whereStr = this.evalWhereForUpdate(pEntity, columnsValues);
        this.prepareColumnValuesForUpdate(columnsValues, pEntity);
        int result = this.getSrvDatabase().executeUpdate(pEntity.getClass().getSimpleName().toUpperCase(), columnsValues, whereStr);
        if (result != 1) {
            if (result == 0 && columnsValues.ifContains("itsVersion")) {
                throw new ExceptionWithCode(1151, "dirty_read");
            }
            String query = this.hlpInsertUpdate.evalSqlUpdate(pEntity.getClass().getSimpleName().toUpperCase(), columnsValues, whereStr);
            throw new ExceptionWithCode(1152, "It should be 1 row updated but it was " + result + ", query:\n" + query);
        }
    }

    @Override
    public final <T> void deleteEntityWhere(Map<String, Object> pAddParam, Class<T> pEntityClass, String pWhere) throws Exception {
        if (pWhere == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        this.getSrvDatabase().executeDelete(pEntityClass.getSimpleName().toUpperCase(), pWhere);
    }

    @Override
    public final <T> void deleteEntity(Map<String, Object> pAddParam, T pEntity) throws Exception {
        pAddParam.put("isOnlyId", Boolean.TRUE);
        ColumnsValues columnsValues = this.evalColumnsValues(pAddParam, pEntity);
        pAddParam.remove("isOnlyId");
        String whereId = this.evalWhereId(pEntity, columnsValues);
        this.getSrvDatabase().executeDelete(pEntity.getClass().getSimpleName().toUpperCase(), whereId);
    }

    @Override
    public final <T> List<T> retrieveList(Map<String, Object> pAddParam, Class<T> pEntityClass) throws Exception {
        String query = this.evalSqlSelect(pAddParam, pEntityClass) + ";\n";
        return this.retrieveListByQuery(pAddParam, pEntityClass, query);
    }

    @Override
    public final <T> List<T> retrieveListWithConditions(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQueryConditions) throws Exception {
        if (pQueryConditions == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        String query = this.evalSqlSelect(pAddParam, pEntityClass) + " " + pQueryConditions + ";\n";
        return this.retrieveListByQuery(pAddParam, pEntityClass, query);
    }

    @Override
    public final <T> List<T> retrieveListForField(Map<String, Object> pAddParam, T pEntity, String pFieldFor) throws Exception {
        String whereStr = this.evalWhereForField(pAddParam, pEntity, pFieldFor);
        String query = this.evalSqlSelect(pAddParam, pEntity.getClass()) + whereStr + ";";
        Class<?> entityClass = pEntity.getClass();
        return this.retrieveListByQuery(pAddParam, entityClass, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> List<T> retrieveListByQuery(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQuery) throws Exception {
        if (pQuery == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        ArrayList<T> result = new ArrayList<T>();
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                do {
                    result.add(this.retrieveEntity(pAddParam, pEntityClass, recordSet));
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    @Override
    public final <T> List<T> retrievePage(Map<String, Object> pAddParam, Class<T> pEntityClass, Integer pFirst, Integer pPageSize) throws Exception {
        String query = this.evalSqlSelect(pAddParam, pEntityClass);
        return this.retrievePageByQuery(pAddParam, pEntityClass, query, pFirst, pPageSize);
    }

    @Override
    public final <T> List<T> retrievePageWithConditions(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQueryConditions, Integer pFirst, Integer pPageSize) throws Exception {
        String query = this.evalSqlSelect(pAddParam, pEntityClass) + " " + pQueryConditions;
        return this.retrievePageByQuery(pAddParam, pEntityClass, query, pFirst, pPageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> List<T> retrievePageByQuery(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQuery, Integer pFirst, Integer pPageSize) throws Exception {
        if (pQuery == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        ArrayList<T> result = new ArrayList<T>();
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(pQuery + " limit " + pPageSize + " offset " + pFirst + ";\n");
            if (recordSet.moveToFirst()) {
                do {
                    result.add(this.retrieveEntity(pAddParam, pEntityClass, recordSet));
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    @Override
    public final <T> Integer evalRowCount(Map<String, Object> pAddParam, Class<T> pEntityClass) throws Exception {
        String query = "select count(*) as TOTALROWS from " + pEntityClass.getSimpleName().toUpperCase() + ";";
        return this.evalRowCountByQuery(pAddParam, pEntityClass, query);
    }

    @Override
    public final <T> Integer evalRowCountWhere(Map<String, Object> pAddParam, Class<T> pEntityClass, String pWhere) throws Exception {
        if (pWhere == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        String query = "select count(*) as TOTALROWS from " + pEntityClass.getSimpleName().toUpperCase() + " where " + pWhere + ";";
        return this.evalRowCountByQuery(pAddParam, pEntityClass, query);
    }

    @Override
    public final <T> Integer evalRowCountByQuery(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQuery) throws Exception {
        if (pQuery == null) {
            throw new ExceptionWithCode(1003, "param_null_not_accepted");
        }
        return this.getSrvDatabase().evalIntegerResult(pQuery, "TOTALROWS");
    }

    @Override
    public final <T> String evalSqlSelect(Map<String, Object> pAddParam, Class<T> pEntityClass) throws Exception {
        String tableName = pEntityClass.getSimpleName().toUpperCase();
        StringBuffer result = new StringBuffer("select ");
        StringBuffer joints = new StringBuffer();
        boolean isFirstField = true;
        TableSql tableSql = this.getTablesMap().get(pEntityClass.getSimpleName());
        if (tableSql == null) {
            throw new ExceptionWithCode(1002, "where_is_no_table_def_for::" + pEntityClass.getSimpleName());
        }
        Set<String> fieldsNames = (Set<String>)pAddParam.get(pEntityClass.getSimpleName() + "neededFields");
        if (fieldsNames == null) {
            fieldsNames = tableSql.getFieldsMap().keySet();
        }
        for (String fieldName : fieldsNames) {
            FieldSql fieldSql = tableSql.getFieldsMap().get(fieldName);
            if (fieldSql.getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE)) continue;
            if (fieldSql.getForeignEntity() == null) {
                if (isFirstField) {
                    isFirstField = false;
                } else {
                    result.append(", ");
                }
                String columnName = fieldName.toUpperCase();
                result.append(tableName + "." + columnName + " as " + columnName);
                continue;
            }
            this.evalForeignSelect(pAddParam, fieldName, fieldSql, result, joints, pEntityClass.getSimpleName(), tableName, isFirstField);
            isFirstField = false;
        }
        result.append(" from " + tableName + joints);
        return result.toString();
    }

    protected final void evalForeignSelect(Map<String, Object> pAddParam, String pFieldName, FieldSql pFieldSql, StringBuffer pQuery, StringBuffer pJoints, String pOwningEntityName, String pOwningTableName, boolean pIsFirstField) throws Exception {
        Integer deepLevelReq;
        String deepLevelNm;
        ArrayList<Integer> deepLevel;
        String currentLevelNm = "currentLevel";
        ArrayList<Integer> currentLevel = (ArrayList<Integer>)pAddParam.get(currentLevelNm);
        if (currentLevel == null) {
            currentLevel = new ArrayList<Integer>();
            currentLevel.add(1);
            pAddParam.put(currentLevelNm, currentLevel);
        }
        if ((deepLevel = (ArrayList<Integer>)pAddParam.get(deepLevelNm = "deepLevel")) == null) {
            deepLevel = new ArrayList<Integer>();
            pAddParam.put(deepLevelNm, deepLevel);
        }
        if ((deepLevelReq = (Integer)pAddParam.get(pOwningEntityName + pFieldName + deepLevelNm)) != null) {
            if (currentLevel.size() == 1 && (Integer)currentLevel.get(0) == 1) {
                if (deepLevel.size() == 1) {
                    deepLevel.set(0, deepLevelReq);
                } else {
                    deepLevel.add(deepLevelReq);
                }
            } else {
                currentLevel.add(1);
                deepLevel.add(deepLevelReq);
            }
        } else if (currentLevel.size() == 1 && (Integer)currentLevel.get(0) == 1) {
            if (deepLevel.size() == 1) {
                deepLevel.set(0, 2);
            } else {
                deepLevel.add(2);
            }
        }
        if (deepLevel.size() != currentLevel.size()) {
            throw new Exception("Algorithm error: deepLevel.size/currentLevel.size/Entity/Field" + deepLevel.size() + "/" + currentLevel.size() + "/" + pOwningEntityName + "/" + pFieldName);
        }
        if ((Integer)currentLevel.get(currentLevel.size() - 1) >= (Integer)deepLevel.get(deepLevel.size() - 1)) {
            String columnName = pFieldName.toUpperCase();
            if (!pIsFirstField) {
                pQuery.append(", ");
            }
            if ((Integer)currentLevel.get(currentLevel.size() - 1) == 1) {
                pQuery.append(pOwningTableName + "." + columnName + " as " + columnName);
            } else {
                pQuery.append(pOwningTableName + "." + columnName + " as " + pOwningTableName + columnName);
            }
        } else {
            String tbFrAlias;
            boolean isFirstField = pIsFirstField;
            TableSql tableSql = this.getTablesMap().get(pFieldSql.getForeignEntity());
            if (tableSql == null) {
                throw new ExceptionWithCode(1002, "where_is_no_table_def_for::" + pFieldSql.getForeignEntity());
            }
            String tableForeign = pFieldSql.getForeignEntity().toUpperCase();
            if (tableSql.getIdColumnsNames().length > 1) {
                StringBuffer sb = new StringBuffer();
                for (String idClNm : tableSql.getIdColumnsNames()) {
                    sb.append(idClNm);
                }
                tbFrAlias = sb.toString().toUpperCase();
            } else {
                tbFrAlias = pFieldName.toUpperCase();
            }
            pJoints.append(" left join " + tableForeign + " as " + tbFrAlias + " on ");
            for (int i = 0; i < tableSql.getIdColumnsNames().length; ++i) {
                if (i > 0) {
                    pJoints.append(" and ");
                }
                String fieldFrNm = tableSql.getIdColumnsNames().length > 1 ? tableSql.getIdColumnsNames()[i].toUpperCase() : pFieldName.toUpperCase();
                pJoints.append(pOwningTableName + "." + fieldFrNm + "=" + tbFrAlias + "." + tableSql.getIdColumnsNames()[i].toUpperCase());
            }
            Set<String> fieldsNames = (Set<String>)pAddParam.get(pFieldSql.getForeignEntity() + "neededFields");
            if (fieldsNames == null) {
                fieldsNames = tableSql.getFieldsMap().keySet();
            }
            for (String fieldName : fieldsNames) {
                FieldSql fieldSql = tableSql.getFieldsMap().get(fieldName);
                if (fieldSql.getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE)) continue;
                if (fieldSql.getForeignEntity() == null) {
                    if (isFirstField) {
                        isFirstField = false;
                    } else {
                        pQuery.append(", ");
                    }
                    pQuery.append(tbFrAlias + "." + fieldName.toUpperCase() + " as " + tbFrAlias + fieldName.toUpperCase());
                    continue;
                }
                currentLevel.set(currentLevel.size() - 1, (Integer)currentLevel.get(currentLevel.size() - 1) + 1);
                this.evalForeignSelect(pAddParam, fieldName, fieldSql, pQuery, pJoints, pFieldSql.getForeignEntity(), tbFrAlias, isFirstField);
                isFirstField = false;
                currentLevel.set(currentLevel.size() - 1, (Integer)currentLevel.get(currentLevel.size() - 1) - 1);
                if (currentLevel.size() <= 1 || (Integer)currentLevel.get(currentLevel.size() - 1) != 1) continue;
                currentLevel.remove(currentLevel.size() - 1);
                deepLevel.remove(deepLevel.size() - 1);
            }
        }
    }

    @Override
    public final int getIdDatabase() {
        return this.srvDatabase.getIdDatabase();
    }

    public final void loadPropertiesBase(String pDirName) throws Exception {
        File fcd;
        this.propertiesBase = new PropertiesBase();
        this.propertiesBase.setDirectory(pDirName);
        this.propertiesBase.setJdbcDriverClass(this.mngSettings.getAppSettings().get("jdbcDriverClass"));
        this.propertiesBase.setDatabaseName(this.mngSettings.getAppSettings().get("databaseName"));
        this.propertiesBase.setDataSourceClassName(this.mngSettings.getAppSettings().get("dataSourceClassName"));
        this.propertiesBase.setUserName(this.mngSettings.getAppSettings().get("userName"));
        this.propertiesBase.setUserPassword(this.mngSettings.getAppSettings().get("userPassword"));
        this.propertiesBase.setDatabaseUrl(this.mngSettings.getAppSettings().get("databaseUrl"));
        String currDir = System.getProperty("user.dir");
        if (this.propertiesBase.getDatabaseName() != null && this.propertiesBase.getDatabaseName().contains(WORD_CURRENT_DIR)) {
            this.propertiesBase.setDatabaseName(this.propertiesBase.getDatabaseName().replace(WORD_CURRENT_DIR, currDir + File.separator));
        } else if (this.propertiesBase.getDatabaseName() != null && this.propertiesBase.getDatabaseName().contains(WORD_CURRENT_PARENT_DIR)) {
            fcd = new File(currDir);
            this.propertiesBase.setDatabaseName(this.propertiesBase.getDatabaseName().replace(WORD_CURRENT_PARENT_DIR, fcd.getParent() + File.separator));
        }
        if (this.propertiesBase.getDatabaseUrl() != null && this.propertiesBase.getDatabaseUrl().contains(WORD_CURRENT_DIR)) {
            this.propertiesBase.setDatabaseUrl(this.propertiesBase.getDatabaseUrl().replace(WORD_CURRENT_DIR, currDir + File.separator));
        } else if (this.propertiesBase.getDatabaseUrl() != null && this.propertiesBase.getDatabaseUrl().contains(WORD_CURRENT_PARENT_DIR)) {
            fcd = new File(currDir);
            this.propertiesBase.setDatabaseUrl(this.propertiesBase.getDatabaseUrl().replace(WORD_CURRENT_PARENT_DIR, fcd.getParent() + File.separator));
        }
    }

    public final void loadSqlTables() throws Exception {
        TableSql tableSql;
        for (Class clazz : this.mngSettings.getClasses()) {
            tableSql = new TableSql();
            this.makeTableSqlFromXml(tableSql, clazz);
            this.tablesMap.put(clazz.getSimpleName(), tableSql);
        }
        for (Class clazz : this.mngSettings.getClasses()) {
            tableSql = this.tablesMap.get(clazz.getSimpleName());
            StringBuffer sbIdNamesUc = new StringBuffer("");
            for (int i = 0; i < tableSql.getIdColumnsNames().length; ++i) {
                if (i > 0) {
                    sbIdNamesUc.append(",");
                }
                sbIdNamesUc.append(tableSql.getIdColumnsNames()[i].toUpperCase());
            }
            Field[] fields = this.getUtlReflection().retrieveFields(clazz);
            for (Field field : fields) {
                FieldSql fieldSql = tableSql.getFieldsMap().get(field.getName());
                if (fieldSql == null) continue;
                String fldTypeSmpNm = field.getType().getSimpleName();
                try {
                    TableSql tableSqlForeign = this.tablesMap.get(fldTypeSmpNm);
                    if (tableSqlForeign != null) {
                        String hashCfesn;
                        int hc;
                        String fkNames;
                        fieldSql.setForeignEntity(fldTypeSmpNm);
                        String isNullableStr = this.mngSettings.getFieldsSettings().get(clazz).get(field.getName()).get("isNullable");
                        if (fieldSql.getDefinition() != null && !Boolean.valueOf(isNullableStr).booleanValue() && !fieldSql.getDefinition().contains("not null")) {
                            fieldSql.setDefinition(fieldSql.getDefinition() + " not null");
                        }
                        StringBuffer sbForeignIdNamesUc = new StringBuffer("");
                        for (int i = 0; i < tableSqlForeign.getIdColumnsNames().length; ++i) {
                            if (i > 0) {
                                sbForeignIdNamesUc.append(",");
                            }
                            sbForeignIdNamesUc.append(tableSqlForeign.getIdColumnsNames()[i].toUpperCase());
                        }
                        if (tableSqlForeign.getIdColumnsNames().length > 1) {
                            fkNames = sbForeignIdNamesUc.toString();
                            boolean isAlsoPk = true;
                            if (tableSql.getIdColumnsNames().length == tableSqlForeign.getIdColumnsNames().length) {
                                for (int i = 0; i < tableSql.getIdColumnsNames().length; ++i) {
                                    if (tableSqlForeign.getIdColumnsNames()[0].equals(tableSql.getIdColumnsNames()[0])) continue;
                                    isAlsoPk = false;
                                    break;
                                }
                            }
                            if (isAlsoPk) {
                                fieldSql.setTypeField(ETypeField.COMPOSITE_FK_PK);
                            } else {
                                fieldSql.setTypeField(ETypeField.COMPOSITE_FK);
                            }
                            for (String cIdNm : tableSqlForeign.getIdColumnsNames()) {
                                FieldSql fldCid = new FieldSql();
                                fldCid.setTypeField(ETypeField.DERIVED_FROM_COMPOSITE);
                                if (!Boolean.valueOf(isNullableStr).booleanValue() && !tableSqlForeign.getFieldsMap().get(cIdNm).getDefinition().contains("not null")) {
                                    fldCid.setDefinition(tableSqlForeign.getFieldsMap().get(cIdNm).getDefinition() + " not null");
                                } else if (Boolean.valueOf(isNullableStr).booleanValue() && fldCid.getDefinition().contains("not null")) {
                                    fldCid.setDefinition(tableSqlForeign.getFieldsMap().get(cIdNm).getDefinition().replace(" not null", ""));
                                } else {
                                    fldCid.setDefinition(tableSqlForeign.getFieldsMap().get(cIdNm).getDefinition());
                                }
                                fldCid.setForeignEntity(tableSqlForeign.getFieldsMap().get(cIdNm).getForeignEntity());
                                tableSql.getFieldsMap().put(cIdNm, fldCid);
                            }
                        } else {
                            fkNames = field.getName().toUpperCase();
                            if (fieldSql.getDefinition() == null) {
                                throw new ExceptionWithCode(1002, "Where is no definition FID class/name: " + clazz.getSimpleName() + "/" + field.getName());
                            }
                        }
                        if ((hc = fldTypeSmpNm.hashCode()) < 0) {
                            hc = -hc;
                            hashCfesn = "M" + hc;
                        } else {
                            hashCfesn = String.valueOf(hc);
                        }
                        String constraintFk = "constraint fk" + clazz.getSimpleName() + hashCfesn + field.getName() + " foreign key (" + fkNames + ") references " + fldTypeSmpNm.toUpperCase() + " (" + sbForeignIdNamesUc + ")";
                        String constraint = tableSql.getConstraint();
                        constraint = constraint != null ? constraint + ",\n" + constraintFk : constraintFk;
                        tableSql.setConstraint(constraint);
                    }
                    if (!sbIdNamesUc.toString().contains(field.getName().toUpperCase()) || fieldSql.getDefinition().contains("not null")) continue;
                    fieldSql.setDefinition(fieldSql.getDefinition() + " not null");
                }
                catch (Exception e) {
                    this.logger.error(null, ASrvOrm.class, "Error on load SQL tables: class/field/fieldSql/tableSql - " + clazz.getSimpleName() + "/" + field.getName() + "/" + fieldSql + "/" + tableSql);
                    throw e;
                }
            }
            try {
                String constraintAdd;
                for (String colIdNm : tableSql.getIdColumnsNames()) {
                    if (tableSql.getFieldsMap().get(colIdNm) != null) continue;
                    throw new ExceptionWithCode(1002, "Where is no column ID class/name: " + clazz.getSimpleName() + "/" + (String)colIdNm);
                }
                if (tableSql.getIdColumnsNames().length > 1 || tableSql.getFieldsMap().get(tableSql.getIdColumnsNames()[0]).getForeignEntity() != null) {
                    String constraintPk = "constraint pk" + clazz.getSimpleName() + tableSql.getIdColumnsNames()[0] + " primary key (" + sbIdNamesUc + ")";
                    if (tableSql.getConstraint() == null) {
                        tableSql.setConstraint(constraintPk);
                    } else {
                        tableSql.setConstraint(constraintPk + ",\n" + tableSql.getConstraint());
                    }
                }
                if ((constraintAdd = this.mngSettings.getClassesSettings().get(clazz).get("constraintAdd")) == null) continue;
                if (tableSql.getConstraint() == null) {
                    tableSql.setConstraint(constraintAdd);
                    continue;
                }
                tableSql.setConstraint(tableSql.getConstraint() + ",\n" + constraintAdd);
            }
            catch (Exception e) {
                this.logger.error(null, ASrvOrm.class, "Error on load SQL tables: class/tableSql - " + clazz.getSimpleName() + "/" + tableSql);
                throw e;
            }
        }
    }

    public final void makeTableSqlFromXml(TableSql pTableSql, Class<?> pClazz) throws Exception {
        Field[] fields;
        if (this.mngSettings.getFieldsSettings().get(pClazz) == null) {
            throw new ExceptionWithCode(1002, "There is no fields settings for class " + pClazz);
        }
        pTableSql.setVersionAlgorithm(Integer.parseInt(this.mngSettings.getClassesSettings().get(pClazz).get("versionAlgorithm")));
        pTableSql.setIdColumnsNames(this.mngSettings.getClassesSettings().get(pClazz).get("idColumnsNames").split(","));
        pTableSql.setIdFieldName(this.mngSettings.getClassesSettings().get(pClazz).get("idFieldName"));
        if (pTableSql.getIdFieldName() == null) {
            throw new ExceptionWithCode(1002, "Where is no field ID name for class: " + pClazz.getSimpleName());
        }
        pTableSql.setOwnerFieldName(this.mngSettings.getClassesSettings().get(pClazz).get("ownerFieldName"));
        for (Field field : fields = this.getUtlReflection().retrieveFields(pClazz)) {
            String isNullableStr;
            if (this.mngSettings.getFieldsSettings().get(pClazz).get(field.getName()) == null) continue;
            FieldSql fieldSql = new FieldSql();
            String definition = this.mngSettings.getFieldsSettings().get(pClazz).get(field.getName()).get("definition");
            if (definition != null && !Boolean.valueOf(isNullableStr = this.mngSettings.getFieldsSettings().get(pClazz).get(field.getName()).get("isNullable")).booleanValue() && !definition.contains("not null")) {
                definition = definition + " not null";
            }
            fieldSql.setDefinition(definition);
            pTableSql.getFieldsMap().put(field.getName(), fieldSql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T retrieveEntity(Map<String, Object> pAddParam, Class<T> pEntityClass, String pQuery) throws Exception {
        T entity = null;
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(pQuery);
            if (recordSet.moveToFirst()) {
                entity = this.retrieveEntity(pAddParam, pEntityClass, recordSet);
            }
        }
        return entity;
    }

    public final <T> T retrieveEntity(Map<String, Object> pAddParam, Class<T> pEntityClass, IRecordSet<RS> pRecordSet) throws Exception {
        IFactorySimple<?> facEn = this.entitiesFactoriesFatory.lazyGet(pAddParam, pEntityClass);
        Object entity = facEn.create(pAddParam);
        this.fillerEntitiesFromRs.fill(pAddParam, entity, pRecordSet);
        return (T)entity;
    }

    public final <T> ColumnsValues evalColumnsValues(Map<String, Object> pAddParam, T pEntity) throws Exception {
        TableSql tableSql = this.getTablesMap().get(pEntity.getClass().getSimpleName());
        if (tableSql.getFieldsMap().containsKey("itsVersion")) {
            pAddParam.put("versionAlgorithm", tableSql.getVersionAlgorithm());
        }
        IConverter<?, ColumnsValues> convToColVal = this.factoryCnvEntityToColumnsValues.lazyGet(pAddParam, pEntity.getClass());
        ColumnsValues result = convToColVal.convert(pAddParam, pEntity);
        if (tableSql.getFieldsMap().containsKey("itsVersion")) {
            pAddParam.remove("versionAlgorithm");
        }
        return result;
    }

    public final <T> void prepareColumnValuesForUpdate(ColumnsValues pColumnsValues, T pEntity) throws Exception {
        pColumnsValues.getLongsMap().remove("itsVersionOld");
        TableSql tableSql = this.tablesMap.get(pEntity.getClass().getSimpleName());
        for (String idFldNm : tableSql.getIdColumnsNames()) {
            pColumnsValues.remove(idFldNm);
        }
    }

    public final <T> String evalWhereId(T pEntity, ColumnsValues pColumnsValues) throws Exception {
        TableSql tableSql = this.tablesMap.get(pEntity.getClass().getSimpleName());
        StringBuffer sbWhereId = new StringBuffer("");
        for (int i = 0; i < tableSql.getIdColumnsNames().length; ++i) {
            if (i > 0) {
                sbWhereId.append(" and ");
            }
            sbWhereId.append(pEntity.getClass().getSimpleName().toUpperCase() + "." + tableSql.getIdColumnsNames()[i].toUpperCase() + "=" + pColumnsValues.evalSqlValue(tableSql.getIdColumnsNames()[i]));
        }
        return sbWhereId.toString();
    }

    public final <T> String evalWhereForUpdate(T pEntity, ColumnsValues pColumnsValues) throws Exception {
        if (pColumnsValues.ifContains("itsVersion")) {
            return this.evalWhereId(pEntity, pColumnsValues) + " and " + "itsVersion".toUpperCase() + "=" + pColumnsValues.evalSqlValue("itsVersionOld");
        }
        return this.evalWhereId(pEntity, pColumnsValues);
    }

    public final <T> String evalWhereForField(Map<String, Object> pAddParam, T pEntity, String pFieldFor) throws Exception {
        String[] fieldsNames = new String[]{pFieldFor};
        pAddParam.put("fieldsNames", fieldsNames);
        ColumnsValues columnsValues = this.evalColumnsValues(pAddParam, pEntity);
        pAddParam.remove("fieldsNames");
        TableSql tableSql = this.tablesMap.get(pEntity.getClass().getSimpleName());
        FieldSql fldSql = tableSql.getFieldsMap().get(pFieldFor);
        StringBuffer sbWhere = new StringBuffer(" where ");
        String tableNm = pEntity.getClass().getSimpleName().toUpperCase();
        if (fldSql.getTypeField().equals((Object)ETypeField.COMPOSITE_FK_PK) || fldSql.getTypeField().equals((Object)ETypeField.COMPOSITE_FK)) {
            TableSql tableSqlFr = this.tablesMap.get(fldSql.getForeignEntity());
            for (int i = 0; i < tableSqlFr.getIdColumnsNames().length; ++i) {
                if (i > 0) {
                    sbWhere.append(" and ");
                }
                sbWhere.append(tableNm + "." + tableSqlFr.getIdColumnsNames()[i].toUpperCase() + "=" + columnsValues.evalObjectValue(tableSqlFr.getIdColumnsNames()[i]));
            }
        } else {
            sbWhere.append(tableNm + "." + pFieldFor.toUpperCase() + "=" + columnsValues.evalObjectValue(pFieldFor));
        }
        return sbWhere.toString();
    }

    public final void loadConfiguration(String pDirName, String pFileName) throws Exception {
        this.mngSettings.loadConfiguration(pDirName, pFileName);
        this.loadPropertiesBase(pDirName);
        this.loadSqlTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initializeDatabase(Map<String, Object> pAddParam) throws Exception {
        String queryExistanceTable = this.mngSettings.getAppSettings().get("checkTableExist");
        boolean ifCreatedOrAdded = false;
        boolean ifAllTablesCreated = true;
        try {
            for (Map.Entry<String, TableSql> entry : this.getTablesMap().entrySet()) {
                IRecordSet<RS> rs = this.srvDatabase.retrieveRecords(queryExistanceTable.replace(TABLE_PARAM_NAME_IN_EXISTENCE_QUERY, entry.getKey().toUpperCase()));
                if (!rs.moveToFirst()) {
                    rs = this.srvDatabase.retrieveRecords(queryExistanceTable.replace(TABLE_PARAM_NAME_IN_EXISTENCE_QUERY, entry.getKey().toLowerCase()));
                    if (!rs.moveToFirst()) {
                        ifCreatedOrAdded = true;
                        String string = this.evalSqlCreateTable(entry.getKey());
                        this.getLogger().info(null, ASrvOrm.class, "Try to execute DDL: " + string);
                        this.srvDatabase.executeQuery(string);
                        continue;
                    }
                    ifAllTablesCreated = false;
                    continue;
                }
                ifAllTablesCreated = false;
            }
            String dirPath = "/";
            if (this.propertiesBase.getDirectory() != null) {
                dirPath = "/" + this.propertiesBase.getDirectory() + "/";
            }
            String useSubFolder = this.mngSettings.getAppSettings().get("useSubFolder");
            String initSql = this.loadString(dirPath + useSubFolder + "/init.sql");
            if (initSql != null) {
                this.getLogger().info(null, ASrvOrm.class, "init.sql found, try to execute.");
                for (String initSingle : initSql.split("\n")) {
                    if (initSingle.trim().length() <= 1 || initSingle.startsWith("/")) continue;
                    this.getLogger().info(null, ASrvOrm.class, "Try to execute INIT query: " + initSingle);
                    this.srvDatabase.executeQuery(initSingle);
                }
            } else {
                this.getLogger().info(null, ASrvOrm.class, "init.sql not found.");
            }
            if (ifAllTablesCreated) {
                this.getLogger().info(null, ASrvOrm.class, "all tables has been created.");
                DatabaseInfo databaseInfo = new DatabaseInfo();
                int dbVer = Integer.parseInt(this.mngSettings.getAppSettings().get("databaseVersion"));
                databaseInfo.setDatabaseVersion(dbVer);
                databaseInfo.setDatabaseId(this.getNewDatabaseId());
                databaseInfo.setDescription(this.mngSettings.getAppSettings().get("title"));
                this.insertEntity(pAddParam, databaseInfo);
                String insertSql = this.loadString(dirPath + "insert.sql");
                if (insertSql != null) {
                    this.getLogger().info(null, ASrvOrm.class, dirPath + "insert.sql found, try to execute.");
                    for (String insertSingle : insertSql.split("\n")) {
                        if (insertSingle.trim().length() <= 1 || insertSingle.startsWith("/")) continue;
                        this.getLogger().info(null, ASrvOrm.class, "Try to execute insert : " + insertSingle);
                        this.srvDatabase.executeQuery(insertSingle);
                    }
                } else {
                    this.getLogger().info(null, ASrvOrm.class, dirPath + "insert.sql not found.");
                }
            } else if (ifCreatedOrAdded) {
                this.getLogger().info(null, ASrvOrm.class, "new tables has been added.");
            } else {
                this.getLogger().info(null, ASrvOrm.class, "tables already created.");
            }
            if (!ifAllTablesCreated) {
                this.tryUgradeDatabaseAnyWay(dirPath + useSubFolder + "/");
            }
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        return ifCreatedOrAdded;
    }

    public final void tryUgradeDatabase(String pUpgradeDir) throws Exception {
        Integer nextVersion = this.srvDatabase.getVersionDatabase() + 1;
        String upgradeSqlName = "upgrade_" + nextVersion + ".sql";
        String upgradeSql = this.loadString(pUpgradeDir + upgradeSqlName);
        while (upgradeSql != null) {
            this.getLogger().info(null, ASrvOrm.class, pUpgradeDir + upgradeSqlName + " found, try to execute.");
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                for (String upgradeSingle : upgradeSql.split("\n")) {
                    if (upgradeSingle.trim().length() <= 1 || upgradeSingle.startsWith("/")) continue;
                    this.getLogger().info(null, ASrvOrm.class, "Try to execute upgrade: " + upgradeSingle);
                    this.srvDatabase.executeQuery(upgradeSingle);
                }
                this.srvDatabase.commitTransaction();
            }
            catch (Exception exception) {
                this.srvDatabase.rollBackTransaction();
                throw exception;
            }
            Integer object = nextVersion;
            Integer n = nextVersion = Integer.valueOf(nextVersion + 1);
            upgradeSqlName = "upgrade_" + nextVersion + ".sql";
            upgradeSql = this.loadString(pUpgradeDir + upgradeSqlName);
        }
    }

    public final void tryUgradeDatabaseAnyWay(String pUpgradeDir) throws Exception {
        Integer nextVersion = this.srvDatabase.getVersionDatabase() + 1;
        String upgradeSqlName = "upgrade_" + nextVersion + ".sql";
        String upgradeSql = this.loadString(pUpgradeDir + upgradeSqlName);
        while (upgradeSql != null) {
            this.getLogger().info(null, ASrvOrm.class, pUpgradeDir + upgradeSqlName + " found, try to execute.");
            for (String upgradeSingle : upgradeSql.split("\n")) {
                if (upgradeSingle.trim().length() <= 1 || upgradeSingle.startsWith("/")) continue;
                try {
                    this.getLogger().info(null, ASrvOrm.class, "Try to execute upgrade: " + upgradeSingle);
                    this.srvDatabase.executeQuery(upgradeSingle);
                }
                catch (Exception ex) {
                    this.getLogger().error(null, ASrvOrm.class, "Can't execute: " + upgradeSingle, ex);
                    ex.printStackTrace();
                }
            }
            Integer object = nextVersion;
            Integer n = nextVersion = Integer.valueOf(nextVersion + 1);
            upgradeSqlName = "upgrade_" + nextVersion + ".sql";
            upgradeSql = this.loadString(pUpgradeDir + upgradeSqlName);
        }
    }

    public final String evalSqlCreateTable(String pEntityName) {
        TableSql tableSql = this.getTablesMap().get(pEntityName);
        StringBuffer result = new StringBuffer("create table " + pEntityName.toUpperCase() + " (\n");
        boolean isFirstField = true;
        for (Map.Entry<String, FieldSql> entry : tableSql.getFieldsMap().entrySet()) {
            if (entry.getValue().getTypeField().equals((Object)ETypeField.COMPOSITE_FK) || entry.getValue().getTypeField().equals((Object)ETypeField.COMPOSITE_FK_PK)) continue;
            if (isFirstField) {
                isFirstField = false;
            } else {
                result.append(",\n");
            }
            result.append(entry.getKey().toUpperCase() + " " + tableSql.getFieldsMap().get(entry.getKey()).getDefinition());
        }
        if (tableSql.getConstraint() != null) {
            result.append(",\n" + tableSql.getConstraint());
        }
        result.append(");\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = ASrvOrm.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = ASrvOrm.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final IUtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(IUtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }

    public final LinkedHashMap<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final HlpInsertUpdate getHlpInsertUpdate() {
        return this.hlpInsertUpdate;
    }

    public final void setHlpInsertUpdate(HlpInsertUpdate pHlpInsertUpdate) {
        this.hlpInsertUpdate = pHlpInsertUpdate;
    }

    public final IFactoryAppBeansByClass<IConverter<?, ColumnsValues>> getFactoryCnvEntityToColumnsValues() {
        return this.factoryCnvEntityToColumnsValues;
    }

    public final void setFactoryCnvEntityToColumnsValues(IFactoryAppBeansByClass<IConverter<?, ColumnsValues>> pFactoryCnvEntityToColumnsValues) {
        this.factoryCnvEntityToColumnsValues = pFactoryCnvEntityToColumnsValues;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }

    public final IFillerObjectsFrom<IRecordSet<RS>> getFillerEntitiesFromRs() {
        return this.fillerEntitiesFromRs;
    }

    public final void setFillerEntitiesFromRs(IFillerObjectsFrom<IRecordSet<RS>> pFillerEntitiesFromRs) {
        this.fillerEntitiesFromRs = pFillerEntitiesFromRs;
    }

    public final IFactoryAppBeansByClass<IFillerObjectFields<?>> getFctFillersObjectFields() {
        return this.fctFillersObjectFields;
    }

    public final void setFctFillersObjectFields(IFactoryAppBeansByClass<IFillerObjectFields<?>> pFctFillersObjectFields) {
        this.fctFillersObjectFields = pFctFillersObjectFields;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final void setPropertiesBase(PropertiesBase pPropertiesBase) {
        this.propertiesBase = pPropertiesBase;
    }

    public final PropertiesBase getPropertiesBase() {
        return this.propertiesBase;
    }
}

