/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.beigesoft.converter.IConverterByName;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.orm.model.ETypeField;
import org.beigesoft.orm.model.TableSql;
import org.beigesoft.service.IFillerObjectFields;
import org.beigesoft.service.IFillerObjectsFrom;

public class FillerEntitiesFromRs<RS>
implements IFillerObjectsFrom<IRecordSet<RS>> {
    private Map<String, TableSql> tablesMap;
    private ILogger logger;
    private IFactoryAppBeansByClass<IFillerObjectFields<?>> fillersFieldsFactory;
    private IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> convertersFieldsFatory;
    private IHolderForClassByName<String> fieldConverterNamesHolder;
    private IHolderForClassByName<Field> fieldsRapiHolder;

    @Override
    public final <T> void fill(Map<String, Object> pAddParam, T pEntity, IRecordSet<RS> pSource) throws Exception {
        IFillerObjectFields<?> filler = this.fillersFieldsFactory.lazyGet(pAddParam, pEntity.getClass());
        TableSql tableSql = this.tablesMap.get(pEntity.getClass().getSimpleName());
        Set<String> fieldsNames = (Set<String>)pAddParam.get(pEntity.getClass().getSimpleName() + "neededFields");
        if (fieldsNames == null) {
            fieldsNames = tableSql.getFieldsMap().keySet();
        }
        boolean isShowDbMsg = this.logger.getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.logger.getDetailLevel();
        for (String fieldName : fieldsNames) {
            String convName;
            IConverterByName<IRecordSet<RS>, ?> conv;
            if (tableSql.getFieldsMap().get(fieldName).getTypeField().equals((Object)ETypeField.DERIVED_FROM_COMPOSITE) || (conv = this.convertersFieldsFatory.lazyGet(pAddParam, convName = this.fieldConverterNamesHolder.getFor(pEntity.getClass(), fieldName))) == null) continue;
            try {
                String parName;
                String tableAlias;
                Field field = this.fieldsRapiHolder.getFor(pEntity.getClass(), fieldName);
                String currentLevelNm = "currentLevel";
                ArrayList<Integer> currentLevel = (ArrayList<Integer>)pAddParam.get(currentLevelNm);
                if (currentLevel != null && currentLevel.size() > 0 && (Integer)currentLevel.get(currentLevel.size() - 1) > 1) {
                    String currForeignFieldNm = (String)pAddParam.get("foreignFieldNmL" + ((Integer)currentLevel.get(currentLevel.size() - 1) - 1));
                    tableAlias = currForeignFieldNm.toUpperCase();
                } else {
                    tableAlias = "";
                }
                if (Enum.class.isAssignableFrom(field.getType())) {
                    parName = tableAlias + fieldName.toUpperCase();
                    pAddParam.put("fieldClass", field.getType());
                } else if (tableSql.getFieldsMap().get(fieldName).getForeignEntity() != null) {
                    Integer deepLevelReq;
                    String deepLevelNm;
                    ArrayList<Integer> deepLevel;
                    if (currentLevel == null) {
                        currentLevel = new ArrayList<Integer>();
                        currentLevel.add(1);
                        pAddParam.put(currentLevelNm, currentLevel);
                    }
                    if ((deepLevel = (ArrayList<Integer>)pAddParam.get(deepLevelNm = "deepLevel")) == null) {
                        deepLevel = new ArrayList<Integer>();
                        pAddParam.put(deepLevelNm, deepLevel);
                    }
                    if ((deepLevelReq = (Integer)pAddParam.get(pEntity.getClass().getSimpleName() + fieldName + deepLevelNm)) != null) {
                        if (currentLevel.size() == 1 && (Integer)currentLevel.get(0) == 1) {
                            if (deepLevel.size() == 1) {
                                deepLevel.set(0, deepLevelReq);
                            } else {
                                deepLevel.add(deepLevelReq);
                            }
                        } else {
                            currentLevel.add(1);
                            deepLevel.add(deepLevelReq);
                        }
                    } else if (currentLevel.size() == 1 && (Integer)currentLevel.get(0) == 1) {
                        if (deepLevel.size() == 1) {
                            deepLevel.set(0, 2);
                        } else {
                            deepLevel.add(2);
                        }
                    }
                    if (deepLevel.size() != currentLevel.size()) {
                        throw new Exception("Algorithm error: deepLevel.size/currentLevel.size/Entity/Field" + deepLevel.size() + "/" + currentLevel.size() + "/" + pEntity.getClass().getSimpleName() + "/" + fieldName);
                    }
                    parName = fieldName;
                    pAddParam.put("foreignFieldNmL" + currentLevel.get(currentLevel.size() - 1), fieldName);
                    pAddParam.put("fieldClass", field.getType());
                    pAddParam.put("entityClass", pEntity.getClass());
                } else {
                    parName = tableAlias + fieldName.toUpperCase();
                }
                Object fieldVal = conv.convert(pAddParam, pSource, parName);
                if (isShowDbMsg && dbgDetLev > 33000) {
                    this.logger.debug(null, FillerEntitiesFromRs.class, "Converted from RS class/field/type/converter/value: " + pEntity.getClass().getSimpleName() + "/" + fieldName + "/" + field.getType().getSimpleName() + "/" + conv.getClass().getSimpleName() + "/" + fieldVal);
                }
                filler.fill(pAddParam, pEntity, fieldVal, fieldName);
            }
            catch (Exception ex) {
                String msg = "Can't fill field/class: " + fieldName + "/" + pEntity.getClass().getCanonicalName();
                throw new ExceptionWithCode(1001, msg, ex);
            }
        }
    }

    public final Map<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final void setTablesMap(Map<String, TableSql> pTablesMap) {
        this.tablesMap = pTablesMap;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final IFactoryAppBeansByClass<IFillerObjectFields<?>> getFillersFieldsFactory() {
        return this.fillersFieldsFactory;
    }

    public final void setFillersFieldsFactory(IFactoryAppBeansByClass<IFillerObjectFields<?>> pFillersFieldsFactory) {
        this.fillersFieldsFactory = pFillersFieldsFactory;
    }

    public final IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> getConvertersFieldsFatory() {
        return this.convertersFieldsFatory;
    }

    public final void setConvertersFieldsFatory(IFactoryAppBeansByName<IConverterByName<IRecordSet<RS>, ?>> pConvertersFieldsFatory) {
        this.convertersFieldsFatory = pConvertersFieldsFatory;
    }

    public final IHolderForClassByName<String> getFieldConverterNamesHolder() {
        return this.fieldConverterNamesHolder;
    }

    public final void setFieldConverterNamesHolder(IHolderForClassByName<String> pFieldConverterNamesHolder) {
        this.fieldConverterNamesHolder = pFieldConverterNamesHolder;
    }

    public final IHolderForClassByName<Field> getFieldsRapiHolder() {
        return this.fieldsRapiHolder;
    }

    public final void setFieldsRapiHolder(IHolderForClassByName<Field> pFieldsRapiHolder) {
        this.fieldsRapiHolder = pFieldsRapiHolder;
    }
}

