/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.beigesoft.doc.model.DocLine;
import org.beigesoft.doc.service.IElementWriter;
import org.beigesoft.doc.service.UomHelper;
import org.beigesoft.pdf.model.EGraphicState;
import org.beigesoft.pdf.model.ETextState;
import org.beigesoft.pdf.model.HasPdfContent;
import org.beigesoft.pdf.model.PdfContent;
import org.beigesoft.pdf.service.PdfWriteHelper;

public class LineWriter
implements IElementWriter<DocLine<HasPdfContent>, HasPdfContent> {
    private PdfWriteHelper writeHelper;
    private UomHelper uomHelper;

    @Override
    public final void write(DocLine<HasPdfContent> pLn, HasPdfContent pWi) throws Exception {
        PdfContent wi = pWi.getPdfContent();
        if (wi.getTextState().equals((Object)ETextState.STARTED)) {
            wi.getBuffer().write("ET\n".getBytes(this.getWriteHelper().getAscii()));
            wi.setTextState(ETextState.ENDED);
            wi.setX(null);
            wi.setY(null);
        }
        if (!wi.getGraphicState().equals((Object)EGraphicState.STARTED)) {
            wi.getBuffer().write("2 J\n".getBytes(this.getWriteHelper().getAscii()));
            wi.setGraphicState(EGraphicState.STARTED);
        }
        double lnWdd = this.uomHelper.toPoints(pLn.getWidth(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        BigDecimal lnWd = BigDecimal.valueOf(lnWdd).setScale(2, RoundingMode.HALF_UP);
        if (wi.getLineWidth().compareTo(lnWd) != 0) {
            wi.setLineWidth(lnWd);
            String lnWdStr = lnWd.toString() + " w\n";
            wi.getBuffer().write(lnWdStr.getBytes(this.getWriteHelper().getAscii()));
        }
        double lnX1d = this.uomHelper.toPoints(pLn.getX1(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        BigDecimal lnX1 = BigDecimal.valueOf(lnX1d).setScale(2, RoundingMode.HALF_UP);
        double lnUY1d = this.uomHelper.toPoints(pLn.getY1(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double pageHeight = this.uomHelper.toPoints(wi.getPage().getHeight(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double lnY1d = pageHeight - lnUY1d;
        BigDecimal lnY1 = BigDecimal.valueOf(lnY1d).setScale(2, RoundingMode.HALF_UP);
        String lnX1Y1Str = lnX1.toString() + " " + lnY1 + " m\n";
        wi.getBuffer().write(lnX1Y1Str.getBytes(this.getWriteHelper().getAscii()));
        double lnX2d = this.uomHelper.toPoints(pLn.getX2(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        BigDecimal lnX2 = BigDecimal.valueOf(lnX2d).setScale(2, RoundingMode.HALF_UP);
        double lnUY2d = this.uomHelper.toPoints(pLn.getY2(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double lnY2d = pageHeight - lnUY2d;
        BigDecimal lnY2 = BigDecimal.valueOf(lnY2d).setScale(2, RoundingMode.HALF_UP);
        String lnX2Y2Str = lnX2.toString() + " " + lnY2 + " l\n";
        wi.getBuffer().write(lnX2Y2Str.getBytes(this.getWriteHelper().getAscii()));
    }

    public final PdfWriteHelper getWriteHelper() {
        return this.writeHelper;
    }

    public final void setWriteHelper(PdfWriteHelper pWriteHelper) {
        this.writeHelper = pWriteHelper;
    }

    public final UomHelper getUomHelper() {
        return this.uomHelper;
    }

    public final void setUomHelper(UomHelper pUomHelper) {
        this.uomHelper = pUomHelper;
    }
}

