/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.beigesoft.doc.model.DocImage;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocString;
import org.beigesoft.doc.model.IElement;
import org.beigesoft.doc.model.IFont;
import org.beigesoft.doc.service.UomHelper;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.pdf.model.APdfStream;
import org.beigesoft.pdf.model.EFontS14;
import org.beigesoft.pdf.model.IHasPdfContent;
import org.beigesoft.pdf.model.IPdfObject;
import org.beigesoft.pdf.model.PdfCidFontType2;
import org.beigesoft.pdf.model.PdfContent;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.model.PdfFontDescriptor;
import org.beigesoft.pdf.model.PdfFontFile;
import org.beigesoft.pdf.model.PdfFontType0;
import org.beigesoft.pdf.model.PdfFontType1S14;
import org.beigesoft.pdf.model.PdfImage;
import org.beigesoft.pdf.model.PdfPage;
import org.beigesoft.pdf.model.PdfToUnicode;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.pdf.service.WriterPdfCidFontType2;
import org.beigesoft.pdf.service.WriterPdfContent;
import org.beigesoft.pdf.service.WriterPdfFontDescriptor;
import org.beigesoft.pdf.service.WriterPdfFontFile;
import org.beigesoft.pdf.service.WriterPdfFontType0;
import org.beigesoft.pdf.service.WriterPdfFontType1S14;
import org.beigesoft.pdf.service.WriterPdfImage;
import org.beigesoft.pdf.service.WriterPdfPage;
import org.beigesoft.pdf.service.WriterPdfToUnicode;
import org.beigesoft.ttf.model.CompoundGlyph;
import org.beigesoft.ttf.model.TtfFont;
import org.beigesoft.ttf.service.ITtfLoader;
import org.beigesoft.ttf.service.ITtfSourceStreamer;

public class PdfMaker<WI extends IHasPdfContent>
implements IPdfMaker<WI> {
    private UomHelper uomHelper;
    private ITtfLoader ttfLoader;
    private WriterPdfContent writerPdfContent;
    private WriterPdfPage writerPdfPage;
    private WriterPdfToUnicode writerPdfToUnicode;
    private WriterPdfCidFontType2 writerPdfCidFontType2;
    private WriterPdfFontDescriptor writerPdfFontDescriptor;
    private WriterPdfFontFile writerPdfFontFile;
    private WriterPdfImage writerPdfImage;
    private WriterPdfFontType0 writerPdfFontType0;
    private WriterPdfFontType1S14 writerPdfFontType1S14;
    private final Map<String, TtfFont> ttfFonts = new HashMap<String, TtfFont>();
    private final Map<String, ITtfSourceStreamer> ttfFontsStreamers = new HashMap<String, ITtfSourceStreamer>();
    private final Map<String, String> ttfFontsPaths = new HashMap<String, String>();
    private String fontDir;
    private ITtfSourceStreamer ttfResourceStreamer;
    private ITtfSourceStreamer ttfFileStreamer;

    @Override
    public final void prepareBeforeWrite(PdfDocument<WI> pDoc) throws Exception {
        int i;
        for (DocPage<WI> dpg : pDoc.getMainDoc().getPages()) {
            this.addPage(pDoc, dpg);
        }
        for (PdfToUnicode toUni : pDoc.getPdfToUnicodes()) {
            toUni.getUsedCids().clear();
            toUni.getUsedCids().add(Character.valueOf('\u0000'));
        }
        for (int i2 = 0; i2 < pDoc.getPdfObjects().size(); ++i2) {
            pDoc.getPdfObjects().get(i2).setNumber(i2 + 1);
            if (!(pDoc.getPdfObjects().get(i2) instanceof PdfContent)) continue;
            PdfContent cont = (PdfContent)pDoc.getPdfObjects().get(i2);
            for (IElement<? extends IHasPdfContent> el : cont.getPage().getElements()) {
                if (!(el instanceof DocString)) continue;
                DocString pstr = (DocString)el;
                IPdfObject fnt = pDoc.getResources().getFonts().get(pstr.getFontNumber() - 1);
                if (!(fnt instanceof PdfFontType0)) continue;
                PdfFontType0 fnt0 = (PdfFontType0)fnt;
                for (int j = 0; j < pstr.getValue().length(); ++j) {
                    char uni = (char)pstr.getValue().codePointAt(j);
                    Character cid = fnt0.getToUnicode().getUniToCid().get(Character.valueOf(uni));
                    if (cid == null) {
                        throw new ExceptionPdfWr("There is no CID for UNI/char: " + uni + "/" + uni);
                    }
                    if (fnt0.getToUnicode().getUsedCids().contains(cid)) continue;
                    fnt0.getToUnicode().getUsedCids().add(cid);
                    fnt0.getToUnicode().getUsedCidToUni().put(cid, Character.valueOf(uni));
                    for (CompoundGlyph cgl : fnt0.getCompoundGlyphs()) {
                        if (cgl.getGid() != cid.charValue()) continue;
                        for (char partGid : cgl.getPartsGids()) {
                            if (fnt0.getToUnicode().getUsedCids().contains(Character.valueOf(partGid))) continue;
                            fnt0.getToUnicode().getUsedCids().add(Character.valueOf(partGid));
                        }
                    }
                }
            }
        }
        int lastIdx = pDoc.getPdfObjects().size();
        for (i = 0; i < pDoc.getPdfToUnicodes().size(); ++i) {
            pDoc.getPdfToUnicodes().get(i).setNumber(lastIdx + i + 1);
            Collections.sort(pDoc.getPdfToUnicodes().get(i).getUsedCids());
        }
        lastIdx += pDoc.getPdfToUnicodes().size();
        for (i = 0; i < pDoc.getCidType2Fonts().size(); ++i) {
            pDoc.getCidType2Fonts().get(i).setNumber(lastIdx + i + 1);
        }
        lastIdx += pDoc.getCidType2Fonts().size();
        for (i = 0; i < pDoc.getFontDescriptors().size(); ++i) {
            pDoc.getFontDescriptors().get(i).setNumber(lastIdx + i + 1);
        }
        lastIdx += pDoc.getFontDescriptors().size();
        for (i = 0; i < pDoc.getFontFiles().size(); ++i) {
            pDoc.getFontFiles().get(i).setNumber(lastIdx + i + 1);
        }
        lastIdx += pDoc.getFontFiles().size();
        for (i = 0; i < pDoc.getImages().size(); ++i) {
            pDoc.getImages().get(i).setNumber(lastIdx + i + 1);
        }
    }

    @Override
    public final void setIsCompressed(PdfDocument<WI> pDoc, boolean pIsCompressed) throws Exception {
        pDoc.setIsCompressed(pIsCompressed);
        for (IPdfObject iPdfObject : pDoc.getPdfObjects()) {
            if (!(iPdfObject instanceof APdfStream)) continue;
            APdfStream pdfSt = (APdfStream)iPdfObject;
            pdfSt.setIsCompressed(pIsCompressed);
        }
        for (PdfToUnicode pdfToUnicode : pDoc.getPdfToUnicodes()) {
            pdfToUnicode.setIsCompressed(pIsCompressed);
        }
    }

    @Override
    public final void addPage(PdfDocument<WI> pDoc, DocPage<WI> pDocPage) throws Exception {
        PdfPage pg = new PdfPage();
        double urx = this.uomHelper.toPoints(pDocPage.getWidth(), pDoc.getMainDoc().getResolutionDpi(), pDoc.getMainDoc().getUnitOfMeasure());
        double ury = this.uomHelper.toPoints(pDocPage.getHeight(), pDoc.getMainDoc().getResolutionDpi(), pDoc.getMainDoc().getUnitOfMeasure());
        pg.getMediabox().setUrX((float)urx);
        pg.getMediabox().setUrY((float)ury);
        pg.setWriter(this.writerPdfPage);
        pg.setParent(pDoc.getPdfTrailer().getRoot().getPages());
        pg.setResources(pDoc.getResources());
        pDoc.getPdfObjects().add(pg);
        pDoc.getPdfTrailer().getRoot().getPages().getPages().add(pg);
        PdfContent pdfCn = new PdfContent();
        pdfCn.setWriter(this.writerPdfContent);
        pdfCn.setDocument(pDoc);
        pdfCn.setPage(pDocPage);
        pg.setContents(pdfCn);
        pDoc.getPdfObjects().add(pdfCn);
    }

    @Override
    public final void addFontT1S14(PdfDocument<WI> pDoc, EFontS14 pFontS14) throws Exception {
        for (IFont fnt : pDoc.getMainDoc().getFonts()) {
            if (!fnt.getItsName().equals(pFontS14.toString())) continue;
            throw new ExceptionPdfWr("Font is already added!!! " + pFontS14.toString());
        }
        PdfFontType1S14 pdfFn = new PdfFontType1S14();
        pdfFn.setBaseFont(pFontS14);
        pdfFn.setWriter(this.writerPdfFontType1S14);
        pDoc.getMainDoc().getFonts().add(pdfFn);
        pDoc.getMainDoc().setFontNumber(pDoc.getMainDoc().getFonts().size());
        pDoc.getResources().getFonts().add(pdfFn);
        pDoc.getPdfObjects().add(pdfFn);
    }

    @Override
    public final void addImage(PdfDocument<WI> pDoc, DocImage pDocImage) throws Exception {
        PdfImage pdfImage = new PdfImage();
        pdfImage.setDocImage(pDocImage);
        pdfImage.setWriter(this.writerPdfImage);
        pDoc.getImages().add(pdfImage);
        pDoc.getResources().getImages().add(pdfImage);
    }

    @Override
    public final void addFontTtf(PdfDocument<WI> pDoc, String pFontName) throws Exception {
        for (IFont fnt : pDoc.getMainDoc().getFonts()) {
            if (!fnt.getItsName().equals(pFontName)) continue;
            throw new ExceptionPdfWr("Font is already added!!! " + pFontName);
        }
        PdfFontType0 pdfFn = new PdfFontType0();
        pdfFn.setBaseFont(pFontName);
        pdfFn.setWriter(this.writerPdfFontType0);
        pDoc.getResources().getFonts().add(pdfFn);
        pDoc.getPdfObjects().add(pdfFn);
        PdfToUnicode toUni = new PdfToUnicode();
        toUni.setWriter(this.writerPdfToUnicode);
        pdfFn.setToUnicode(toUni);
        pDoc.getPdfToUnicodes().add(toUni);
        PdfCidFontType2 cidFnt = new PdfCidFontType2();
        cidFnt.setWriter(this.writerPdfCidFontType2);
        cidFnt.setBaseFont(pFontName);
        cidFnt.setToUnicode(toUni);
        pdfFn.setDescendantFonts(cidFnt);
        pDoc.getCidType2Fonts().add(cidFnt);
        PdfFontFile ff = new PdfFontFile();
        ff.setWriter(this.writerPdfFontFile);
        ff.setFontName(pFontName);
        ff.setToUnicode(toUni);
        pDoc.getFontFiles().add(ff);
        TtfFont ttfFont = this.lazyGetTtfFont(pFontName);
        pdfFn.setCompoundGlyphs(ttfFont.getGlyf().getCompoundGlyphs());
        cidFnt.setHmtx(ttfFont.getHmtx());
        cidFnt.setUnitsPerEm(ttfFont.getHead().getUnitsPerEm());
        toUni.setUniToCid(ttfFont.getCmap().getUniToCid());
        PdfFontDescriptor fd = new PdfFontDescriptor();
        fd.setWriter(this.writerPdfFontDescriptor);
        fd.setFontName(pFontName);
        float scaling = 1000.0f / (float)ttfFont.getHead().getUnitsPerEm();
        fd.setMinX((float)ttfFont.getHead().getXMin() * scaling);
        fd.setMaxX((float)ttfFont.getHead().getXMax() * scaling);
        fd.setMinY((float)ttfFont.getHead().getYMin() * scaling);
        fd.setMaxY((float)ttfFont.getHead().getYMax() * scaling);
        if (ttfFont.getOs2() != null) {
            fd.setFontWeight(ttfFont.getOs2().getUsWeightClass());
            if (ttfFont.getOs2().getSCapHeight() != 0) {
                fd.setCapHeight((float)ttfFont.getOs2().getSCapHeight() * scaling);
            }
            fd.setXHeight((float)ttfFont.getOs2().getSxHeight() * scaling);
            fd.setIsItalic7((ttfFont.getOs2().getFsSelection() & 1) > 0);
            switch (ttfFont.getOs2().getSFamilyClass()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    fd.setIsSerif2(true);
                    break;
                }
                case 10: {
                    fd.setIsScript4(true);
                    break;
                }
            }
        }
        if (fd.getCapHeight() == 0.0f) {
            fd.setCapHeight(700.0f);
        }
        if (ttfFont.getHhea() != null) {
            fd.setAscent((float)ttfFont.getHhea().getAscent() * scaling);
            fd.setDescent((float)ttfFont.getHhea().getDescent() * scaling);
        }
        if (ttfFont.getPost() != null) {
            fd.setIsFixedPitch1(ttfFont.getPost().getIsFixedPitch());
            fd.setItalicAngle(ttfFont.getPost().getItalicAngle());
        }
        fd.evalFlags();
        fd.setFontFile2(ff);
        cidFnt.setFontDescriptor(fd);
        pDoc.getMainDoc().getFonts().add(pdfFn);
        pDoc.getMainDoc().setFontNumber(pDoc.getMainDoc().getFonts().size());
        pDoc.getFontDescriptors().add(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TtfFont lazyGetTtfFont(String pFontName) throws Exception {
        TtfFont fnt = this.ttfFonts.get(pFontName);
        if (fnt == null) {
            PdfMaker pdfMaker = this;
            synchronized (pdfMaker) {
                fnt = this.ttfFonts.get(pFontName);
                if (fnt == null) {
                    String path = this.fontDir + pFontName + ".ttf";
                    fnt = this.ttfLoader.loadFontTtf(pFontName, path, this.ttfResourceStreamer);
                    this.ttfFonts.put(pFontName, fnt);
                    this.ttfFontsPaths.put(pFontName, path);
                    this.ttfFontsStreamers.put(pFontName, this.ttfResourceStreamer);
                }
            }
        }
        return fnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TtfFont lazyGetTtfFontFromFile(String pFontName, String pFilePath) throws Exception {
        TtfFont fnt = this.ttfFonts.get(pFontName);
        if (fnt == null) {
            PdfMaker pdfMaker = this;
            synchronized (pdfMaker) {
                fnt = this.ttfFonts.get(pFontName);
                if (fnt == null) {
                    fnt = this.ttfLoader.loadFontTtf(pFontName, pFilePath, this.ttfFileStreamer);
                    this.ttfFonts.put(pFontName, fnt);
                    this.ttfFontsPaths.put(pFontName, pFilePath);
                    this.ttfFontsStreamers.put(pFontName, this.ttfFileStreamer);
                }
            }
        }
        return fnt;
    }

    public final Map<String, TtfFont> getTtfFonts() {
        return this.ttfFonts;
    }

    public final Map<String, ITtfSourceStreamer> getTtfFontsStreamers() {
        return this.ttfFontsStreamers;
    }

    public final Map<String, String> getTtfFontsPaths() {
        return this.ttfFontsPaths;
    }

    public final UomHelper getUomHelper() {
        return this.uomHelper;
    }

    public final void setUomHelper(UomHelper pUomHelper) {
        this.uomHelper = pUomHelper;
    }

    public final ITtfLoader getTtfLoader() {
        return this.ttfLoader;
    }

    public final void setTtfLoader(ITtfLoader pITtfLoader) {
        this.ttfLoader = pITtfLoader;
    }

    public final WriterPdfContent getWriterPdfContent() {
        return this.writerPdfContent;
    }

    public final void setWriterPdfContent(WriterPdfContent pWriterPdfContent) {
        this.writerPdfContent = pWriterPdfContent;
    }

    public final WriterPdfPage getWriterPdfPage() {
        return this.writerPdfPage;
    }

    public final void setWriterPdfPage(WriterPdfPage pWriterPdfPage) {
        this.writerPdfPage = pWriterPdfPage;
    }

    public final WriterPdfToUnicode getWriterPdfToUnicode() {
        return this.writerPdfToUnicode;
    }

    public final void setWriterPdfToUnicode(WriterPdfToUnicode pWriterPdfToUnicode) {
        this.writerPdfToUnicode = pWriterPdfToUnicode;
    }

    public final WriterPdfCidFontType2 getWriterPdfCidFontType2() {
        return this.writerPdfCidFontType2;
    }

    public final void setWriterPdfCidFontType2(WriterPdfCidFontType2 pWriterPdfCidFontType2) {
        this.writerPdfCidFontType2 = pWriterPdfCidFontType2;
    }

    public final WriterPdfFontDescriptor getWriterPdfFontDescriptor() {
        return this.writerPdfFontDescriptor;
    }

    public final void setWriterPdfFontDescriptor(WriterPdfFontDescriptor pWriterPdfFontDescriptor) {
        this.writerPdfFontDescriptor = pWriterPdfFontDescriptor;
    }

    public final WriterPdfFontFile getWriterPdfFontFile() {
        return this.writerPdfFontFile;
    }

    public final void setWriterPdfFontFile(WriterPdfFontFile pWriterPdfFontFile) {
        this.writerPdfFontFile = pWriterPdfFontFile;
    }

    public final WriterPdfFontType0 getWriterPdfFontType0() {
        return this.writerPdfFontType0;
    }

    public final void setWriterPdfFontType0(WriterPdfFontType0 pWriterPdfFontType0) {
        this.writerPdfFontType0 = pWriterPdfFontType0;
    }

    public final WriterPdfFontType1S14 getWriterPdfFontType1S14() {
        return this.writerPdfFontType1S14;
    }

    public final void setWriterPdfFontType1S14(WriterPdfFontType1S14 pWriterPdfFontType1S14) {
        this.writerPdfFontType1S14 = pWriterPdfFontType1S14;
    }

    public final String getFontDir() {
        return this.fontDir;
    }

    public final void setFontDir(String pFontDir) {
        this.fontDir = pFontDir;
    }

    public final ITtfSourceStreamer getTtfResourceStreamer() {
        return this.ttfResourceStreamer;
    }

    public final void setTtfResourceStreamer(ITtfSourceStreamer pTtfResourceStreamer) {
        this.ttfResourceStreamer = pTtfResourceStreamer;
    }

    public final ITtfSourceStreamer getTtfFileStreamer() {
        return this.ttfFileStreamer;
    }

    public final void setTtfFileStreamer(ITtfSourceStreamer pTtfFileStreamer) {
        this.ttfFileStreamer = pTtfFileStreamer;
    }

    public final WriterPdfImage getWriterPdfImage() {
        return this.writerPdfImage;
    }

    public final void setWriterPdfImage(WriterPdfImage pWriterPdfImage) {
        this.writerPdfImage = pWriterPdfImage;
    }
}

