/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import java.util.Map;
import org.beigesoft.pdf.model.IPdfObject;
import org.beigesoft.pdf.model.PdfCidFontType2;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.model.PdfFontDescriptor;
import org.beigesoft.pdf.model.PdfFontFile;
import org.beigesoft.pdf.model.PdfImage;
import org.beigesoft.pdf.model.PdfToUnicode;
import org.beigesoft.pdf.service.IPdfWriter;
import org.beigesoft.pdf.service.PdfWriteHelper;

public class PdfWriter<WI>
implements IPdfWriter<WI> {
    private PdfWriteHelper writeHelper;

    @Override
    public final void write(Map<String, Object> pAddParam, PdfDocument<WI> pDoc, OutputStream pOut) throws Exception {
        String xrefEntryStr;
        int writenCount = 0;
        switch (pDoc.getVersion()) {
            case 10: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion10().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 11: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion11().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 12: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion12().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 13: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion13().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 15: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion15().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 16: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion16().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            case 17: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion17().getBytes(this.getWriteHelper().getAscii()), pOut);
                break;
            }
            default: {
                writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getPdfVersion14().getBytes(this.getWriteHelper().getAscii()), pOut);
            }
        }
        writenCount += this.getWriteHelper().writeBytes(this.getWriteHelper().getHeadBinarySign(), pOut);
        for (IPdfObject iPdfObject : pDoc.getPdfObjects()) {
            iPdfObject.setStart(writenCount);
            writenCount += iPdfObject.write(pOut);
        }
        for (PdfToUnicode pdfToUnicode : pDoc.getPdfToUnicodes()) {
            pdfToUnicode.setStart(writenCount);
            writenCount += pdfToUnicode.write(pOut);
        }
        for (PdfCidFontType2 pdfCidFontType2 : pDoc.getCidType2Fonts()) {
            pdfCidFontType2.setStart(writenCount);
            writenCount += pdfCidFontType2.write(pOut);
        }
        for (PdfFontDescriptor pdfFontDescriptor : pDoc.getFontDescriptors()) {
            pdfFontDescriptor.setStart(writenCount);
            writenCount += pdfFontDescriptor.write(pOut);
        }
        for (PdfFontFile pdfFontFile : pDoc.getFontFiles()) {
            pdfFontFile.setStart(writenCount);
            writenCount += pdfFontFile.write(pOut);
        }
        for (PdfImage pdfImage : pDoc.getImages()) {
            pdfImage.setStart(writenCount);
            writenCount += pdfImage.write(pOut);
        }
        int totalObjects = pDoc.getPdfObjects().size() + pDoc.getPdfToUnicodes().size() + pDoc.getCidType2Fonts().size() + pDoc.getFontDescriptors().size() + pDoc.getFontFiles().size() + pDoc.getImages().size();
        pDoc.getPdfXref().setStart(writenCount);
        this.getWriteHelper().writeBytes(this.getWriteHelper().getXrefLf(), pOut);
        String string = "0 " + (totalObjects + 1) + "\n";
        this.getWriteHelper().writeBytes(string.getBytes(this.getWriteHelper().getAscii()), pOut);
        this.getWriteHelper().writeBytes(this.getWriteHelper().getXref1EntryLf(), pOut);
        for (IPdfObject iPdfObject : pDoc.getPdfObjects()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        for (IPdfObject iPdfObject : pDoc.getPdfToUnicodes()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        for (IPdfObject iPdfObject : pDoc.getCidType2Fonts()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        for (IPdfObject iPdfObject : pDoc.getFontDescriptors()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        for (IPdfObject iPdfObject : pDoc.getFontFiles()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        for (IPdfObject iPdfObject : pDoc.getImages()) {
            xrefEntryStr = String.format("%010d", iPdfObject.getStart()) + " " + String.format("%05d", iPdfObject.getGenNumber()) + " n\n";
            this.getWriteHelper().writeBytes(xrefEntryStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        this.getWriteHelper().writeBytes(this.getWriteHelper().getTrailerStart(), pOut);
        String sizeStr = String.valueOf(totalObjects + 1) + "\n";
        this.getWriteHelper().writeBytes(sizeStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String string2 = "/Root " + pDoc.getPdfTrailer().getRoot().getNumber() + " " + pDoc.getPdfTrailer().getRoot().getGenNumber() + " R\n";
        this.getWriteHelper().writeBytes(string2.getBytes(this.getWriteHelper().getAscii()), pOut);
        if (pDoc.getPdfTrailer().getInfo() != null) {
            String infoStr = "/Info " + pDoc.getPdfTrailer().getInfo().getNumber() + " " + pDoc.getPdfTrailer().getInfo().getGenNumber() + " R";
            this.getWriteHelper().writeBytes(infoStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        this.getWriteHelper().writeBytes(this.getWriteHelper().getEndDictLf(), pOut);
        this.getWriteHelper().writeBytes(this.getWriteHelper().getStartxrefLf(), pOut);
        String xrefStartStr = pDoc.getPdfXref().getStart().toString() + "\n";
        this.getWriteHelper().writeBytes(xrefStartStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        this.getWriteHelper().writeBytes(this.getWriteHelper().getEof(), pOut);
    }

    public final PdfWriteHelper getWriteHelper() {
        return this.writeHelper;
    }

    public final void setWriteHelper(PdfWriteHelper pWriteHelper) {
        this.writeHelper = pWriteHelper;
    }
}

