/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.beigesoft.doc.model.DocString;
import org.beigesoft.doc.service.IElementWriter;
import org.beigesoft.doc.service.ToHexCoder;
import org.beigesoft.doc.service.UomHelper;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.pdf.model.ETextState;
import org.beigesoft.pdf.model.HasPdfContent;
import org.beigesoft.pdf.model.IPdfObject;
import org.beigesoft.pdf.model.PdfContent;
import org.beigesoft.pdf.model.PdfFontType0;
import org.beigesoft.pdf.model.PdfFontType1S14;
import org.beigesoft.pdf.service.PdfWriteHelper;

public class StringWriter
implements IElementWriter<DocString<HasPdfContent>, HasPdfContent> {
    private PdfWriteHelper writeHelper;
    private ToHexCoder toHexCoder;
    private UomHelper uomHelper;

    @Override
    public final void write(DocString<HasPdfContent> pStr, HasPdfContent pWi) throws Exception {
        BigDecimal strDtY;
        BigDecimal strDtX;
        PdfContent wi = pWi.getPdfContent();
        if (wi.getTextState().equals((Object)ETextState.ENDED)) {
            wi.getBuffer().write("BT\n".getBytes(this.getWriteHelper().getAscii()));
            wi.setTextState(ETextState.STARTED);
        }
        StringBuffer sb = new StringBuffer();
        double strFntSzd = this.uomHelper.toPoints(pStr.getFontSize(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        BigDecimal strFntSz = BigDecimal.valueOf(strFntSzd).setScale(2, RoundingMode.HALF_UP);
        if (wi.getFontNumber() != pStr.getFontNumber() || wi.getFontSize().compareTo(strFntSz) != 0) {
            wi.setFontNumber(pStr.getFontNumber());
            wi.setFontSize(strFntSz);
            String fntStr = "/F" + wi.getFontNumber() + " " + strFntSz + " Tf\n";
            wi.getBuffer().write(fntStr.getBytes(this.getWriteHelper().getAscii()));
        }
        double strXd = this.uomHelper.toPoints(pStr.getX1(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double strUlY = this.uomHelper.toPoints(pStr.getY2(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double pageHeight = this.uomHelper.toPoints(wi.getPage().getHeight(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double strYd = pageHeight - strUlY;
        BigDecimal strX = BigDecimal.valueOf(strXd).setScale(2, RoundingMode.HALF_UP);
        BigDecimal strY = BigDecimal.valueOf(strYd).setScale(2, RoundingMode.HALF_UP);
        if (wi.getX() == null && wi.getY() == null) {
            strDtX = strX;
            strDtY = strY;
        } else {
            strDtX = strX.subtract(wi.getX());
            strDtY = strY.subtract(wi.getY());
        }
        wi.setX(strX);
        wi.setY(strY);
        String tdStr = String.valueOf(strDtX) + " " + strDtY + " Td\n";
        wi.getBuffer().write(tdStr.getBytes(this.getWriteHelper().getAscii()));
        IPdfObject fnt = wi.getDocument().getResources().getFonts().get(wi.getFontNumber() - 1);
        if (fnt instanceof PdfFontType1S14) {
            String strStr = "(" + pStr.getValue() + ") Tj\n";
            wi.getBuffer().write(strStr.getBytes(this.getWriteHelper().getAscii()));
        } else if (fnt instanceof PdfFontType0) {
            PdfFontType0 fnt0 = (PdfFontType0)fnt;
            sb = sb.delete(0, sb.length());
            sb.append("<");
            for (int i = 0; i < pStr.getValue().length(); ++i) {
                char uni = (char)pStr.getValue().codePointAt(i);
                char cid = fnt0.getToUnicode().getUniToCid().get(Character.valueOf(uni)).charValue();
                sb.append(this.toHexCoder.encode(cid));
            }
            sb.append("> Tj\n");
            wi.getBuffer().write(sb.toString().getBytes(this.getWriteHelper().getAscii()));
        } else {
            throw new ExceptionPdfWr("Unsupported font " + fnt);
        }
    }

    public final PdfWriteHelper getWriteHelper() {
        return this.writeHelper;
    }

    public final void setWriteHelper(PdfWriteHelper pWriteHelper) {
        this.writeHelper = pWriteHelper;
    }

    public final ToHexCoder getToHexCoder() {
        return this.toHexCoder;
    }

    public final void setToHexCoder(ToHexCoder pToHexCoder) {
        this.toHexCoder = pToHexCoder;
    }

    public final UomHelper getUomHelper() {
        return this.uomHelper;
    }

    public final void setUomHelper(UomHelper pUomHelper) {
        this.uomHelper = pUomHelper;
    }
}

