/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.pdf.model.EFontType;
import org.beigesoft.pdf.model.PdfCidFontType2;
import org.beigesoft.pdf.service.AWriterPdfObject;

public class WriterPdfCidFontType2
extends AWriterPdfObject<PdfCidFontType2> {
    @Override
    public final int write(PdfCidFontType2 pPdfObj, OutputStream pOut) throws Exception {
        this.makeWidths(pPdfObj);
        int bytesWritten = 0;
        byte[] btsNumSp = (pPdfObj.getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (pPdfObj.getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        String startStr = "/Type /Font\n";
        bytesWritten += this.getWriteHelper().writeBytes(startStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String subtypeStr = "/Subtype /" + EFontType.CIDFONTTYPE2.toString() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(subtypeStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String baseFontStr = "/BaseFont /" + pPdfObj.getBaseFont() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(baseFontStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String cidToGidMapStr = "/CIDToGIDMap /" + pPdfObj.getCidToGidMap() + "\n";
        bytesWritten += this.getWriteHelper().writeBytes(cidToGidMapStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        String cidInfoStr = "/CIDSystemInfo <</Registry (Adobe) /Ordering (Identity) /Supplement 0>>\n";
        bytesWritten += this.getWriteHelper().writeBytes(cidInfoStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartWarray(), pOut);
        for (String wdStr : pPdfObj.getWidthsList()) {
            bytesWritten += this.getWriteHelper().writeBytes(wdStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndArrLf(), pOut);
        String fontDescriptorStr = "/FontDescriptor " + pPdfObj.getFontDescriptor().getNumber() + " " + pPdfObj.getFontDescriptor().getGenNumber() + " R";
        bytesWritten += this.getWriteHelper().writeBytes(fontDescriptorStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndObjLf(), pOut);
    }

    public final void makeWidths(PdfCidFontType2 pPdfObj) throws Exception {
        pPdfObj.getWidthsList().clear();
        double scaling = 1000.0 / (double)pPdfObj.getUnitsPerEm();
        Character cidStart = null;
        Character cidEnd = null;
        ArrayList<BigDecimal> wdthsArr = new ArrayList<BigDecimal>();
        for (Character cid : pPdfObj.getToUnicode().getUsedCids()) {
            double widthF = pPdfObj.getHmtx().getWidthForGid(cid.charValue());
            BigDecimal width = BigDecimal.valueOf(widthF * scaling).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
            if (cidStart == null) {
                cidStart = cid;
                cidEnd = cid;
                wdthsArr.add(width);
                continue;
            }
            if (cid.charValue() - cidEnd.charValue() == 0) {
                throw new ExceptionPdfWr("Duplicate CID: " + cid);
            }
            if (cid.charValue() - cidEnd.charValue() == 1) {
                cidEnd = cid;
                if (wdthsArr.size() > 1 || width.compareTo((BigDecimal)wdthsArr.get(0)) != 0 && cid.charValue() - cidStart.charValue() == 1) {
                    wdthsArr.add(width);
                    cidEnd = cid;
                    continue;
                }
                if (wdthsArr.size() == 1 && width.compareTo((BigDecimal)wdthsArr.get(0)) != 0 && cid.charValue() - cidStart.charValue() != 1) {
                    this.finishWidthsEntry(pPdfObj, cidStart, cidEnd, wdthsArr);
                    cidStart = cid;
                    cidEnd = cid;
                    wdthsArr.clear();
                    wdthsArr.add(width);
                    continue;
                }
                cidEnd = cid;
                continue;
            }
            this.finishWidthsEntry(pPdfObj, cidStart, cidEnd, wdthsArr);
            cidStart = cid;
            cidEnd = cid;
            wdthsArr.clear();
            wdthsArr.add(width);
        }
        this.finishWidthsEntry(pPdfObj, cidStart, cidEnd, wdthsArr);
    }

    public final void finishWidthsEntry(PdfCidFontType2 pPdfObj, Character pCidStart, Character pCidEnd, List<BigDecimal> pWdthsArr) {
        StringBuffer sb = new StringBuffer();
        if (pCidEnd.charValue() - pCidStart.charValue() == 0) {
            pPdfObj.getWidthsList().add(String.valueOf((int)pCidStart.charValue()) + " [" + pWdthsArr.get(0).toPlainString() + "] ");
        } else if (pWdthsArr.size() > 1) {
            sb.append(String.valueOf((int)pCidStart.charValue()) + " [");
            for (int i = 0; i < pWdthsArr.size(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(pWdthsArr.get(i).toPlainString());
            }
            sb.append("] ");
            pPdfObj.getWidthsList().add(sb.toString());
        } else {
            pPdfObj.getWidthsList().add(String.valueOf((int)pCidStart.charValue()) + " " + pCidEnd.charValue() + " " + pWdthsArr.get(0).toPlainString() + " ");
        }
    }
}

