/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import org.beigesoft.doc.model.IElement;
import org.beigesoft.pdf.model.EGraphicState;
import org.beigesoft.pdf.model.ETextState;
import org.beigesoft.pdf.model.IHasPdfContent;
import org.beigesoft.pdf.model.PdfContent;
import org.beigesoft.pdf.service.AWriterPdfStream;
import org.beigesoft.pdf.service.IFctHasPdfContent;

public class WriterPdfContent
extends AWriterPdfStream<PdfContent, PdfContent> {
    private IFctHasPdfContent fctHasPdfContent;
    private Comparator<IElement<?>> cmpElement;

    @Override
    public final void writeToBuffer(PdfContent pContent, OutputStream pOut) throws Exception {
        Collections.sort(pContent.getPage().getElements(), this.cmpElement);
        this.resetWriteState(pContent);
        IHasPdfContent wi = this.fctHasPdfContent.createHasPdfContent(pContent);
        for (IElement<? extends IHasPdfContent> el : pContent.getPage().getElements()) {
            el.write(wi);
        }
        this.handleEnd(pContent);
    }

    public final void handleEnd(PdfContent pContent) throws Exception {
        if (pContent.getTextState().equals((Object)ETextState.STARTED)) {
            pContent.getBuffer().write("ET\n".getBytes(this.getWriteHelper().getAscii()));
            pContent.setTextState(ETextState.ENDED);
        }
        if (pContent.getGraphicState().equals((Object)EGraphicState.STARTED)) {
            pContent.getBuffer().write("S\n".getBytes(this.getWriteHelper().getAscii()));
            pContent.setGraphicState(EGraphicState.ENDED);
        }
    }

    public final void resetWriteState(PdfContent pContent) throws Exception {
        pContent.setGraphicState(EGraphicState.ENDED);
        pContent.setTextState(ETextState.ENDED);
        pContent.setX(null);
        pContent.setY(null);
        pContent.setFontNumber(0);
        pContent.setFontSize(BigDecimal.ZERO);
        pContent.setLineWidth(BigDecimal.ZERO);
    }

    public final IFctHasPdfContent getFctHasPdfContent() {
        return this.fctHasPdfContent;
    }

    public final void setFctHasPdfContent(IFctHasPdfContent pFctHasPdfContent) {
        this.fctHasPdfContent = pFctHasPdfContent;
    }

    public final Comparator<IElement<?>> getCmpElement() {
        return this.cmpElement;
    }

    public final void setCmpElement(Comparator<IElement<?>> pCmpElement) {
        this.cmpElement = pCmpElement;
    }
}

