/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Reader;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.replicator.service.IDatabaseReader;
import org.beigesoft.replicator.service.ISrvEntityReader;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.service.IUtilXml;

public class DatabaseReaderIdenticalXml<RS>
implements IDatabaseReader {
    private ISrvEntityReader srvEntityReader;
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private IUtilXml utilXml;

    @Override
    public final void readAndStoreEntities(Map<String, Object> pAddParam, Reader pReader) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            while (this.utilXml.readUntilStart(pReader, "entity")) {
                Object entity = this.srvEntityReader.read(pAddParam, pReader);
                this.srvOrm.insertEntity(pAddParam, entity);
            }
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvEntityReader getSrvEntityReader() {
        return this.srvEntityReader;
    }

    public final void setSrvEntityReader(ISrvEntityReader pSrvEntityReader) {
        this.srvEntityReader = pSrvEntityReader;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IUtilXml getUtilXml() {
        return this.utilXml;
    }

    public final void setUtilXml(IUtilXml pUtilXml) {
        this.utilXml = pUtilXml;
    }
}

